/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.AbstractJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.LongChain;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.griffin.model.JoinContext;
import io.questdb.std.Misc;

public class HashOuterJoinLightRecordCursorFactory
extends AbstractJoinRecordCursorFactory {
    private final HashOuterJoinLightRecordCursor cursor;
    private final RecordSink masterKeySink;
    private final RecordSink slaveKeySink;

    public HashOuterJoinLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit, JoinContext context) {
        super(metadata, context, masterFactory, slaveFactory);
        try {
            this.masterKeySink = masterKeySink;
            this.slaveKeySink = slaveKeySink;
            this.cursor = new HashOuterJoinLightRecordCursor(columnSplit, NullRecordFactory.getInstance(slaveFactory.getMetadata()), joinColumnTypes, valueTypes, configuration);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor slaveCursor = this.slaveFactory.getCursor(executionContext);
        RecordCursor masterCursor = null;
        try {
            masterCursor = this.masterFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Hash Outer Join Light");
        sink.optAttr((CharSequence)"condition", this.joinContext);
        sink.child(this.masterFactory);
        sink.child("Hash", this.slaveFactory);
    }

    private static void populateRowIDHashMap(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor cursor, Map keyMap, RecordSink recordSink, LongChain rowIDChain) {
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            MapKey key = keyMap.withKey();
            key.put(record, recordSink);
            MapValue value = key.createValue();
            if (value.isNew()) {
                value.putInt(0, rowIDChain.put(record.getRowId(), -1));
                continue;
            }
            value.putInt(0, rowIDChain.put(record.getRowId(), value.getInt(0)));
        }
    }

    @Override
    protected void _close() {
        Misc.freeIfCloseable(this.getMetadata());
        Misc.free(this.masterFactory);
        Misc.free(this.slaveFactory);
        Misc.free(this.cursor);
    }

    private class HashOuterJoinLightRecordCursor
    extends AbstractJoinCursor {
        private final Map joinKeyMap;
        private final OuterJoinRecord record;
        private final LongChain slaveChain;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isMapBuilt;
        private boolean isOpen;
        private Record masterRecord;
        private LongChain.Cursor slaveChainCursor;
        private Record slaveRecord;

        public HashOuterJoinLightRecordCursor(int columnSplit, Record nullRecord, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, CairoConfiguration configuration) {
            super(columnSplit);
            try {
                this.isOpen = true;
                this.joinKeyMap = MapFactory.createUnorderedMap(configuration, joinColumnTypes, valueTypes);
                this.slaveChain = new LongChain(configuration.getSqlHashJoinLightValuePageSize(), configuration.getSqlHashJoinLightValueMaxPages());
                this.record = new OuterJoinRecord(columnSplit, nullRecord);
            }
            catch (Throwable th) {
                this.close();
                throw th;
            }
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMap.close();
                this.slaveChain.close();
                super.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public long preComputedStateSize() {
            return RecordCursor.fromBool(this.isMapBuilt);
        }

        @Override
        public boolean hasNext() {
            if (!this.isMapBuilt) {
                HashOuterJoinLightRecordCursorFactory.populateRowIDHashMap(this.circuitBreaker, this.slaveCursor, this.joinKeyMap, HashOuterJoinLightRecordCursorFactory.this.slaveKeySink, this.slaveChain);
                this.isMapBuilt = true;
            }
            if (this.slaveChainCursor != null && this.slaveChainCursor.hasNext()) {
                this.slaveCursor.recordAt(this.slaveRecord, this.slaveChainCursor.next());
                return true;
            }
            if (this.masterCursor.hasNext()) {
                MapKey key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, HashOuterJoinLightRecordCursorFactory.this.masterKeySink);
                MapValue value = key.findValue();
                if (value != null) {
                    this.slaveChainCursor = this.slaveChain.getCursor(value.getInt(0));
                    this.slaveChainCursor.hasNext();
                    this.slaveCursor.recordAt(this.slaveRecord, this.slaveChainCursor.next());
                    this.record.hasSlave(true);
                } else {
                    this.slaveChainCursor = null;
                    this.record.hasSlave(false);
                }
                return true;
            }
            return false;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.slaveChainCursor = null;
            if (!this.isMapBuilt) {
                this.slaveCursor.toTop();
                this.joinKeyMap.clear();
                this.slaveChain.clear();
            }
        }

        private void of(RecordCursor masterCursor, RecordCursor slaveCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.slaveChain.reopen();
                this.joinKeyMap.reopen();
            }
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.circuitBreaker = circuitBreaker;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecord = slaveCursor.getRecordB();
            this.record.of(this.masterRecord, this.slaveRecord);
            this.slaveChainCursor = null;
            this.isMapBuilt = false;
        }
    }
}

