/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.MessageBus;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.sql.AtomicBooleanCircuitBreaker;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameAddressCache;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PageFrameMemoryPool;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.async.WorkStealingStrategy;
import io.questdb.cairo.sql.async.WorkStealingStrategyFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.PerWorkerLocks;
import io.questdb.griffin.engine.groupby.vect.GroupByNotKeyedVectorRecordCursorFactory;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateEntry;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.mp.Worker;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Rosti;
import io.questdb.std.RostiAllocFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.tasks.VectorAggregateTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class GroupByRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final Log LOG = LogFactory.getLog(GroupByRecordCursorFactory.class);
    private static final int ROSTI_MINIMIZED_SIZE = 16;
    private final RecordCursorFactory base;
    private final RostiRecordCursor cursor;
    private final SOUnboundedCountDownLatch doneLatch = new SOUnboundedCountDownLatch();
    private final ObjectPool<VectorAggregateEntry> entryPool;
    private final PageFrameAddressCache frameAddressCache;
    private final ObjList<PageFrameMemoryPool> frameMemoryPools;
    private final int keyColumnIndex;
    private final AtomicInteger oomCounter = new AtomicInteger();
    private final long[] pRosti;
    private final PerWorkerLocks perWorkerLocks;
    private final RostiAllocFacade raf;
    private final AtomicBooleanCircuitBreaker sharedCircuitBreaker;
    private final AtomicInteger startedCounter = new AtomicInteger();
    private final ObjList<VectorAggregateFunction> vafList;
    private final WorkStealingStrategy workStealingStrategy;
    private final int workerCount;

    public GroupByRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, RecordMetadata metadata, ColumnTypes columnTypes, int workerCount, ObjList<VectorAggregateFunction> vafList, int keyColumnIndexInBase, int keyColumnIndexInThisCursor, @Nullable IntList symbolTableSkewIndex) {
        super(metadata);
        try {
            this.workerCount = workerCount;
            this.entryPool = new ObjectPool<VectorAggregateEntry>(VectorAggregateEntry::new, configuration.getGroupByPoolCapacity());
            this.base = base;
            this.frameAddressCache = new PageFrameAddressCache(configuration);
            this.perWorkerLocks = new PerWorkerLocks(configuration, workerCount);
            this.sharedCircuitBreaker = new AtomicBooleanCircuitBreaker();
            this.workStealingStrategy = WorkStealingStrategyFactory.getInstance(configuration, workerCount);
            this.workStealingStrategy.of(this.startedCounter);
            this.pRosti = new long[workerCount];
            int vafCount = vafList.size();
            this.vafList = new ObjList(vafCount);
            this.vafList.addAll(vafList);
            this.raf = configuration.getRostiAllocFacade();
            for (int i = 0; i < workerCount; ++i) {
                long ptr = this.raf.alloc(columnTypes, configuration.getGroupByMapCapacity());
                if (ptr == 0L) {
                    for (int k = i - 1; k > -1; --k) {
                        this.raf.free(this.pRosti[k]);
                        this.pRosti[k] = 0L;
                    }
                    throw CairoException.nonCritical().put("could not allocate rosti hash table").setOutOfMemory(true);
                }
                this.pRosti[i] = ptr;
                switch (ColumnType.tagOf(columnTypes.getColumnType(0))) {
                    case 5: {
                        Unsafe.getUnsafe().putInt(Rosti.getInitialValueSlot(this.pRosti[i], 0), Integer.MIN_VALUE);
                        break;
                    }
                    case 12: {
                        Unsafe.getUnsafe().putInt(Rosti.getInitialValueSlot(this.pRosti[i], 0), Integer.MIN_VALUE);
                        break;
                    }
                }
                for (int j = 0; j < vafCount; ++j) {
                    this.vafList.getQuick(j).initRosti(this.pRosti[i]);
                }
            }
            long pRosti = this.pRosti[0];
            long columnOffsets = Rosti.getValueOffsets(pRosti);
            IntList columnSkewIndex = new IntList();
            GroupByRecordCursorFactory.addOffsets(columnSkewIndex, this.vafList, 0, keyColumnIndexInThisCursor, columnOffsets);
            columnSkewIndex.add(0);
            GroupByRecordCursorFactory.addOffsets(columnSkewIndex, this.vafList, keyColumnIndexInThisCursor, vafCount, columnOffsets);
            this.keyColumnIndex = keyColumnIndexInBase;
            if (symbolTableSkewIndex != null && symbolTableSkewIndex.size() > 0) {
                IntList symbolSkew = new IntList(symbolTableSkewIndex.size());
                symbolSkew.addAll(symbolTableSkewIndex);
                this.cursor = new RostiRecordCursor(pRosti, columnTypes.getColumnCount(), columnSkewIndex, symbolSkew);
            } else {
                this.cursor = new RostiRecordCursor(pRosti, columnTypes.getColumnCount(), columnSkewIndex, null);
            }
            this.frameMemoryPools = new ObjList(workerCount);
            for (int i = 0; i < workerCount; ++i) {
                this.frameMemoryPools.add(new PageFrameMemoryPool(1));
            }
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        int i;
        this.oomCounter.set(0);
        int n = this.pRosti.length;
        for (i = 0; i < n; ++i) {
            this.raf.clear(this.pRosti[i]);
        }
        n = this.vafList.size();
        for (i = 0; i < n; ++i) {
            this.vafList.getQuick(i).clear();
        }
        PageFrameCursor pageFrameCursor = this.base.getPageFrameCursor(executionContext, 0);
        return this.cursor.of(this.base.getMetadata(), pageFrameCursor, executionContext.getMessageBus(), executionContext.getCircuitBreaker());
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("GroupBy");
        sink.meta("vectorized").val(true);
        sink.meta("workers").val(this.workerCount);
        sink.attr("keys").val("[").putBaseColumnName(this.keyColumnIndex).val("]");
        sink.optAttr((CharSequence)"values", this.vafList, true);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    private static void addOffsets(IntList columnSkewIndex, ObjList<VectorAggregateFunction> vafList, int start, int end, long columnOffsets) {
        for (int i = start; i < end; ++i) {
            columnSkewIndex.add(Unsafe.getUnsafe().getInt(columnOffsets + (long)vafList.getQuick(i).getValueOffset() * 4L));
        }
    }

    private void resetRostiMemorySize() {
        int n = this.pRosti.length;
        for (int i = 0; i < n; ++i) {
            if (this.raf.reset(this.pRosti[i], 16)) continue;
            LOG.debug().$("could not minimize rosti memory [i=").$(i).$(", currentSize=").$(Rosti.getSize(this.pRosti[i])).I$();
        }
    }

    @Override
    protected void _close() {
        Misc.freeObjListAndKeepObjects(this.frameMemoryPools);
        Misc.freeObjList(this.vafList);
        int n = this.pRosti.length;
        for (int i = 0; i < n; ++i) {
            if (this.pRosti[i] == 0L) continue;
            this.raf.free(this.pRosti[i]);
            this.pRosti[i] = 0L;
        }
        Misc.free(this.base);
    }

    private class RostiRecordCursor
    implements RecordCursor {
        private final int columnCount;
        private final IntList columnSkewIndex;
        private final RostiRecord record;
        private final IntList symbolTableSkewIndex;
        private MessageBus bus;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private long count;
        private long ctrl;
        private long ctrlStart;
        private int frameCount;
        private PageFrameCursor frameCursor;
        private boolean isRostiBuilt;
        private long pRostiBig;
        private RostiRecord recordB;
        private long shift;
        private long size;
        private long slots;

        public RostiRecordCursor(long pRosti, int columnCount, IntList columnSkewIndex, IntList symbolTableSkewIndex) {
            this.pRostiBig = pRosti;
            this.columnCount = columnCount;
            this.record = new RostiRecord(columnCount);
            this.symbolTableSkewIndex = symbolTableSkewIndex;
            this.columnSkewIndex = columnSkewIndex;
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            if (!this.isRostiBuilt) {
                this.buildRosti();
                this.isRostiBuilt = true;
            }
            if (this.count < this.size) {
                counter.add(this.size - this.count);
                this.count = this.size;
            }
        }

        @Override
        public void close() {
            GroupByRecordCursorFactory.this.frameAddressCache.clear();
            this.frameCursor = Misc.free(this.frameCursor);
            GroupByRecordCursorFactory.this.raf.reset(this.pRostiBig, 16);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public Record getRecordB() {
            if (this.recordB != null) {
                return this.recordB;
            }
            this.recordB = new RostiRecord(this.columnCount);
            return this.recordB;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.frameCursor.getSymbolTable(this.symbolTableSkewIndex.getQuick(columnIndex));
        }

        @Override
        public boolean hasNext() {
            if (!this.isRostiBuilt) {
                this.buildRosti();
                this.isRostiBuilt = true;
            }
            while (this.count < this.size) {
                byte b = Unsafe.getUnsafe().getByte(this.ctrl);
                if ((b & 0x80) != 0) {
                    ++this.ctrl;
                    continue;
                }
                ++this.count;
                this.record.of(this.slots + (this.ctrl - this.ctrlStart << (int)this.shift));
                ++this.ctrl;
                return true;
            }
            return false;
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.frameCursor.newSymbolTable(this.symbolTableSkewIndex.getQuick(columnIndex));
        }

        public RostiRecordCursor of(RecordMetadata metadata, PageFrameCursor frameCursor, MessageBus bus, SqlExecutionCircuitBreaker circuitBreaker) {
            this.frameCursor = frameCursor;
            this.bus = bus;
            this.circuitBreaker = circuitBreaker;
            GroupByRecordCursorFactory.this.frameAddressCache.of(metadata, frameCursor.getColumnIndexes());
            for (int i = 0; i < GroupByRecordCursorFactory.this.workerCount; ++i) {
                GroupByRecordCursorFactory.this.frameMemoryPools.getQuick(i).of(GroupByRecordCursorFactory.this.frameAddressCache);
            }
            this.frameCount = 0;
            this.isRostiBuilt = false;
            return this;
        }

        @Override
        public long preComputedStateSize() {
            return this.isRostiBuilt ? 1L : 0L;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            ((RostiRecord)record).of(atRowId);
        }

        @Override
        public long size() {
            return this.isRostiBuilt ? this.size : -1L;
        }

        @Override
        public void toTop() {
            this.ctrl = this.ctrlStart = Rosti.getCtrl(this.pRostiBig);
            this.slots = Rosti.getSlots(this.pRostiBig);
            this.size = GroupByRecordCursorFactory.this.raf.getSize(this.pRostiBig);
            this.shift = Rosti.getSlotShift(this.pRostiBig);
            this.count = 0L;
        }

        private void buildRosti() {
            int vafCount = GroupByRecordCursorFactory.this.vafList.size();
            RingQueue<VectorAggregateTask> queue = this.bus.getVectorAggregateQueue();
            MPSequence pubSeq = this.bus.getVectorAggregatePubSeq();
            GroupByRecordCursorFactory.this.sharedCircuitBreaker.reset();
            GroupByRecordCursorFactory.this.startedCounter.set(0);
            GroupByRecordCursorFactory.this.doneLatch.reset();
            GroupByRecordCursorFactory.this.entryPool.clear();
            int queuedCount = 0;
            int ownCount = 0;
            int reclaimed = 0;
            int total = 0;
            int mergedCount = 0;
            Thread thread = Thread.currentThread();
            int workerId = thread instanceof Worker ? ((Worker)thread).getWorkerId() % GroupByRecordCursorFactory.this.workerCount : -1;
            try {
                PageFrame frame;
                while ((frame = this.frameCursor.next()) != null) {
                    GroupByRecordCursorFactory.this.frameAddressCache.add(this.frameCount++, frame);
                }
                for (int frameIndex = 0; frameIndex < this.frameCount; ++frameIndex) {
                    long frameRowCount = GroupByRecordCursorFactory.this.frameAddressCache.getFrameSize(frameIndex);
                    block10: for (int vafIndex = 0; vafIndex < vafCount; ++vafIndex) {
                        long cursor;
                        VectorAggregateFunction vaf = GroupByRecordCursorFactory.this.vafList.getQuick(vafIndex);
                        int valueColumnIndex = vaf.getColumnIndex();
                        while ((cursor = pubSeq.next()) < 0L) {
                            this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                            if (GroupByRecordCursorFactory.this.workStealingStrategy.shouldSteal(mergedCount)) {
                                VectorAggregateEntry.aggregateUnsafe(workerId, GroupByRecordCursorFactory.this.oomCounter, frameIndex, frameRowCount, GroupByRecordCursorFactory.this.keyColumnIndex, valueColumnIndex, GroupByRecordCursorFactory.this.pRosti, GroupByRecordCursorFactory.this.frameMemoryPools, GroupByRecordCursorFactory.this.raf, vaf, GroupByRecordCursorFactory.this.perWorkerLocks, this.circuitBreaker);
                                ++ownCount;
                                ++total;
                                mergedCount = GroupByRecordCursorFactory.this.doneLatch.getCount();
                                continue block10;
                            }
                            mergedCount = GroupByRecordCursorFactory.this.doneLatch.getCount();
                        }
                        VectorAggregateEntry entry = GroupByRecordCursorFactory.this.entryPool.next();
                        entry.of(frameIndex, frameRowCount, GroupByRecordCursorFactory.this.keyColumnIndex, valueColumnIndex, vaf, GroupByRecordCursorFactory.this.pRosti, GroupByRecordCursorFactory.this.frameMemoryPools, GroupByRecordCursorFactory.this.startedCounter, GroupByRecordCursorFactory.this.doneLatch, GroupByRecordCursorFactory.this.oomCounter, GroupByRecordCursorFactory.this.raf, GroupByRecordCursorFactory.this.perWorkerLocks, GroupByRecordCursorFactory.this.sharedCircuitBreaker);
                        queue.get((long)cursor).entry = entry;
                        pubSeq.done(cursor);
                        ++queuedCount;
                        ++total;
                    }
                }
            }
            catch (DataUnavailableException e) {
                throw e;
            }
            catch (Throwable e) {
                GroupByRecordCursorFactory.this.sharedCircuitBreaker.cancel();
                Misc.freeObjListAndKeepObjects(GroupByRecordCursorFactory.this.frameMemoryPools);
                throw e;
            }
            finally {
                reclaimed = GroupByNotKeyedVectorRecordCursorFactory.runWhatsLeft(this.bus.getVectorAggregateSubSeq(), queue, queuedCount, reclaimed, mergedCount, workerId, GroupByRecordCursorFactory.this.doneLatch, this.circuitBreaker, GroupByRecordCursorFactory.this.sharedCircuitBreaker, GroupByRecordCursorFactory.this.workStealingStrategy);
                if (GroupByRecordCursorFactory.this.sharedCircuitBreaker.checkIfTripped()) {
                    GroupByRecordCursorFactory.this.resetRostiMemorySize();
                }
            }
            Misc.freeObjListAndKeepObjects(GroupByRecordCursorFactory.this.frameMemoryPools);
            if (GroupByRecordCursorFactory.this.oomCounter.get() > 0) {
                GroupByRecordCursorFactory.this.resetRostiMemorySize();
                throw CairoException.nonCritical().put("could not resize rosti hash table").setOutOfMemory(true);
            }
            this.pRostiBig = GroupByRecordCursorFactory.this.pRosti[0];
            try {
                if (GroupByRecordCursorFactory.this.pRosti.length > 1) {
                    int i;
                    LOG.debug().$("merging").$();
                    long size = GroupByRecordCursorFactory.this.raf.getSize(this.pRostiBig);
                    int n = GroupByRecordCursorFactory.this.pRosti.length;
                    for (i = 1; i < n; ++i) {
                        long curSize = GroupByRecordCursorFactory.this.raf.getSize(GroupByRecordCursorFactory.this.pRosti[i]);
                        if (curSize <= size) continue;
                        size = curSize;
                        this.pRostiBig = GroupByRecordCursorFactory.this.pRosti[i];
                    }
                    for (int j = 0; j < vafCount; ++j) {
                        VectorAggregateFunction vaf = GroupByRecordCursorFactory.this.vafList.getQuick(j);
                        int n2 = GroupByRecordCursorFactory.this.pRosti.length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            if (this.pRostiBig == GroupByRecordCursorFactory.this.pRosti[i2] || GroupByRecordCursorFactory.this.raf.getSize(GroupByRecordCursorFactory.this.pRosti[i2]) < 1L) continue;
                            this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                            long oldSize = Rosti.getAllocMemory(this.pRostiBig);
                            if (!vaf.merge(this.pRostiBig, GroupByRecordCursorFactory.this.pRosti[i2])) {
                                GroupByRecordCursorFactory.this.resetRostiMemorySize();
                                throw CairoException.nonCritical().put("could not merge rosti hash table").setOutOfMemory(true);
                            }
                            GroupByRecordCursorFactory.this.raf.updateMemoryUsage(this.pRostiBig, oldSize);
                        }
                        this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                        long oldSize = Rosti.getAllocMemory(this.pRostiBig);
                        if (!vaf.wrapUp(this.pRostiBig)) {
                            GroupByRecordCursorFactory.this.resetRostiMemorySize();
                            throw CairoException.nonCritical().put("could not wrap up rosti hash table").setOutOfMemory(true);
                        }
                        GroupByRecordCursorFactory.this.raf.updateMemoryUsage(this.pRostiBig, oldSize);
                    }
                    this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                    n = GroupByRecordCursorFactory.this.pRosti.length;
                    for (i = 0; i < n; ++i) {
                        if (this.pRostiBig == GroupByRecordCursorFactory.this.pRosti[i] || GroupByRecordCursorFactory.this.raf.reset(GroupByRecordCursorFactory.this.pRosti[i], 16)) continue;
                        LOG.debug().$("couldn't minimize rosti memory [i=").$(i).$(",currentSize=").$(Rosti.getSize(GroupByRecordCursorFactory.this.pRosti[i])).I$();
                    }
                } else {
                    this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                    for (int j = 0; j < vafCount; ++j) {
                        if (GroupByRecordCursorFactory.this.vafList.getQuick(j).wrapUp(this.pRostiBig)) continue;
                        GroupByRecordCursorFactory.this.resetRostiMemorySize();
                        throw CairoException.nonCritical().put("could not wrap up rosti hash table").setOutOfMemory(true);
                    }
                }
            }
            catch (Throwable t) {
                GroupByRecordCursorFactory.this.resetRostiMemorySize();
                throw t;
            }
            this.toTop();
            LOG.info().$("done [total=").$(total).$(", ownCount=").$(ownCount).$(", reclaimed=").$(reclaimed).$(", queuedCount=").$(queuedCount).I$();
        }

        private class RostiRecord
        implements Record {
            private final ObjList<Long256Impl> longs256A;
            private final ObjList<Long256Impl> longs256B;
            private long pRow;

            public RostiRecord(int columnCount) {
                this.longs256A = new ObjList(columnCount);
                this.longs256B = new ObjList(columnCount);
            }

            @Override
            public long getDate(int col) {
                return this.getLong(col);
            }

            @Override
            public double getDouble(int col) {
                return Unsafe.getUnsafe().getDouble(this.getValueAddress(col));
            }

            @Override
            public float getFloat(int col) {
                return 0.0f;
            }

            @Override
            public byte getGeoByte(int col) {
                return this.getByte(col);
            }

            @Override
            public int getGeoInt(int col) {
                return this.getInt(col);
            }

            @Override
            public long getGeoLong(int col) {
                return this.getLong(col);
            }

            @Override
            public short getGeoShort(int col) {
                return this.getShort(col);
            }

            @Override
            public int getIPv4(int col) {
                return Unsafe.getUnsafe().getInt(this.getValueAddress(col));
            }

            @Override
            public int getInt(int col) {
                return Unsafe.getUnsafe().getInt(this.getValueAddress(col));
            }

            @Override
            public long getLong(int col) {
                return Unsafe.getUnsafe().getLong(this.getValueAddress(col));
            }

            @Override
            public void getLong256(int col, CharSink<?> sink) {
                Long256Impl v = (Long256Impl)this.getLong256A(col);
                v.toSink(sink);
            }

            @Override
            public Long256 getLong256A(int col) {
                return this.getLong256Value(this.long256A(col), col);
            }

            @Override
            public Long256 getLong256B(int col) {
                return this.getLong256Value(this.long256B(col), col);
            }

            public Long256 getLong256Value(Long256 dst, int col) {
                dst.fromAddress(this.getValueAddress(col));
                return dst;
            }

            @Override
            public long getRowId() {
                return this.pRow;
            }

            @Override
            public short getShort(int col) {
                return 0;
            }

            @Override
            public CharSequence getStrA(int col) {
                return null;
            }

            @Override
            public CharSequence getStrB(int col) {
                return null;
            }

            @Override
            public int getStrLen(int col) {
                return 0;
            }

            @Override
            public CharSequence getSymA(int col) {
                return RostiRecordCursor.this.frameCursor.getSymbolTable(RostiRecordCursor.this.symbolTableSkewIndex.getQuick(col)).valueOf(this.getInt(col));
            }

            @Override
            public CharSequence getSymB(int col) {
                return RostiRecordCursor.this.frameCursor.getSymbolTable(RostiRecordCursor.this.symbolTableSkewIndex.getQuick(col)).valueBOf(this.getInt(col));
            }

            @Override
            public long getTimestamp(int col) {
                return this.getLong(col);
            }

            public void of(long pRow) {
                this.pRow = pRow;
            }

            private long getValueAddress(int column) {
                return this.pRow + (long)RostiRecordCursor.this.columnSkewIndex.getQuick(column);
            }

            private Long256Impl long256A(int columnIndex) {
                if (this.longs256A.getQuiet(columnIndex) == null) {
                    this.longs256A.extendAndSet(columnIndex, new Long256Impl());
                }
                return this.longs256A.getQuick(columnIndex);
            }

            private Long256Impl long256B(int columnIndex) {
                if (this.longs256B.getQuiet(columnIndex) == null) {
                    this.longs256B.extendAndSet(columnIndex, new Long256Impl());
                }
                return this.longs256B.getQuick(columnIndex);
            }
        }
    }
}

