/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.griffin.engine.groupby.AbstractNoRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.AbstractSampleByNotKeyedRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdaterFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNullRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillValueNotKeyedRecordCursor;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.groupby.SimpleMapValuePeeker;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class SampleByFillNullNotKeyedRecordCursorFactory
extends AbstractSampleByNotKeyedRecordCursorFactory {
    private final SampleByFillValueNotKeyedRecordCursor cursor;

    public SampleByFillNullNotKeyedRecordCursorFactory(@NotNull BytecodeAssembler asm, CairoConfiguration configuration, RecordCursorFactory base, @NotNull TimestampSampler timestampSampler, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, @NotNull IntList recordFunctionPositions, int valueCount, int timestampIndex, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos, Function sampleFromFunc, int sampleFromFuncPos, Function sampleToFunc, int sampleToFuncPos) throws SqlException {
        super(base, groupByMetadata, recordFunctions);
        try {
            SimpleMapValue simpleMapValue = new SimpleMapValue(valueCount);
            SimpleMapValuePeeker peeker = new SimpleMapValuePeeker(simpleMapValue, new SimpleMapValue(valueCount));
            GroupByFunctionsUpdater groupByFunctionsUpdater = GroupByFunctionsUpdaterFactory.getInstance(asm, groupByFunctions);
            this.cursor = new SampleByFillValueNotKeyedRecordCursor(configuration, groupByFunctions, groupByFunctionsUpdater, recordFunctions, SampleByFillNullRecordCursorFactory.createPlaceholderFunctions(recordFunctions, recordFunctionPositions), peeker, timestampIndex, timestampSampler, simpleMapValue, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
            peeker.setCursor(this.cursor);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Sample By");
        sink.attr("fill").val("null");
        if (this.cursor.sampleFromFunc != TimestampConstant.NULL || this.cursor.sampleToFunc != TimestampConstant.NULL) {
            sink.attr("range").val('(').val(this.cursor.sampleFromFunc).val(',').val(this.cursor.sampleToFunc).val(')');
        }
        sink.optAttr((CharSequence)"values", this.cursor.groupByFunctions, true);
        sink.child(this.base);
    }

    @Override
    protected AbstractNoRecordSampleByCursor getRawCursor() {
        return this.cursor;
    }
}

