/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractNoRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.AbstractSampleByRecordCursorFactory;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdaterFactory;
import io.questdb.griffin.engine.groupby.GroupByRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillNoneRecordCursor;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class SampleByFillNoneRecordCursorFactory
extends AbstractSampleByRecordCursorFactory {
    private final SampleByFillNoneRecordCursor cursor;

    public SampleByFillNoneRecordCursorFactory(@NotNull BytecodeAssembler asm, CairoConfiguration configuration, RecordCursorFactory base, RecordMetadata groupByMetadata, @NotNull ObjList<GroupByFunction> groupByFunctions, @NotNull ObjList<Function> recordFunctions, @NotNull TimestampSampler timestampSampler, @NotNull ListColumnFilter listColumnFilter, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, int timestampIndex, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos, Function sampleFromFunc, int sampleFromFuncPos, Function sampleToFunc, int sampleToFuncPos) {
        super(base, groupByMetadata, recordFunctions);
        try {
            RecordSink mapSink = RecordSinkFactory.getInstance(asm, base.getMetadata(), listColumnFilter);
            Map map = MapFactory.createOrderedMap(configuration, keyTypes, valueTypes);
            GroupByFunctionsUpdater groupByFunctionsUpdater = GroupByFunctionsUpdaterFactory.getInstance(asm, groupByFunctions);
            this.cursor = new SampleByFillNoneRecordCursor(configuration, map, mapSink, groupByFunctions, groupByFunctionsUpdater, this.recordFunctions, timestampIndex, timestampSampler, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        return this.initFunctionsAndCursor(executionContext, baseCursor);
    }

    @Override
    public AbstractNoRecordSampleByCursor getRawCursor() {
        return this.cursor;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Sample By");
        sink.optAttr((CharSequence)"keys", GroupByRecordCursorFactory.getKeys(this.recordFunctions, this.getMetadata()));
        sink.optAttr((CharSequence)"values", this.cursor.groupByFunctions, true);
        sink.child(this.base);
    }

    @Override
    protected void _close() {
        Misc.free(this.cursor);
        super._close();
    }
}

