/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AsciiCharSequence;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GroupByUtf8Sink
implements Utf8Sink,
Utf8Sequence {
    private static final long HEADER_SIZE = 9L;
    private static final long IS_ASCII_OFFSET = 8L;
    private static final int MIN_CAPACITY = 8;
    private static final long SIZE_OFFSET = 4L;
    private GroupByAllocator allocator;
    private AsciiCharSequence asciiCharSequence;
    private long ptr;

    @Override
    @NotNull
    public CharSequence asAsciiCharSequence() {
        if (this.asciiCharSequence == null) {
            this.asciiCharSequence = new AsciiCharSequence();
        }
        this.asciiCharSequence.of(this);
        return this.asciiCharSequence;
    }

    @Override
    public byte byteAt(int index) {
        assert (this.ptr != 0L);
        return Unsafe.getUnsafe().getByte(this.ptr + 9L + (long)index);
    }

    public int capacity() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr) : 0;
    }

    public void clear() {
        if (this.ptr != 0L) {
            Unsafe.getUnsafe().putInt(this.ptr + 4L, 0);
            Unsafe.getUnsafe().putBoolean(null, this.ptr + 8L, true);
        }
    }

    @Override
    public boolean isAscii() {
        return this.ptr == 0L || Unsafe.getUnsafe().getBoolean(null, this.ptr + 8L);
    }

    public GroupByUtf8Sink of(long ptr) {
        this.ptr = ptr;
        return this;
    }

    @Override
    public long ptr() {
        assert (this.ptr != 0L);
        return this.ptr;
    }

    @Override
    public Utf8Sink put(@Nullable Utf8Sequence seq) {
        if (seq == null) {
            return this;
        }
        int thatSize = seq.size();
        this.checkCapacity(thatSize);
        int thisSize = this.size();
        long lo = this.ptr + 9L + (long)thisSize;
        seq.writeTo(lo, 0, thatSize);
        Unsafe.getUnsafe().putInt(this.ptr + 4L, thisSize + thatSize);
        Unsafe.getUnsafe().putBoolean(null, this.ptr + 8L, seq.isAscii() && this.isAscii());
        return this;
    }

    @Override
    public Utf8Sink put(byte b) {
        this.checkCapacity(1);
        Unsafe.getUnsafe().putByte(this.ptr + 9L + (long)this.size(), b);
        Unsafe.getUnsafe().putInt(this.ptr + 4L, this.size() + 1);
        Unsafe.getUnsafe().putBoolean(null, this.ptr + 8L, false);
        return this;
    }

    @Override
    public Utf8Sink putNonAscii(long lo, long hi) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void setAllocator(GroupByAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public int size() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr + 4L) : 0;
    }

    @Override
    public void writeTo(long addr, int lo, int hi) {
        if (this.ptr == 0L) {
            return;
        }
        Utf8Sequence.super.writeTo(addr, lo, hi);
    }

    private void checkCapacity(int bytes) {
        int newCapacity;
        int capacity = this.capacity();
        int len = this.size();
        int requiredCapacity = len + bytes;
        if (requiredCapacity > 0 && requiredCapacity <= capacity) {
            return;
        }
        for (newCapacity = Math.max(capacity, 8); newCapacity < requiredCapacity; newCapacity *= 2) {
        }
        long newSize = (long)newCapacity + 9L;
        if (this.ptr == 0L) {
            this.ptr = this.allocator.malloc(newSize);
            Unsafe.getUnsafe().putInt(this.ptr, newCapacity);
            Unsafe.getUnsafe().putInt(this.ptr + 4L, 0);
            Unsafe.getUnsafe().putBoolean(null, this.ptr + 8L, true);
        } else {
            this.ptr = this.allocator.realloc(this.ptr, (long)capacity + 9L, newSize);
            Unsafe.getUnsafe().putInt(this.ptr, newCapacity);
        }
    }
}

