/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.AbstractWindowFunctionFactory;
import io.questdb.griffin.engine.functions.window.BasePartitionedWindowFunction;
import io.questdb.griffin.engine.functions.window.BaseWindowFunction;
import io.questdb.griffin.engine.functions.window.CountFunctionFactoryHelper;
import io.questdb.griffin.engine.functions.window.WindowLongFunction;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class CountConstWindowFunctionFactory
extends AbstractWindowFunctionFactory {
    public static final CountFunctionFactoryHelper.IsRecordNotNull isRecordNotNull = (arg, record) -> true;

    @Override
    public String getSignature() {
        return "count()";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        WindowContext windowContext = sqlExecutionContext.getWindowContext();
        windowContext.validate(position, this.supportNullsDesc());
        int framingMode = windowContext.getFramingMode();
        RecordSink partitionBySink = windowContext.getPartitionBySink();
        ColumnTypes partitionByKeyTypes = windowContext.getPartitionByKeyTypes();
        VirtualRecord partitionByRecord = windowContext.getPartitionByRecord();
        long rowsLo = windowContext.getRowsLo();
        long rowsHi = windowContext.getRowsHi();
        if (rowsHi < rowsLo) {
            return new AbstractWindowFunctionFactory.LongNullFunction(null, "count", rowsLo, rowsHi, framingMode == 1, partitionByRecord, 0L);
        }
        if (partitionByRecord != null) {
            if (framingMode == 1) {
                if (windowContext.isDefaultFrame() && (!windowContext.isOrdered() || windowContext.getRowsHi() == Long.MAX_VALUE)) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, CountFunctionFactoryHelper.COUNT_COLUMN_TYPES);
                    return new CountFunctionFactoryHelper.CountOverPartitionFunction(map, partitionByRecord, partitionBySink, null, isRecordNotNull);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, CountFunctionFactoryHelper.COUNT_COLUMN_TYPES);
                    return new CountFunctionFactoryHelper.CountOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, null, isRecordNotNull);
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                Map map = null;
                MemoryCARW mem = null;
                try {
                    map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, CountFunctionFactoryHelper.COUNT_OVER_PARTITION_RANGE_COLUMN_TYPES);
                    mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    return new CountFunctionFactoryHelper.CountOverPartitionRangeFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, mem, configuration.getSqlWindowInitialRangeBufferSize(), timestampIndex, null, isRecordNotNull);
                }
                catch (Throwable th) {
                    Misc.free(map);
                    Misc.free(mem);
                    throw th;
                }
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, CountFunctionFactoryHelper.COUNT_COLUMN_TYPES);
                    return new CountFunctionFactoryHelper.CountOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, null, isRecordNotNull);
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new CountFunctionFactoryHelper.CountOverCurrentRowFunction(null, isRecordNotNull);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, CountFunctionFactoryHelper.COUNT_COLUMN_TYPES);
                    return new CountFunctionFactoryHelper.CountOverPartitionFunction(map, partitionByRecord, partitionBySink, null, isRecordNotNull);
                }
                Map map = null;
                try {
                    map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, CountFunctionFactoryHelper.COUNT_COLUMN_TYPES);
                    return new CountOverPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi);
                }
                catch (Throwable th) {
                    Misc.free(map);
                    throw th;
                }
            }
        } else {
            if (framingMode == 1) {
                if (!windowContext.isOrdered() && windowContext.isDefaultFrame()) {
                    return new CountFunctionFactoryHelper.CountOverWholeResultSetFunction(null, isRecordNotNull);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new CountFunctionFactoryHelper.CountOverUnboundedRowsFrameFunction(null, isRecordNotNull);
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                return new CountFunctionFactoryHelper.CountOverRangeFrameFunction(rowsLo, rowsHi, configuration, timestampIndex, null, isRecordNotNull);
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new CountFunctionFactoryHelper.CountOverUnboundedRowsFrameFunction(null, isRecordNotNull);
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new CountFunctionFactoryHelper.CountOverCurrentRowFunction(null, isRecordNotNull);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    return new CountFunctionFactoryHelper.CountOverWholeResultSetFunction(null, isRecordNotNull);
                }
                return new CountOverRowsFrameFunction(rowsLo, rowsHi);
            }
        }
        throw SqlException.$(position, "function not implemented for given window parameters");
    }

    public static class CountOverPartitionRowsFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowLongFunction {
        private final long frameSize;
        private final long rowsHi;
        private final long rowsLo;
        private long count;

        public CountOverPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rowsLo, long rowsHi) {
            super(map, partitionByRecord, partitionBySink, null);
            this.frameSize = rowsLo > Long.MIN_VALUE ? rowsHi - rowsLo + 1L : Long.MAX_VALUE;
            this.rowsHi = rowsHi;
            this.rowsLo = rowsLo;
        }

        @Override
        public void close() {
            super.close();
        }

        @Override
        public void computeNext(Record record) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            long currentSize = 0L;
            if (!value.isNew()) {
                currentSize = value.getLong(0);
            }
            this.count = ++currentSize + this.rowsHi;
            if (this.count < 0L) {
                this.count = 0L;
            } else if (this.count > this.frameSize) {
                this.count = this.frameSize;
            }
            value.putLong(0, currentSize);
        }

        @Override
        public long getLong(Record rec) {
            return this.count;
        }

        @Override
        public String getName() {
            return "count";
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.count);
        }

        @Override
        public void reopen() {
            super.reopen();
        }

        @Override
        public void reset() {
            super.reset();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val("(*)");
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" rows between ");
            if (this.rowsLo > Long.MIN_VALUE) {
                sink.val(Math.abs(this.rowsLo));
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.rowsHi == 0L) {
                sink.val("current row");
            } else {
                sink.val(Math.abs(this.rowsHi)).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
        }
    }

    public static class CountOverRowsFrameFunction
    extends BaseWindowFunction
    implements WindowLongFunction {
        private final long frameSize;
        private final long rowsHi;
        private final long rowsLo;
        private long count;

        public CountOverRowsFrameFunction(long rowsLo, long rowsHi) {
            super(null);
            this.frameSize = rowsLo > Long.MIN_VALUE ? rowsHi - rowsLo + 1L : Long.MAX_VALUE;
            this.rowsHi = rowsHi;
            this.rowsLo = rowsLo;
            this.count = rowsHi;
        }

        @Override
        public void close() {
            super.close();
        }

        @Override
        public void computeNext(Record record) {
            ++this.count;
        }

        @Override
        public long getLong(Record rec) {
            if (this.count < 0L) {
                return 0L;
            }
            if (this.count > this.frameSize) {
                return this.frameSize;
            }
            return this.count;
        }

        @Override
        public String getName() {
            return "count";
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), this.getLong(null));
        }

        @Override
        public void reset() {
            super.reset();
            this.count = this.rowsHi;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val("(*)");
            sink.val(" over (");
            sink.val(" rows between ");
            if (this.rowsLo != Long.MIN_VALUE) {
                sink.val(Math.abs(this.rowsLo));
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.rowsHi == 0L) {
                sink.val("current row");
            } else {
                sink.val(Math.abs(this.rowsHi)).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.count = this.rowsHi;
        }
    }
}

