/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.window.WindowFunction;
import io.questdb.std.Misc;

public abstract class BaseWindowFunction
implements WindowFunction {
    protected final Function arg;
    protected int columnIndex;

    public BaseWindowFunction(Function arg) {
        this.arg = arg;
    }

    @Override
    public void close() {
        Misc.free(this.arg);
    }

    @Override
    public void cursorClosed() {
        if (this.arg != null) {
            this.arg.cursorClosed();
        }
    }

    @Override
    public abstract String getName();

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        if (this.arg != null) {
            this.arg.init(symbolTableSource, executionContext);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.getName());
        if (this.arg != null) {
            sink.val('(').val(this.arg).val(')');
        } else {
            sink.val("(*)");
        }
        if (this.isIgnoreNulls()) {
            sink.val(" ignore nulls");
        }
        sink.val(" over ()");
    }

    @Override
    public void toTop() {
        if (this.arg != null) {
            this.arg.toTop();
        }
    }
}

