/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.MetadataCacheWriter;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.IntList;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class HydrateTableMetadataFunctionFactory
implements FunctionFactory {
    private static final Log LOG = LogFactory.getLog(HydrateTableMetadataFunctionFactory.class);
    private static final String SIGNATURE = "hydrate_table_metadata(V)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        CharSequence tableName;
        if (args == null || args.size() == 0) {
            throw SqlException.$(position, "no arguments provided");
        }
        CairoEngine engine = sqlExecutionContext.getCairoEngine();
        ObjList<TableToken> tableTokens = new ObjList<TableToken>();
        if (args.size() == 1 && (tableName = args.getQuick(0).getStrA(null)).length() == 1 && tableName.charAt(0) == '*') {
            ObjHashSet<TableToken> tableHashSet = new ObjHashSet<TableToken>();
            engine.getTableTokens(tableHashSet, false);
            tableTokens = tableHashSet.getList();
            LOG.info().$("rehydrating all tables").$();
        }
        if (tableTokens.size() == 0) {
            int n = args.size();
            for (int i = 0; i < n; ++i) {
                CharSequence tableName2 = args.getQuick(i).getStrA(null);
                if (tableName2.length() == 1 && tableName2.charAt(0) == '*' && args.size() > 1) {
                    throw SqlException.$(position, "cannot use wildcard alongside other table names");
                }
                TableToken tableToken = engine.getTableTokenIfExists(tableName2);
                if (tableToken == null) {
                    LOG.error().$("table does not exist [table=").$safe(tableName2).I$();
                    continue;
                }
                tableTokens.add(tableToken);
            }
        }
        if (tableTokens.size() > 0) {
            return new HydrateTableMetadataFunction(tableTokens, engine, position);
        }
        throw SqlException.$(position, "no valid table names provided");
    }

    private static class HydrateTableMetadataFunction
    extends BooleanFunction {
        private final int functionPosition;
        private final ObjList<TableToken> tableTokens;
        private CairoEngine engine;

        public HydrateTableMetadataFunction(@NotNull ObjList<TableToken> tableTokens, @NotNull CairoEngine engine, int functionPosition) {
            this.tableTokens = tableTokens;
            this.engine = engine;
            this.functionPosition = functionPosition;
        }

        @Override
        public boolean getBool(Record rec) {
            return true;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            executionContext.getSecurityContext().authorizeSystemAdmin();
            this.engine = executionContext.getCairoEngine();
            super.init(symbolTableSource, executionContext);
            int n = this.tableTokens.size();
            for (int i = 0; i < n; ++i) {
                TableToken tableToken = this.tableTokens.getQuick(i);
                if (tableToken.isSystem()) continue;
                try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
                    metadataRW.hydrateTable(this.tableTokens.getQuick(i));
                    continue;
                }
                catch (Throwable e) {
                    if (e instanceof CairoException) {
                        ((CairoException)e).position(this.functionPosition);
                    }
                    throw e;
                }
            }
        }

        @Override
        public boolean isThreadSafe() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(HydrateTableMetadataFunctionFactory.SIGNATURE);
        }
    }
}

