/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.memoization;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NullRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.UuidFunction;

public final class UuidFunctionMemoizer
extends UuidFunction
implements UnaryFunction {
    private final Function fn;
    private long hiLeft;
    private long hiRight;
    private long loLeft;
    private long loRight;
    private Record recordLeft;
    private Record recordRight;

    public UuidFunctionMemoizer(Function fn) {
        assert (fn.shouldMemoize());
        this.fn = fn;
    }

    @Override
    public Function getArg() {
        return this.fn;
    }

    @Override
    public long getLong128Hi(Record rec) {
        if (this.recordLeft == rec) {
            return this.hiLeft;
        }
        if (this.recordRight == rec) {
            return this.hiRight;
        }
        return this.fn.getLong128Hi(rec);
    }

    @Override
    public long getLong128Lo(Record rec) {
        if (this.recordLeft == rec) {
            return this.loLeft;
        }
        if (this.recordRight == rec) {
            return this.loRight;
        }
        return this.fn.getLong128Lo(rec);
    }

    @Override
    public String getName() {
        return "memoize";
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        this.recordLeft = NullRecord.INSTANCE;
        this.recordRight = NullRecord.INSTANCE;
        UnaryFunction.super.init(symbolTableSource, executionContext);
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public void memoize(Record record) {
        if (this.recordLeft == record) {
            this.loLeft = this.fn.getLong128Lo(record);
            this.hiLeft = this.fn.getLong128Hi(record);
        } else if (this.recordRight == record) {
            this.loRight = this.fn.getLong128Lo(record);
            this.hiRight = this.fn.getLong128Hi(record);
        } else if (this.recordLeft == NullRecord.INSTANCE) {
            this.recordLeft = record;
            this.loLeft = this.fn.getLong128Lo(record);
            this.hiLeft = this.fn.getLong128Hi(record);
        } else if (this.recordRight == NullRecord.INSTANCE) {
            assert (this.supportsRandomAccess());
            this.recordRight = record;
            this.loRight = this.fn.getLong128Lo(record);
            this.hiRight = this.fn.getLong128Hi(record);
        } else {
            throw CairoException.nonCritical().put("UuidFunctionMemoizer can only memoize two records, but got more than two: [recordLeft=").put(this.recordLeft.toString()).put(", recordRight=").put(this.recordRight.toString()).put(", newRecord=").put(record.toString()).put(']');
        }
    }

    @Override
    public boolean shouldMemoize() {
        return true;
    }

    @Override
    public boolean supportsRandomAccess() {
        return this.fn.supportsRandomAccess();
    }
}

