/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IPv4Function;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.IPv4Constant;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class IPv4StrNetmaskFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "netmask(S)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function strFunc = args.getQuick(0);
        if (strFunc.isConstant()) {
            CharSequence str = strFunc.getStrA(null);
            if (str == null) {
                return IPv4Constant.NULL;
            }
            int val = Numbers.getIPv4Netmask(str);
            return val == 1 ? IPv4Constant.NULL : IPv4Constant.newInstance(val);
        }
        return new Func(strFunc);
    }

    private static class Func
    extends IPv4Function
    implements UnaryFunction {
        private final Function strFunc;

        public Func(Function strFunc) {
            this.strFunc = strFunc;
        }

        @Override
        public Function getArg() {
            return this.strFunc;
        }

        @Override
        public int getIPv4(Record rec) {
            CharSequence str = this.strFunc.getStrA(rec);
            if (str == null) {
                return 0;
            }
            int val = Numbers.getIPv4Netmask(str);
            return val == 1 ? 0 : val;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("netmask(").val(this.strFunc).val(')');
        }
    }
}

