/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class DegreesDoubleFunctionFactory
implements FunctionFactory {
    public static final String SYMBOL = "degrees";

    @Override
    public String getSignature() {
        return "degrees(D)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function angleRad = args.getQuick(0);
        if (angleRad.isConstant()) {
            return new DoubleConstant(Math.toDegrees(angleRad.getDouble(null)));
        }
        return new FromRadians(args.getQuick(0));
    }

    private static class FromRadians
    extends DoubleFunction
    implements UnaryFunction {
        final Function function;

        public FromRadians(Function function) {
            this.function = function;
        }

        @Override
        public Function getArg() {
            return this.function;
        }

        @Override
        public double getDouble(Record rec) {
            return Math.toDegrees(this.function.getDouble(rec));
        }

        @Override
        public String getName() {
            return DegreesDoubleFunctionFactory.SYMBOL;
        }
    }
}

