/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.griffin.engine.groupby.hyperloglog.HyperLogLog;
import io.questdb.std.Hash;

public class ApproxCountDistinctLongGroupByFunction
extends LongFunction
implements UnaryFunction,
GroupByFunction {
    private static final long NULL_VALUE = -1L;
    private final Function arg;
    private final HyperLogLog hllA;
    private final HyperLogLog hllB;
    private int hllPtrIndex;
    private int overwrittenFlagIndex;
    private int valueIndex;

    public ApproxCountDistinctLongGroupByFunction(Function arg, int precision) {
        this.arg = arg;
        this.hllA = new HyperLogLog(precision);
        this.hllB = new HyperLogLog(precision);
    }

    public ApproxCountDistinctLongGroupByFunction(Function arg) {
        this(arg, 14);
    }

    @Override
    public void clear() {
        this.hllA.resetPtr();
        this.hllB.resetPtr();
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        long val = this.arg.getLong(record);
        if (val != Long.MIN_VALUE) {
            long hash = Hash.murmur3ToLong(val);
            long cardinality = this.hllA.of(0L).addAndComputeCardinalityFast(hash);
            mapValue.putLong(this.hllPtrIndex, this.hllA.ptr());
            mapValue.putLong(this.valueIndex, cardinality);
        } else {
            mapValue.putLong(this.hllPtrIndex, 0L);
            mapValue.putLong(this.valueIndex, -1L);
        }
        mapValue.putBool(this.overwrittenFlagIndex, false);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        long val = this.arg.getLong(record);
        if (val != Long.MIN_VALUE) {
            long hash = Hash.murmur3ToLong(val);
            long ptr = mapValue.getLong(this.hllPtrIndex);
            long cardinality = this.hllA.of(ptr).addAndComputeCardinalityFast(hash);
            mapValue.putLong(this.hllPtrIndex, this.hllA.ptr());
            mapValue.putLong(this.valueIndex, cardinality);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public long getLong(Record rec) {
        if (rec.getBool(this.overwrittenFlagIndex)) {
            return rec.getLong(this.valueIndex);
        }
        long ptr = rec.getLong(this.hllPtrIndex);
        if (ptr == 0L) {
            return 0L;
        }
        long val = rec.getLong(this.valueIndex);
        if (val != -1L) {
            return val;
        }
        this.hllA.of(ptr);
        return this.hllA.computeCardinality();
    }

    @Override
    public String getName() {
        return "approx_count_distinct";
    }

    @Override
    public int getSampleByFlags() {
        return 31;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
        this.hllPtrIndex = valueIndex + 1;
        this.overwrittenFlagIndex = valueIndex + 2;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.initValueIndex(columnTypes.getColumnCount());
        columnTypes.add(6);
        columnTypes.add(6);
        columnTypes.add(1);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long destPtr;
        long srcPtr;
        if (srcValue.getBool(this.overwrittenFlagIndex)) {
            long srcCount = srcValue.getLong(this.valueIndex);
            if (srcCount == 0L || srcCount == Long.MIN_VALUE) {
                return;
            }
            assert (false) : "merging overwritten values with HyperLogLog is unsupported";
        }
        if ((srcPtr = srcValue.getLong(this.hllPtrIndex)) == 0L) {
            return;
        }
        if (destValue.getBool(this.overwrittenFlagIndex)) {
            long dstCount = destValue.getLong(this.valueIndex);
            if (dstCount == 0L || dstCount == Long.MIN_VALUE) {
                destValue.putBool(this.overwrittenFlagIndex, false);
                destValue.putLong(this.hllPtrIndex, srcPtr);
                destValue.putLong(this.valueIndex, -1L);
                return;
            }
            assert (false) : "merging overwritten values with HyperLogLog is unsupported";
        }
        if ((destPtr = destValue.getLong(this.hllPtrIndex)) == 0L) {
            destValue.putBool(this.overwrittenFlagIndex, false);
            destValue.putLong(this.hllPtrIndex, srcPtr);
            destValue.putLong(this.valueIndex, -1L);
            return;
        }
        this.hllA.of(destPtr);
        this.hllB.of(srcPtr);
        long mergedPtr = HyperLogLog.merge(this.hllA, this.hllB);
        destValue.putBool(this.overwrittenFlagIndex, false);
        destValue.putLong(this.hllPtrIndex, mergedPtr);
        destValue.putLong(this.valueIndex, -1L);
    }

    @Override
    public void setAllocator(GroupByAllocator allocator) {
        this.hllA.setAllocator(allocator);
        this.hllB.setAllocator(allocator);
    }

    @Override
    public void setEmpty(MapValue mapValue) {
        this.overwrite(mapValue, 0L);
    }

    @Override
    public void setLong(MapValue mapValue, long value) {
        this.overwrite(mapValue, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        this.overwrite(mapValue, Long.MIN_VALUE);
    }

    @Override
    public boolean supportsParallelism() {
        return true;
    }

    private void overwrite(MapValue mapValue, long value) {
        mapValue.putLong(this.valueIndex, value);
        mapValue.putLong(this.hllPtrIndex, 0L);
        mapValue.putBool(this.overwrittenFlagIndex, true);
    }
}

