/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.griffin.engine.functions.eq.EqStrFunctionFactory;
import io.questdb.griffin.engine.functions.eq.EqVarcharFunctionFactory;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;

public class EqVarcharStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(\u00d8S)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function varchar = args.getQuick(0);
        Function str = args.getQuick(1);
        return this.newInstance(str, varchar);
    }

    private Function createStrConstantFunc(Function constVarcharFunc, Function varStrFunc) {
        Utf8Sequence constValue = constVarcharFunc.getVarcharA(null);
        if (constValue == null) {
            return new EqStrFunctionFactory.NullCheckFunc(varStrFunc);
        }
        return new EqStrFunctionFactory.ConstCheckFunc(varStrFunc, Utf8s.toString(constValue));
    }

    private Function createVarcharConstantFunc(Function a, Function b) {
        CharSequence constValue = a.getStrA(null);
        if (constValue == null) {
            return new EqVarcharFunctionFactory.NullCheckFunc(b);
        }
        Utf8String utf8ConstValue = new Utf8String(constValue);
        return new EqVarcharFunctionFactory.ConstCheckFunc(b, utf8ConstValue);
    }

    @NotNull
    protected Function newInstance(Function str, Function varchar) {
        if (str.isConstant() && !varchar.isConstant()) {
            return this.createVarcharConstantFunc(str, varchar);
        }
        if (!str.isConstant() && varchar.isConstant()) {
            return this.createStrConstantFunc(varchar, str);
        }
        return new Func(str, varchar);
    }

    private static class Func
    extends AbstractEqBinaryFunction {
        public Func(Function left, Function right) {
            super(left, right);
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence a = this.left.getStrA(rec);
            Utf8Sequence b = this.right.getVarcharB(rec);
            if (a == null) {
                return this.negated != (b == null);
            }
            return this.negated != Utf8s.equalsUtf16Nc(a, b);
        }

        @Override
        public String getName() {
            if (this.negated) {
                return "!=";
            }
            return "=";
        }
    }
}

