/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DateFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.str.Utf8Sequence;

public class VarcharToPgDateFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "to_pg_date(\u00d8)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        return new ToPgDateFunction(arg);
    }

    public static final class ToPgDateFunction
    extends DateFunction
    implements UnaryFunction {
        private final Function arg;

        public ToPgDateFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getDate(Record rec) {
            Utf8Sequence value = this.arg.getVarcharA(rec);
            try {
                if (value != null && value.isAscii()) {
                    return DateFormatUtils.PG_DATE_FORMAT.parse(value.asAsciiCharSequence(), DateFormatUtils.EN_LOCALE);
                }
            }
            catch (NumericException numericException) {
                // empty catch block
            }
            return Long.MIN_VALUE;
        }

        @Override
        public String getName() {
            return "to_pg_date";
        }
    }
}

