/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class TimestampSequenceFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "timestamp_sequence(NL)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        if (args.getQuick(0).isConstant()) {
            long start = args.getQuick(0).getTimestamp(null);
            if (start == Long.MIN_VALUE) {
                return TimestampConstant.NULL;
            }
            return new TimestampSequenceFunction(start, args.getQuick(1));
        }
        return new TimestampSequenceVariableFunction(args.getQuick(0), args.getQuick(1));
    }

    private static class TimestampSequenceFunction
    extends TimestampFunction {
        private final Function longIncrement;
        private final long start;
        private long next;

        public TimestampSequenceFunction(long start, Function longIncrement) {
            this.start = start;
            this.next = start;
            this.longIncrement = longIncrement;
        }

        @Override
        public boolean shouldMemoize() {
            return true;
        }

        @Override
        public long getTimestamp(Record rec) {
            long result = this.next;
            this.next += this.longIncrement.getLong(rec);
            return result;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.longIncrement.init(symbolTableSource, executionContext);
            this.next = this.start;
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        @Override
        public boolean supportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("timestamp_sequence(").val(this.start).val(',').val(this.longIncrement).val(')');
        }

        @Override
        public void toTop() {
            this.next = this.start;
        }
    }

    private static final class TimestampSequenceVariableFunction
    extends TimestampFunction {
        private final Function longIncrement;
        private final Function start;
        private long next;

        public TimestampSequenceVariableFunction(Function start, Function longIncrement) {
            this.start = start;
            this.next = 0L;
            this.longIncrement = longIncrement;
        }

        @Override
        public void close() {
            Misc.free(this.start);
            Misc.free(this.longIncrement);
        }

        @Override
        public long getTimestamp(Record rec) {
            long result = this.next;
            this.next += this.longIncrement.getLong(rec);
            return result + this.start.getLong(rec);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.start.init(symbolTableSource, executionContext);
            this.longIncrement.init(symbolTableSource, executionContext);
            this.next = 0L;
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        @Override
        public boolean supportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("timestamp_sequence(").val(this.start).val(',').val(this.longIncrement).val(')');
        }

        @Override
        public void toTop() {
            this.next = 0L;
        }
    }
}

