/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.date.AbstractGenerateSeriesRecordCursorFactory;
import io.questdb.std.IntList;

public class GenerateSeriesTimestampRecordCursorFactory
extends AbstractGenerateSeriesRecordCursorFactory {
    private static final GenericRecordMetadata METADATA;
    private GenerateSeriesTimestampRecordCursor cursor;

    public GenerateSeriesTimestampRecordCursorFactory(Function startFunc, Function endFunc, Function stepFunc, IntList argPositions) throws SqlException {
        super(METADATA, startFunc, endFunc, stepFunc, argPositions);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        if (this.cursor == null) {
            this.cursor = new GenerateSeriesTimestampRecordCursor(this.startFunc, this.endFunc, this.stepFunc);
        }
        this.cursor.of(executionContext, this.stepPosition);
        return this.cursor;
    }

    @Override
    public int getScanDirection() {
        if (this.stepFunc.getLong(null) > 0L) {
            return 1;
        }
        return 2;
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(0, new TableColumnMetadata("generate_series", 8));
        metadata.setTimestampIndex(0);
        METADATA = metadata;
    }

    private static class GenerateSeriesTimestampRecordCursor
    extends AbstractGenerateSeriesRecordCursorFactory.AbstractGenerateSeriesRecordCursor {
        private final GenerateSeriesTimestampRecord recordA = new GenerateSeriesTimestampRecord();
        private final GenerateSeriesTimestampRecord recordB = new GenerateSeriesTimestampRecord();
        private long end;
        private long start;
        private long step;

        public GenerateSeriesTimestampRecordCursor(Function startFunc, Function endFunc, Function stepFunc) {
            super(startFunc, endFunc, stepFunc);
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public Record getRecordB() {
            return this.recordB;
        }

        @Override
        public boolean hasNext() {
            this.recordA.curr += this.step;
            if (this.step >= 0L) {
                return this.recordA.curr <= this.end;
            }
            return this.recordA.curr >= this.end;
        }

        public void of(SqlExecutionContext executionContext, int stepPosition) throws SqlException {
            super.of(executionContext);
            this.start = this.startFunc.getTimestamp(null);
            this.end = this.endFunc.getTimestamp(null);
            this.step = this.stepFunc.getTimestamp(null);
            if (this.step == 0L) {
                throw SqlException.$(stepPosition, "step cannot be zero");
            }
            if (this.start <= this.end && this.step < 0L || this.start >= this.end && this.step > 0L) {
                long temp = this.start;
                this.start = this.end;
                this.end = temp;
            }
            this.toTop();
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            ((GenerateSeriesTimestampRecord)record).curr = this.start + this.step * (atRowId - 1L);
        }

        @Override
        public long size() {
            return Math.abs(this.end - this.start) / Math.abs(this.step) + 1L;
        }

        @Override
        public void skipRows(RecordCursor.Counter rowCount) throws DataUnavailableException {
            long newRowId = this.recordA.getRowId() + rowCount.get() - 1L - 1L;
            this.recordAt(this.recordA, newRowId);
        }

        @Override
        public void toTop() {
            this.recordA.of(this.start - this.step);
        }

        private class GenerateSeriesTimestampRecord
        implements Record {
            private long curr;

            private GenerateSeriesTimestampRecord() {
            }

            @Override
            public long getLong(int col) {
                return this.curr;
            }

            @Override
            public long getRowId() {
                return Math.abs(GenerateSeriesTimestampRecordCursor.this.start - this.curr) / Math.abs(GenerateSeriesTimestampRecordCursor.this.step) + 1L;
            }

            @Override
            public long getTimestamp(int col) {
                return this.curr;
            }

            public void of(long value) {
                this.curr = value;
            }
        }
    }
}

