/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.date.AbstractGenerateSeriesRecordCursorFactory;
import io.questdb.std.IntList;

public class GenerateSeriesLongRecordCursorFactory
extends AbstractGenerateSeriesRecordCursorFactory {
    private static final RecordMetadata METADATA;
    private GenerateSeriesLongRecordCursor cursor;

    public GenerateSeriesLongRecordCursorFactory(Function startFunc, Function endFunc, Function stepFunc, IntList argPositions) throws SqlException {
        super(METADATA, startFunc, endFunc, stepFunc, argPositions);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        if (this.cursor == null) {
            this.cursor = new GenerateSeriesLongRecordCursor(this.startFunc, this.endFunc, this.stepFunc);
        }
        this.cursor.of(executionContext, this.stepPosition);
        return this.cursor;
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(0, new TableColumnMetadata("generate_series", 6));
        METADATA = metadata;
    }

    private static class GenerateSeriesLongRecordCursor
    extends AbstractGenerateSeriesRecordCursorFactory.AbstractGenerateSeriesRecordCursor {
        private final GenerateSeriesLongRecord recordA = new GenerateSeriesLongRecord();
        private final GenerateSeriesLongRecord recordB = new GenerateSeriesLongRecord();
        private long end;
        private long start;
        private long step;

        public GenerateSeriesLongRecordCursor(Function startFunc, Function endFunc, Function stepFunc) {
            super(startFunc, endFunc, stepFunc);
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public Record getRecordB() {
            return this.recordB;
        }

        @Override
        public boolean hasNext() {
            this.recordA.curr += this.step;
            if (this.step >= 0L) {
                return this.recordA.curr <= this.end;
            }
            return this.recordA.curr >= this.end;
        }

        public void of(SqlExecutionContext executionContext, int stepPosition) throws SqlException {
            super.of(executionContext);
            this.start = this.startFunc.getLong(null);
            this.end = this.endFunc.getLong(null);
            this.step = this.stepFunc.getLong(null);
            if (this.step == 0L) {
                throw SqlException.$(stepPosition, "step cannot be zero");
            }
            if (this.start <= this.end && this.step < 0L || this.start >= this.end && this.step > 0L) {
                long temp = this.start;
                this.start = this.end;
                this.end = temp;
            }
            this.toTop();
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            ((GenerateSeriesLongRecord)record).curr = this.start + this.step * (atRowId - 1L);
        }

        @Override
        public long size() {
            return Math.abs(this.end - this.start) / Math.abs(this.step) + 1L;
        }

        @Override
        public void skipRows(RecordCursor.Counter rowCount) throws DataUnavailableException {
            long newRowId = this.recordA.getRowId() + rowCount.get() - 1L - 1L;
            this.recordAt(this.recordA, newRowId);
        }

        @Override
        public void toTop() {
            this.recordA.of(this.start - this.step);
        }

        private class GenerateSeriesLongRecord
        implements Record {
            private long curr;

            private GenerateSeriesLongRecord() {
            }

            @Override
            public long getLong(int col) {
                return this.curr;
            }

            @Override
            public long getRowId() {
                return Math.abs(GenerateSeriesLongRecordCursor.this.start - this.curr) / Math.abs(GenerateSeriesLongRecordCursor.this.step) + 1L;
            }

            public void of(long value) {
                this.curr = value;
            }
        }
    }
}

