/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class NullIfLongFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "nullif(LL)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new NullIfLongFunction(args.getQuick(0), args.getQuick(1));
    }

    private static class NullIfLongFunction
    extends LongFunction
    implements BinaryFunction {
        private final Function longFunc1;
        private final Function longFunc2;

        public NullIfLongFunction(Function longFunc1, Function longFunc2) {
            this.longFunc1 = longFunc1;
            this.longFunc2 = longFunc2;
        }

        @Override
        public Function getLeft() {
            return this.longFunc1;
        }

        @Override
        public long getLong(Record rec) {
            return this.longFunc1.getLong(rec) == this.longFunc2.getLong(rec) ? Long.MIN_VALUE : this.longFunc1.getLong(rec);
        }

        @Override
        public Function getRight() {
            return this.longFunc2;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("nullif(").val(this.longFunc1).val(',').val(this.longFunc2).val(')');
        }
    }
}

