/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.DateFunction;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.FloatFunction;
import io.questdb.griffin.engine.functions.IPv4Function;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.Long256Function;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UuidFunction;
import io.questdb.griffin.engine.functions.VarcharFunction;
import io.questdb.griffin.engine.functions.conditional.CaseCommon;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Utf8Sequence;

public class CoalesceFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "coalesce(V)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int i;
        if (args == null || args.size() < 2) {
            throw SqlException.$(position, "coalesce can be used with 2 or more arguments");
        }
        if (args.size() > 2) {
            args = new ObjList<Function>(args);
        }
        int argsSize = args.size();
        int returnType = -1;
        for (i = 0; i < argsSize; ++i) {
            returnType = CaseCommon.getCommonType(returnType, args.getQuick(i).getType(), argPositions.getQuick(i), "coalesce cannot be used with bind variables");
        }
        for (i = 0; i < argsSize; ++i) {
            args.setQuick(i, CaseCommon.getCastFunction(args.getQuick(i), argPositions.getQuick(i), returnType, configuration, sqlExecutionContext));
        }
        switch (ColumnType.tagOf(returnType)) {
            case 10: {
                return argsSize == 2 ? new TwoDoubleCoalesceFunction(args) : new DoubleCoalesceFunction(args, argsSize);
            }
            case 7: {
                return argsSize == 2 ? new TwoDateCoalesceFunction(args) : new DateCoalesceFunction(args, argsSize);
            }
            case 8: {
                return argsSize == 2 ? new TwoTimestampCoalesceFunction(args) : new TimestampCoalesceFunction(args);
            }
            case 6: {
                return argsSize == 2 ? new TwoLongCoalesceFunction(args) : new LongCoalesceFunction(args, argsSize);
            }
            case 13: {
                return argsSize == 2 ? new TwoLong256CoalesceFunction(args) : new Long256CoalesceFunction(args);
            }
            case 5: {
                return argsSize == 2 ? new TwoIntCoalesceFunction(args) : new IntCoalesceFunction(args, argsSize);
            }
            case 25: {
                return argsSize == 2 ? new TwoIPv4CoalesceFunction(args) : new IPv4CoalesceFunction(args, argsSize);
            }
            case 9: {
                return argsSize == 2 ? new TwoFloatCoalesceFunction(args) : new FloatCoalesceFunction(args, argsSize);
            }
            case 11: 
            case 12: {
                if (argsSize == 2) {
                    short type0 = ColumnType.tagOf(args.getQuick(0).getType());
                    if (type0 != ColumnType.tagOf(args.getQuick(1).getType())) {
                        return new TwoSymStrCoalesceFunction(args);
                    }
                    if (type0 == 12) {
                        return new TwoSymCoalesceFunction(args);
                    }
                    return new TwoStrCoalesceFunction(args);
                }
                return new SymStrCoalesceFunction(args, argsSize);
            }
            case 26: {
                return argsSize == 2 ? new TwoVarcharCoalesceFunction(args) : new VarcharCoalesceFunction(args, argsSize);
            }
            case 19: {
                return argsSize == 2 ? new TwoUuidCoalesceFunction(args) : new UuidCoalesceFunction(args, argsSize);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return args.getQuick(0);
            }
        }
        throw SqlException.$(position, "coalesce cannot be used with ").put(ColumnType.nameOf(returnType)).put(" data type");
    }

    @Override
    public int resolvePreferredVariadicType(int sqlPos, int argPos, ObjList<Function> args) throws SqlException {
        throw SqlException.$(sqlPos, "coalesce cannot be used with bind variables");
    }

    private static boolean isNotNull(Long256 value) {
        return value != null && value != Long256Impl.NULL_LONG256 && (value.getLong0() != Long.MIN_VALUE || value.getLong1() != Long.MIN_VALUE || value.getLong2() != Long.MIN_VALUE || value.getLong3() != Long.MIN_VALUE);
    }

    private static class TwoDoubleCoalesceFunction
    extends DoubleFunction
    implements BinaryCoalesceFunction {
        private final Function args0;
        private final Function args1;

        public TwoDoubleCoalesceFunction(ObjList<Function> args) {
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public double getDouble(Record rec) {
            double value = this.args0.getDouble(rec);
            if (Numbers.isFinite(value)) {
                return value;
            }
            return this.args1.getDouble(rec);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }
    }

    private static class DoubleCoalesceFunction
    extends DoubleFunction
    implements MultiArgCoalesceFunction {
        private final ObjList<Function> args;
        private final int size;

        public DoubleCoalesceFunction(ObjList<Function> args, int size) {
            this.args = args;
            this.size = size;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public double getDouble(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                double value = this.args.getQuick(i).getDouble(rec);
                if (!Numbers.isFinite(value)) continue;
                return value;
            }
            return Double.NaN;
        }
    }

    private static class TwoDateCoalesceFunction
    extends DateFunction
    implements BinaryCoalesceFunction {
        private final Function args0;
        private final Function args1;

        public TwoDateCoalesceFunction(ObjList<Function> args) {
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public long getDate(Record rec) {
            long value = this.args0.getDate(rec);
            if (value != Long.MIN_VALUE) {
                return value;
            }
            return this.args1.getDate(rec);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }
    }

    private static class DateCoalesceFunction
    extends DateFunction
    implements MultiArgCoalesceFunction {
        private final ObjList<Function> args;
        private final int size;

        public DateCoalesceFunction(ObjList<Function> args, int size) {
            this.args = args;
            this.size = size;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public long getDate(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                long value = this.args.getQuick(i).getDate(rec);
                if (value == Long.MIN_VALUE) continue;
                return value;
            }
            return Long.MIN_VALUE;
        }
    }

    private static class TwoTimestampCoalesceFunction
    extends TimestampFunction
    implements BinaryCoalesceFunction {
        private final Function args0;
        private final Function args1;

        public TwoTimestampCoalesceFunction(ObjList<Function> args) {
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }

        @Override
        public long getTimestamp(Record rec) {
            long value = this.args0.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return value;
            }
            return this.args1.getTimestamp(rec);
        }
    }

    private static class TimestampCoalesceFunction
    extends TimestampFunction
    implements MultiArgCoalesceFunction {
        private final ObjList<Function> args;
        private final int size;

        public TimestampCoalesceFunction(ObjList<Function> args) {
            this.args = args;
            this.size = args.size();
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public long getTimestamp(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                long value = this.args.getQuick(i).getTimestamp(rec);
                if (value == Long.MIN_VALUE) continue;
                return value;
            }
            return Long.MIN_VALUE;
        }
    }

    public static class TwoLongCoalesceFunction
    extends LongFunction
    implements BinaryCoalesceFunction {
        private final Function args0;
        private final Function args1;

        public TwoLongCoalesceFunction(ObjList<Function> args) {
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public long getLong(Record rec) {
            long value = this.args0.getLong(rec);
            if (value != Long.MIN_VALUE) {
                return value;
            }
            return this.args1.getLong(rec);
        }

        @Override
        public Function getRight() {
            return this.args1;
        }
    }

    public static class LongCoalesceFunction
    extends LongFunction
    implements MultiArgCoalesceFunction {
        private final ObjList<Function> args;
        private final int size;

        public LongCoalesceFunction(ObjList<Function> args, int size) {
            this.args = args;
            this.size = size;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public long getLong(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                long value = this.args.getQuick(i).getLong(rec);
                if (value == Long.MIN_VALUE) continue;
                return value;
            }
            return Long.MIN_VALUE;
        }
    }

    private static class TwoLong256CoalesceFunction
    extends Long256Function
    implements BinaryCoalesceFunction {
        private final Function args0;
        private final Function args1;

        public TwoLong256CoalesceFunction(ObjList<Function> args) {
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public void getLong256(Record rec, CharSink<?> sink) {
            Long256 value = this.args0.getLong256A(rec);
            if (!CoalesceFunctionFactory.isNotNull(value)) {
                value = this.args1.getLong256A(rec);
            }
            Numbers.appendLong256(value, sink);
        }

        @Override
        public Long256 getLong256A(Record rec) {
            Long256 value = this.args0.getLong256A(rec);
            if (CoalesceFunctionFactory.isNotNull(value)) {
                return value;
            }
            return this.args1.getLong256A(rec);
        }

        @Override
        public Long256 getLong256B(Record rec) {
            Long256 value = this.args0.getLong256B(rec);
            if (CoalesceFunctionFactory.isNotNull(value)) {
                return value;
            }
            return this.args1.getLong256B(rec);
        }

        @Override
        public Function getRight() {
            return this.args1;
        }
    }

    private static class Long256CoalesceFunction
    extends Long256Function
    implements MultiArgCoalesceFunction {
        private final ObjList<Function> args;
        private final int size;

        public Long256CoalesceFunction(ObjList<Function> args) {
            this.args = args;
            this.size = args.size();
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public void getLong256(Record rec, CharSink<?> sink) {
            for (int i = 0; i < this.size; ++i) {
                Long256 value = this.args.getQuick(i).getLong256A(rec);
                if (!CoalesceFunctionFactory.isNotNull(value)) continue;
                Numbers.appendLong256(value, sink);
                return;
            }
        }

        @Override
        public Long256 getLong256A(Record rec) {
            Long256 value = Long256Impl.NULL_LONG256;
            for (int i = 0; i < this.size; ++i) {
                value = this.args.getQuick(i).getLong256A(rec);
                if (!CoalesceFunctionFactory.isNotNull(value)) continue;
                return value;
            }
            return value;
        }

        @Override
        public Long256 getLong256B(Record rec) {
            Long256 value = Long256Impl.NULL_LONG256;
            for (int i = 0; i < this.size; ++i) {
                value = this.args.getQuick(i).getLong256B(rec);
                if (!CoalesceFunctionFactory.isNotNull(value)) continue;
                return value;
            }
            return value;
        }
    }

    private static class TwoIntCoalesceFunction
    extends IntFunction
    implements BinaryCoalesceFunction {
        private final Function args0;
        private final Function args1;

        public TwoIntCoalesceFunction(ObjList<Function> args) {
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public int getInt(Record rec) {
            int value = this.args0.getInt(rec);
            if (value != Integer.MIN_VALUE) {
                return value;
            }
            return this.args1.getInt(rec);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }
    }

    private static class IntCoalesceFunction
    extends IntFunction
    implements MultiArgCoalesceFunction {
        private final ObjList<Function> args;
        private final int size;

        public IntCoalesceFunction(ObjList<Function> args, int size) {
            this.args = args;
            this.size = size;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public int getInt(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                int value = this.args.getQuick(i).getInt(rec);
                if (value == Integer.MIN_VALUE) continue;
                return value;
            }
            return Integer.MIN_VALUE;
        }
    }

    private static class TwoIPv4CoalesceFunction
    extends IPv4Function
    implements BinaryCoalesceFunction {
        private final Function args0;
        private final Function args1;

        public TwoIPv4CoalesceFunction(ObjList<Function> args) {
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public int getIPv4(Record rec) {
            int value = this.args0.getIPv4(rec);
            if (value != 0) {
                return value;
            }
            return this.args1.getIPv4(rec);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }
    }

    private static class IPv4CoalesceFunction
    extends IPv4Function
    implements MultiArgCoalesceFunction {
        private final ObjList<Function> args;
        private final int size;

        public IPv4CoalesceFunction(ObjList<Function> args, int size) {
            this.args = args;
            this.size = size;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public int getIPv4(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                int value = this.args.getQuick(i).getIPv4(rec);
                if (value == 0) continue;
                return value;
            }
            return 0;
        }
    }

    private static class TwoFloatCoalesceFunction
    extends FloatFunction
    implements BinaryCoalesceFunction {
        private final Function args0;
        private final Function args1;

        public TwoFloatCoalesceFunction(ObjList<Function> args) {
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public float getFloat(Record rec) {
            float value = this.args0.getFloat(rec);
            if (Numbers.isFinite(value)) {
                return value;
            }
            return this.args1.getFloat(rec);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }
    }

    private static class FloatCoalesceFunction
    extends FloatFunction
    implements MultiArgCoalesceFunction {
        private final ObjList<Function> args;
        private final int size;

        public FloatCoalesceFunction(ObjList<Function> args, int size) {
            this.args = args;
            this.size = size;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public float getFloat(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                float value = this.args.getQuick(i).getFloat(rec);
                if (!Numbers.isFinite(value)) continue;
                return value;
            }
            return Float.NaN;
        }
    }

    private static class TwoSymStrCoalesceFunction
    extends StrFunction
    implements BinaryCoalesceFunction {
        private final boolean arg1IsSymbol;
        private final Function args0;
        private final boolean args0IsSymbol;
        private final Function args1;

        public TwoSymStrCoalesceFunction(ObjList<Function> args) {
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
            this.args0IsSymbol = ColumnType.isSymbol(this.args0.getType());
            this.arg1IsSymbol = ColumnType.isSymbol(this.args1.getType());
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            CharSequence value;
            CharSequence charSequence = value = this.args0IsSymbol ? this.args0.getSymbol(rec) : this.args0.getStrA(rec);
            if (value != null) {
                return value;
            }
            return this.arg1IsSymbol ? this.args1.getSymbol(rec) : this.args1.getStrA(rec);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            CharSequence value;
            CharSequence charSequence = value = this.args0IsSymbol ? this.args0.getSymbolB(rec) : this.args0.getStrB(rec);
            if (value != null) {
                return value;
            }
            return this.arg1IsSymbol ? this.args1.getSymbolB(rec) : this.args1.getStrB(rec);
        }
    }

    private static class TwoSymCoalesceFunction
    extends StrFunction
    implements BinaryCoalesceFunction {
        private final Function args0;
        private final Function args1;

        public TwoSymCoalesceFunction(ObjList<Function> args) {
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            CharSequence value = this.args0.getSymbol(rec);
            if (value != null) {
                return value;
            }
            return this.args1.getSymbol(rec);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            CharSequence value = this.args0.getSymbolB(rec);
            if (value != null) {
                return value;
            }
            return this.args1.getSymbolB(rec);
        }
    }

    private static class TwoStrCoalesceFunction
    extends StrFunction
    implements BinaryCoalesceFunction {
        private final Function args0;
        private final Function args1;

        public TwoStrCoalesceFunction(ObjList<Function> args) {
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            CharSequence value = this.args0.getStrA(rec);
            if (value != null) {
                return value;
            }
            return this.args1.getStrA(rec);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            CharSequence value = this.args0.getStrB(rec);
            if (value != null) {
                return value;
            }
            return this.args1.getStrB(rec);
        }
    }

    private static class SymStrCoalesceFunction
    extends StrFunction
    implements MultiArgCoalesceFunction {
        private final ObjList<Function> args;
        private final int size;

        public SymStrCoalesceFunction(ObjList<Function> args, int size) {
            this.args = args;
            this.size = size;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                CharSequence value;
                Function arg = this.args.getQuick(i);
                CharSequence charSequence = value = ColumnType.isSymbol(arg.getType()) ? arg.getSymbol(rec) : arg.getStrA(rec);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                CharSequence value;
                Function arg = this.args.getQuick(i);
                CharSequence charSequence = value = ColumnType.isSymbol(arg.getType()) ? arg.getSymbolB(rec) : arg.getStrB(rec);
                if (value == null) continue;
                return value;
            }
            return null;
        }
    }

    private static class TwoVarcharCoalesceFunction
    extends VarcharFunction
    implements BinaryCoalesceFunction {
        private final Function args0;
        private final Function args1;

        public TwoVarcharCoalesceFunction(ObjList<Function> args) {
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public Function getRight() {
            return this.args1;
        }

        @Override
        public Utf8Sequence getVarcharA(Record rec) {
            Utf8Sequence value = this.args0.getVarcharA(rec);
            if (value != null) {
                return value;
            }
            return this.args1.getVarcharA(rec);
        }

        @Override
        public Utf8Sequence getVarcharB(Record rec) {
            Utf8Sequence value = this.args0.getVarcharB(rec);
            if (value != null) {
                return value;
            }
            return this.args1.getVarcharB(rec);
        }
    }

    private static class VarcharCoalesceFunction
    extends VarcharFunction
    implements MultiArgCoalesceFunction {
        private final ObjList<Function> args;
        private final int size;

        public VarcharCoalesceFunction(ObjList<Function> args, int size) {
            this.args = args;
            this.size = size;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public Utf8Sequence getVarcharA(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                Function arg = this.args.getQuick(i);
                Utf8Sequence value = arg.getVarcharA(rec);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        public Utf8Sequence getVarcharB(Record rec) {
            for (int i = 0; i < this.size; ++i) {
                Function arg = this.args.getQuick(i);
                Utf8Sequence value = arg.getVarcharB(rec);
                if (value == null) continue;
                return value;
            }
            return null;
        }
    }

    private static class TwoUuidCoalesceFunction
    extends UuidFunction
    implements BinaryFunction {
        private final Function args0;
        private final Function args1;

        public TwoUuidCoalesceFunction(ObjList<Function> args) {
            assert (args.size() == 2);
            this.args0 = args.getQuick(0);
            this.args1 = args.getQuick(1);
        }

        @Override
        public Function getLeft() {
            return this.args0;
        }

        @Override
        public long getLong128Hi(Record rec) {
            long hi0 = this.args0.getLong128Hi(rec);
            if (hi0 != Long.MIN_VALUE) {
                return hi0;
            }
            long lo0 = this.args0.getLong128Lo(rec);
            if (lo0 != Long.MIN_VALUE) {
                return hi0;
            }
            return this.args1.getLong128Hi(rec);
        }

        @Override
        public long getLong128Lo(Record rec) {
            long lo0 = this.args0.getLong128Lo(rec);
            if (lo0 != Long.MIN_VALUE) {
                return lo0;
            }
            long hi0 = this.args0.getLong128Hi(rec);
            if (hi0 != Long.MIN_VALUE) {
                return lo0;
            }
            return this.args1.getLong128Lo(rec);
        }

        @Override
        public Function getRight() {
            return this.args1;
        }
    }

    private static class UuidCoalesceFunction
    extends UuidFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;
        private final int size;

        public UuidCoalesceFunction(ObjList<Function> args, int argsSize) {
            this.args = args;
            this.size = argsSize;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public long getLong128Hi(Record rec) {
            long value = Long.MIN_VALUE;
            for (int i = 0; i < this.size; ++i) {
                value = this.args.getQuick(i).getLong128Hi(rec);
                if (value != Long.MIN_VALUE) {
                    return value;
                }
                long lo = this.args.getQuick(i).getLong128Lo(rec);
                if (lo == Long.MIN_VALUE) continue;
                return value;
            }
            return value;
        }

        @Override
        public long getLong128Lo(Record rec) {
            long value = Long.MIN_VALUE;
            for (int i = 0; i < this.size; ++i) {
                value = this.args.getQuick(i).getLong128Lo(rec);
                if (value != Long.MIN_VALUE) {
                    return value;
                }
                long hi = this.args.getQuick(i).getLong128Hi(rec);
                if (hi == Long.MIN_VALUE) continue;
                return value;
            }
            return value;
        }
    }

    private static interface MultiArgCoalesceFunction
    extends MultiArgFunction {
        @Override
        default public String getName() {
            return "coalesce";
        }
    }

    private static interface BinaryCoalesceFunction
    extends BinaryFunction {
        @Override
        default public String getName() {
            return "coalesce";
        }
    }
}

