/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToCharFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;

public class CastVarcharToCharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(\u00d8a)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends AbstractCastToCharFunction {
        private final StringSink utf16Sink = new StringSink();

        public Func(Function arg) {
            super(arg);
        }

        @Override
        public char getChar(Record rec) {
            Utf8Sequence value = this.arg.getVarcharA(rec);
            if (value == null) {
                return '\u0000';
            }
            this.utf16Sink.clear();
            this.utf16Sink.put(value);
            return this.utf16Sink.length() > 0 ? this.utf16Sink.charAt(0) : (char)'\u0000';
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }
    }
}

