/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToVarcharFunction;
import io.questdb.griffin.engine.functions.constants.VarcharConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;

public class CastStrToVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(S\u00f8)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            return VarcharConstant.newInstance(arg.getStrA(null));
        }
        return new Func(arg);
    }

    public static class Func
    extends AbstractCastToVarcharFunction {
        private final Utf8StringSink sinkA = new Utf8StringSink();
        private final Utf8StringSink sinkB = new Utf8StringSink();

        public Func(Function arg) {
            super(arg);
        }

        @Override
        public Utf8Sequence getVarcharA(Record rec) {
            CharSequence cs = this.arg.getStrA(rec);
            if (cs != null) {
                this.sinkA.clear();
                this.sinkA.put(cs);
                return this.sinkA;
            }
            return null;
        }

        @Override
        public Utf8Sequence getVarcharB(Record rec) {
            CharSequence cs = this.arg.getStrB(rec);
            if (cs != null) {
                this.sinkB.clear();
                this.sinkB.put(cs);
                return this.sinkB;
            }
            return null;
        }
    }
}

