/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.cast.AbstractCastToBooleanFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastStrToBooleanFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(St)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg0 = args.getQuick(0);
        if (arg0.isConstant()) {
            return CastStrToBooleanFunctionFactory.resolveBoolean(arg0.getStrA(null)) ? BooleanConstant.TRUE : BooleanConstant.FALSE;
        }
        return new Func(arg0);
    }

    private static boolean resolveBoolean(CharSequence str) {
        return str != null && SqlKeywords.isTrueKeyword(str);
    }

    private static class Func
    extends AbstractCastToBooleanFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public boolean getBool(Record rec) {
            return CastStrToBooleanFunctionFactory.resolveBoolean(this.arg.getStrA(rec));
        }
    }
}

