/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.bool.WithinGeohashFunctionFactory;
import io.questdb.griffin.engine.functions.cast.AbstractCastToVarcharFunction;
import io.questdb.griffin.engine.functions.constants.VarcharConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;
import java.util.Objects;

public class CastGeoHashToVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(G\u00f8)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function geoHashFunc = args.getQuick(0);
        if (geoHashFunc.isConstant()) {
            int geoHashFuncType = geoHashFunc.getType();
            StringSink sink = Misc.getThreadLocalSink();
            long hash = WithinGeohashFunctionFactory.getGeoHashAsLong(null, geoHashFunc, geoHashFuncType);
            GeoHashes.appendNoQuotes(hash, GeoHashes.getBitFlags(geoHashFuncType), sink);
            return new VarcharConstant(Chars.toString(sink));
        }
        return new Func(args.getQuick(0));
    }

    public static class Func
    extends AbstractCastToVarcharFunction {
        private final int argType;
        private final Utf8StringSink sinkA = new Utf8StringSink();
        private final Utf8StringSink sinkB = new Utf8StringSink();

        public Func(Function arg) {
            super(arg);
            this.argType = arg.getType();
        }

        public void getVarchar(Record rec, Utf8StringSink sink) {
            long hash = WithinGeohashFunctionFactory.getGeoHashAsLong(rec, this.arg, this.argType);
            sink.clear();
            if (hash != -1L) {
                GeoHashes.appendNoQuotes(hash, GeoHashes.getBitFlags(this.argType), sink);
            }
        }

        @Override
        public Utf8Sequence getVarcharA(Record rec) {
            this.getVarchar(rec, this.sinkA);
            return this.sinkA;
        }

        @Override
        public Utf8Sequence getVarcharB(Record rec) {
            this.getVarchar(rec, this.sinkB);
            return this.sinkB;
        }

        @Override
        public int getVarcharSize(Record rec) {
            return Objects.requireNonNull(this.getVarcharA(rec)).size();
        }
    }
}

