/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.IntList;
import io.questdb.std.LongLongHashSet;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Uuid;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;

public final class InUuidFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(Zv)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int argCount = args.size() - 1;
        int n = args.size();
        int constCount = 0;
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (func.getType()) {
                case 0: 
                case 11: 
                case 12: 
                case 19: 
                case 26: 
                case 33: {
                    break;
                }
                default: {
                    throw SqlException.position(argPositions.getQuick(i)).put("cannot compare UUID with type ").put(ColumnType.nameOf(func.getType()));
                }
            }
            if (func.isConstant()) {
                ++constCount;
            }
            if (func.isRuntimeConstant() || func.isConstant()) continue;
            throw SqlException.$(argPositions.getQuick(i), "constant or bind variable expected");
        }
        if (constCount == argCount) {
            LongLongHashSet set = InUuidFunctionFactory.makeUUIDHashSet(argCount);
            for (int i = 1; i < n; ++i) {
                InUuidFunctionFactory.addUUIDToSet(args.getQuick(i), argPositions.getQuick(i), set);
            }
            Function keyFunc = args.getQuick(0);
            if (keyFunc.isConstant()) {
                long hi;
                long lo = keyFunc.getLong128Lo(null);
                if (Uuid.isNull(lo, hi = keyFunc.getLong128Hi(null))) {
                    return BooleanConstant.FALSE;
                }
                return BooleanConstant.of(set.contains(lo, hi));
            }
            return new InUUIDConstFunction(keyFunc, set);
        }
        IntList positions = new IntList();
        positions.addAll(argPositions);
        return new InUUIDRuntimeConstFunction(args.getQuick(0), new ObjList<Function>(args), positions, InUuidFunctionFactory.makeUUIDHashSet(argCount));
    }

    private static void addUUIDToSet(Function func, int argPosition, LongLongHashSet set) throws SqlException {
        switch (ColumnType.tagOf(func.getType())) {
            case 26: {
                Utf8Sequence value2 = func.getVarcharA(null);
                if (value2 == null) {
                    set.addNull();
                    break;
                }
                try {
                    Uuid.checkDashesAndLength(value2);
                    set.add(Uuid.parseLo(value2, 0), Uuid.parseHi(value2, 0));
                    break;
                }
                catch (NumericException e) {
                    throw SqlException.$(argPosition, "invalid UUID value [").put(value2).put(']');
                }
            }
            case 11: 
            case 12: 
            case 33: {
                CharSequence value = func.getStrA(null);
                if (value == null) {
                    set.addNull();
                    break;
                }
                try {
                    Uuid.checkDashesAndLength(value);
                    set.add(Uuid.parseLo(value), Uuid.parseHi(value));
                    break;
                }
                catch (NumericException e) {
                    throw SqlException.$(argPosition, "invalid UUID value [").put(value).put(']');
                }
            }
            case 19: {
                long lo = func.getLong128Lo(null);
                long hi = func.getLong128Hi(null);
                if (hi == Long.MIN_VALUE && lo == Long.MIN_VALUE) {
                    throw SqlException.$(argPosition, "NULL is not allowed in IN list");
                }
                set.add(lo, hi);
                break;
            }
            default: {
                throw SqlException.inconvertibleTypes(argPosition, func.getType(), ColumnType.nameOf(func.getType()), 19, ColumnType.nameOf(19));
            }
        }
    }

    @NotNull
    private static LongLongHashSet makeUUIDHashSet(int argCount) {
        return new LongLongHashSet(argCount, 0.6, Long.MIN_VALUE, LongLongHashSet.UUID_STRATEGY);
    }

    private static class InUUIDConstFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final LongLongHashSet set;

        public InUUIDConstFunction(Function arg, LongLongHashSet set) {
            this.arg = arg;
            this.set = set;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            long hi;
            long lo = this.arg.getLong128Lo(rec);
            if (Uuid.isNull(lo, hi = this.arg.getLong128Hi(rec))) {
                return this.set.hasNull();
            }
            return this.set.contains(lo, hi);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg).val(" in ").val(this.set);
        }
    }

    private static class InUUIDRuntimeConstFunction
    extends BooleanFunction
    implements MultiArgFunction {
        private final Function keyFunc;
        private final LongLongHashSet set;
        private final IntList valueFunctionPositions;
        private final ObjList<Function> valueFunctions;

        public InUUIDRuntimeConstFunction(Function keyFunc, ObjList<Function> valueFunctions, IntList valueFunctionPositions, LongLongHashSet set) {
            this.keyFunc = keyFunc;
            this.valueFunctions = valueFunctions;
            this.valueFunctionPositions = valueFunctionPositions;
            this.set = set;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.valueFunctions;
        }

        @Override
        public boolean getBool(Record rec) {
            long hi;
            long lo = this.keyFunc.getLong128Lo(rec);
            if (Uuid.isNull(lo, hi = this.keyFunc.getLong128Hi(rec))) {
                return this.set.hasNull();
            }
            return this.set.contains(lo, hi);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            MultiArgFunction.super.init(symbolTableSource, executionContext);
            this.set.clear();
            int n = this.valueFunctions.size();
            for (int i = 1; i < n; ++i) {
                InUuidFunctionFactory.addUUIDToSet(this.valueFunctions.getQuick(i), this.valueFunctionPositions.getQuick(i), this.set);
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.keyFunc).val(" in ").val(this.set);
        }
    }
}

