/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.QuaternaryFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class AndFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "and(TT)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function leftFunc = args.getQuick(0);
        Function rightFunc = args.getQuick(1);
        if (leftFunc.isConstant()) {
            try (Function ignore = leftFunc;){
                if (leftFunc.getBool(null)) {
                    Function function = rightFunc;
                    return function;
                }
                Misc.free(rightFunc);
                BooleanConstant booleanConstant = BooleanConstant.FALSE;
                return booleanConstant;
            }
        }
        if (rightFunc.isConstant()) {
            try (Function ignore = rightFunc;){
                if (rightFunc.getBool(null)) {
                    Function function = leftFunc;
                    return function;
                }
                Misc.free(leftFunc);
                BooleanConstant booleanConstant = BooleanConstant.FALSE;
                return booleanConstant;
            }
        }
        if (leftFunc instanceof AndBooleanFunction) {
            AndBooleanFunction leftAndFunc = (AndBooleanFunction)leftFunc;
            return new TernaryAndBooleanFunction(leftAndFunc.left, leftAndFunc.right, rightFunc);
        }
        if (leftFunc instanceof TernaryAndBooleanFunction) {
            TernaryAndBooleanFunction leftAndFunc = (TernaryAndBooleanFunction)leftFunc;
            return new QuaternaryAndBooleanFunction(leftAndFunc.left, leftAndFunc.center, leftAndFunc.right, rightFunc);
        }
        return new AndBooleanFunction(leftFunc, rightFunc);
    }

    private static class AndBooleanFunction
    extends BooleanFunction
    implements BinaryFunction {
        final Function left;
        final Function right;

        public AndBooleanFunction(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.left.getBool(rec) && this.right.getBool(rec);
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val('(');
            sink.val(this.left);
            sink.val(" and ");
            sink.val(this.right);
            sink.val(')');
        }
    }

    private static class TernaryAndBooleanFunction
    extends BooleanFunction
    implements TernaryFunction {
        final Function center;
        final Function left;
        final Function right;

        public TernaryAndBooleanFunction(Function left, Function center, Function right) {
            this.left = left;
            this.center = center;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.left.getBool(rec) && this.center.getBool(rec) && this.right.getBool(rec);
        }

        @Override
        public Function getCenter() {
            return this.center;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val('(');
            sink.val(this.left);
            sink.val(" and ");
            sink.val(this.center);
            sink.val(" and ");
            sink.val(this.right);
            sink.val(')');
        }
    }

    private static class QuaternaryAndBooleanFunction
    extends BooleanFunction
    implements QuaternaryFunction {
        final Function func0;
        final Function func1;
        final Function func2;
        final Function func3;

        public QuaternaryAndBooleanFunction(Function func0, Function func1, Function func2, Function func3) {
            this.func0 = func0;
            this.func1 = func1;
            this.func2 = func2;
            this.func3 = func3;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.func0.getBool(rec) && this.func1.getBool(rec) && this.func2.getBool(rec) && this.func3.getBool(rec);
        }

        @Override
        public Function getFunc0() {
            return this.func0;
        }

        @Override
        public Function getFunc1() {
            return this.func1;
        }

        @Override
        public Function getFunc2() {
            return this.func2;
        }

        @Override
        public Function getFunc3() {
            return this.func3;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val('(');
            sink.val(this.func0);
            sink.val(" and ");
            sink.val(this.func1);
            sink.val(" and ");
            sink.val(this.func2);
            sink.val(" and ");
            sink.val(this.func3);
            sink.val(')');
        }
    }
}

