/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IntervalFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Interval;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class IntIntervalRightOpenFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return ":(I)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new IntIntervalFunction(args.getQuick(0));
    }

    static class IntIntervalFunction
    extends IntervalFunction
    implements UnaryFunction {
        private final Function arg;
        private final Interval interval = new Interval();

        public IntIntervalFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        @NotNull
        public Interval getInterval(Record rec) {
            this.interval.of(this.arg.getInt(rec), Long.MAX_VALUE);
            return this.interval;
        }

        @Override
        public String getName() {
            return ":";
        }

        @Override
        public boolean isOperator() {
            return true;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg).val(':');
        }
    }
}

