/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.FlatArrayView;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class DoubleArrayStdDevSampFunctionFactory
implements FunctionFactory {
    private static final String FUNCTION_NAME = "array_stddev_samp";

    @Override
    public String getSignature() {
        return "array_stddev_samp(D[])";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new Func(args.getQuick(0));
    }

    protected static class Func
    extends DoubleFunction
    implements UnaryFunction {
        private final Function arrayArg;
        protected int count;
        private double deltaSquaredSum;
        private double mean;

        Func(Function arrayArg) {
            this.arrayArg = arrayArg;
        }

        @Override
        public Function getArg() {
            return this.arrayArg;
        }

        @Override
        public double getDouble(Record rec) {
            ArrayView arr = this.arrayArg.getArray(rec);
            if (arr.isNull()) {
                return Double.NaN;
            }
            this.deltaSquaredSum = 0.0;
            this.mean = 0.0;
            this.count = 0;
            if (arr.isVanilla()) {
                FlatArrayView flatView = arr.flatView();
                int offset = arr.getFlatViewOffset();
                int length = arr.getFlatViewLength();
                int n = offset + length;
                for (int i = offset; i < n; ++i) {
                    double value = flatView.getDoubleAtAbsIndex(i);
                    if (!Numbers.isFinite(value)) continue;
                    ++this.count;
                    double oldMean = this.mean;
                    this.mean += (value - this.mean) / (double)this.count;
                    this.deltaSquaredSum += (value - this.mean) * (value - oldMean);
                }
            } else {
                this.calculateRecursive(arr, 0, 0);
            }
            long countForVariance = this.getCountForVariance();
            if (countForVariance <= 0L) {
                return Double.NaN;
            }
            double variance = this.deltaSquaredSum / (double)countForVariance;
            if (variance < 0.0) {
                variance = 0.0;
            }
            return Math.sqrt(variance);
        }

        @Override
        public String getName() {
            return DoubleArrayStdDevSampFunctionFactory.FUNCTION_NAME;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        private void calculateRecursive(ArrayView view, int dim, int flatIndex) {
            boolean atDeepestDim;
            int count = view.getDimLen(dim);
            int stride = view.getStride(dim);
            boolean bl = atDeepestDim = dim == view.getDimCount() - 1;
            if (atDeepestDim) {
                for (int i = 0; i < count; ++i) {
                    double value = view.getDouble(flatIndex);
                    if (Numbers.isFinite(value)) {
                        ++this.count;
                        double oldMean = this.mean;
                        this.mean += (value - this.mean) / (double)this.count;
                        this.deltaSquaredSum += (value - this.mean) * (value - oldMean);
                    }
                    flatIndex += stride;
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    this.calculateRecursive(view, dim + 1, flatIndex);
                    flatIndex += stride;
                }
            }
        }

        protected int getCountForVariance() {
            return this.count - 1;
        }
    }
}

