/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.Nullable;

public class LimitRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final LimitRecordCursor cursor;

    public LimitRecordCursorFactory(RecordCursorFactory base, Function loFunction, @Nullable Function hiFunction) {
        super(base.getMetadata());
        this.base = base;
        this.cursor = new LimitRecordCursor(loFunction, hiFunction);
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        if (this.cursor.hiFunction != null) {
            executionContext.setColumnPreTouchEnabled(false);
        }
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.cursor.of(baseCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable th) {
            this.cursor.close();
            throw th;
        }
    }

    @Override
    public int getScanDirection() {
        return this.base.getScanDirection();
    }

    @Override
    public boolean implementsLimit() {
        return true;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Limit");
        Function loFunc = this.cursor.loFunction;
        Function hiFunc = this.cursor.hiFunction;
        if (loFunc != null) {
            sink.meta("lo").val(loFunc);
            if (loFunc.isRuntimeConstant()) {
                sink.val('[').val(loFunc.getLong(null)).val(']');
            }
        }
        if (hiFunc != null) {
            sink.meta("hi").val(hiFunc);
            if (hiFunc.isRuntimeConstant()) {
                sink.val('[').val(hiFunc.getLong(null)).val(']');
            }
        }
        if (this.cursor.base != null && loFunc != null && loFunc.getLong(null) != Long.MIN_VALUE) {
            this.cursor.countLimit();
            sink.meta("skip-over-rows").val(this.cursor.skippedRows);
            sink.meta("limit").val(this.cursor.limit);
        }
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    @Override
    protected void _close() {
        this.base.close();
    }

    private static class LimitRecordCursor
    implements RecordCursor {
        private final RecordCursor.Counter counter = new RecordCursor.Counter();
        private final Function hiFunction;
        private final Function loFunction;
        private boolean areRowsCounted;
        private RecordCursor base;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private long hi;
        private boolean isLimitCounted;
        private long countedLimit;
        private long limit;
        private long lo;
        private long rowCount;
        private long size;
        private long skipToRows;
        private long skippedRows;

        public LimitRecordCursor(Function loFunction, Function hiFunction) {
            this.loFunction = loFunction;
            this.hiFunction = hiFunction;
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            if (this.areRowsCounted && this.limit > 0L) {
                counter.add(this.size);
                this.limit = 0L;
                return;
            }
            this.countLimitIfNotCounted();
            while (this.limit > 0L && this.base.hasNext()) {
                --this.limit;
                counter.inc();
            }
        }

        @Override
        public void close() {
            this.base = Misc.free(this.base);
        }

        @Override
        public Record getRecord() {
            return this.base.getRecord();
        }

        @Override
        public Record getRecordB() {
            return this.base.getRecordB();
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.base.getSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            this.countLimitIfNotCounted();
            if (this.limit <= 0L) {
                return false;
            }
            if (this.base.hasNext()) {
                --this.limit;
                return true;
            }
            return false;
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.base.newSymbolTable(columnIndex);
        }

        public void of(RecordCursor base, SqlExecutionContext executionContext) throws SqlException {
            this.base = base;
            this.loFunction.init(base, executionContext);
            if (this.hiFunction != null) {
                this.hiFunction.init(base, executionContext);
            }
            this.circuitBreaker = executionContext.getCircuitBreaker();
            this.rowCount = -1L;
            this.size = -1L;
            this.lo = this.loFunction.getLong(null);
            long l = this.hi = this.hiFunction != null ? this.hiFunction.getLong(null) : -1L;
            if (this.hi != -1L && this.hi < this.lo && Numbers.sameSign(this.lo, this.hi)) {
                long l2 = this.hi;
                this.hi = this.lo;
                this.lo = l2;
            }
            this.skipToRows = -1L;
            this.skippedRows = 0L;
            this.isLimitCounted = false;
            this.areRowsCounted = false;
            this.counter.clear();
        }

        @Override
        public long preComputedStateSize() {
            return RecordCursor.fromBool(this.areRowsCounted) + RecordCursor.fromBool(this.isLimitCounted) + this.base.preComputedStateSize();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.base.recordAt(record, atRowId);
        }

        @Override
        public long size() {
            this.countLimitIfNotCounted();
            return this.size;
        }

        @Override
        public void toTop() {
            this.base.toTop();
            this.limit = this.countedLimit;
            this.skipToRows = -1L;
            this.skipRows(this.skippedRows);
        }

        private void countLimit() {
            if (this.lo < 0L && this.hiFunction == null) {
                this.countRows();
                if (this.rowCount > -this.lo) {
                    this.skipRows(this.rowCount + this.lo);
                } else {
                    this.base.toTop();
                }
                this.size = this.limit = Math.min(this.rowCount, -this.lo);
            } else if (this.lo > -1L && this.hiFunction == null) {
                long baseRowCount = this.base.size();
                if (baseRowCount > -1L) {
                    this.limit = Math.min(baseRowCount, this.lo);
                    this.areRowsCounted = true;
                } else {
                    this.limit = this.lo;
                    this.areRowsCounted = false;
                }
                this.countRows();
                this.size = Math.min(this.rowCount, this.limit);
            } else if (this.lo < 0L) {
                if (this.lo < this.hi) {
                    this.countRows();
                    if (this.rowCount >= -this.hi) {
                        if (this.rowCount < -this.lo) {
                            this.base.toTop();
                            this.limit = this.rowCount + this.hi;
                        } else {
                            this.skipRows(this.rowCount + this.lo);
                            this.limit = Math.min(this.rowCount, -this.lo + this.hi);
                        }
                        this.size = this.limit;
                    } else {
                        this.size = 0L;
                        this.limit = 0L;
                    }
                } else {
                    this.limit = 0L;
                    this.size = 0L;
                }
            } else if (this.hi < 0L) {
                this.countRows();
                this.size = this.limit = Math.max(this.rowCount - this.lo + this.hi, 0L);
                if (this.lo > 0L && this.limit > 0L) {
                    this.skipRows(this.lo);
                } else {
                    this.base.toTop();
                }
            } else {
                long baseRowCount = this.base.size();
                if (baseRowCount > -1L) {
                    this.limit = Math.max(0L, Math.min(baseRowCount, this.hi) - this.lo);
                    this.areRowsCounted = true;
                } else {
                    this.limit = Math.max(0L, this.hi - this.lo);
                    this.areRowsCounted = false;
                }
                this.size = this.limit;
                if (this.lo > 0L && this.limit > 0L) {
                    this.skipRows(this.lo);
                }
            }
        }

        private void countLimitIfNotCounted() {
            if (!this.isLimitCounted) {
                this.countLimit();
                this.countedLimit = this.limit;
                this.isLimitCounted = true;
            }
        }

        private void countRows() {
            if (this.rowCount == -1L) {
                this.rowCount = this.base.size();
                if (this.rowCount > -1L) {
                    this.areRowsCounted = true;
                    return;
                }
                this.rowCount = 0L;
            }
            if (!this.areRowsCounted) {
                this.base.calculateSize(this.circuitBreaker, this.counter);
                this.base.toTop();
                this.rowCount = this.counter.get();
                this.areRowsCounted = true;
                this.counter.clear();
            }
        }

        private void skipRows(long rowCount) {
            if (this.skipToRows == -1L) {
                this.skipToRows = Math.max(0L, rowCount);
                this.counter.set(this.skipToRows);
                this.skippedRows = this.skipToRows;
                this.base.toTop();
            }
            if (this.skipToRows > 0L) {
                this.base.skipRows(this.counter);
                this.skipToRows = 0L;
                this.counter.clear();
            }
        }
    }
}

