/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.AbstractRecordMetadata;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.RecordMetadata;

public class PriorityMetadata
extends AbstractRecordMetadata {
    private final RecordMetadata baseMetadata;
    private final int virtualColumnReservedSlots;

    public PriorityMetadata(int virtualColumnReservedSlots, RecordMetadata baseMetadata) {
        this.virtualColumnReservedSlots = virtualColumnReservedSlots;
        this.baseMetadata = baseMetadata;
    }

    public void add(TableColumnMetadata m) {
        int keyIndex = this.columnNameIndexMap.keyIndex(m.getColumnName());
        if (keyIndex < 0) {
            throw CairoException.duplicateColumn(m.getColumnName());
        }
        int pos = this.columnMetadata.size();
        this.columnMetadata.add(m);
        this.columnNameIndexMap.putAt(keyIndex, m.getColumnName(), pos);
    }

    @Override
    public int getColumnIndexQuiet(CharSequence columnName, int lo, int hi) {
        int index = this.baseMetadata.getColumnIndexQuiet(columnName, lo, hi);
        if (index == -1) {
            int keyIndex = this.columnNameIndexMap.keyIndex(columnName, lo, hi);
            if (keyIndex < 0) {
                return this.columnNameIndexMap.valueAt(keyIndex);
            }
            return -1;
        }
        return index + this.virtualColumnReservedSlots;
    }

    @Override
    public TableColumnMetadata getColumnMetadata(int index) {
        if (index < this.virtualColumnReservedSlots) {
            return (TableColumnMetadata)this.columnMetadata.getQuick(index);
        }
        return this.baseMetadata.getColumnMetadata(index - this.virtualColumnReservedSlots);
    }
}

