/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlException;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.str.StringSink;

public class FunctionFactoryDescriptor {
    private static final int ARRAY_MASK = Integer.MIN_VALUE;
    private static final int CONST_MASK = 0x40000000;
    private static final int TYPE_MASK = 0x3FFFFFFF;
    private static final IntObjHashMap<String> typeNameMap = new IntObjHashMap();
    private final long[] argTypes;
    private final FunctionFactory factory;
    private final int openParenIndex;
    private final int sigArgCount;

    public FunctionFactoryDescriptor(FunctionFactory factory) throws SqlException {
        this.factory = factory;
        String sig = factory.getSignature();
        this.openParenIndex = FunctionFactoryDescriptor.validateSignatureAndGetNameSeparator(sig);
        int typeCount = 0;
        int i = this.openParenIndex + 1;
        int n = sig.length() - 1;
        while (i < n) {
            char cc = sig.charAt(i);
            if (FunctionFactoryDescriptor.getArgTypeTag(cc) == -1) {
                throw SqlException.position(0).put("illegal argument type: ").put('`').put(cc).put('`');
            }
            if (++i < n && sig.charAt(i) == '[') {
                if (++i >= n || sig.charAt(i) != ']') {
                    throw SqlException.position(0).put("invalid array declaration: " + sig);
                }
                ++i;
            }
            ++typeCount;
        }
        long[] types = new long[typeCount % 2 == 0 ? typeCount / 2 : typeCount / 2 + 1];
        int i2 = this.openParenIndex + 1;
        int n2 = sig.length() - 1;
        int typeIndex = 0;
        while (i2 < n2) {
            char c = sig.charAt(i2);
            int type = FunctionFactoryDescriptor.getArgTypeTag(c);
            int arrayIndex = typeIndex / 2;
            int arrayValueOffset = typeIndex % 2 * 32;
            if (++i2 < n2 && sig.charAt(i2) == '[') {
                type |= Integer.MIN_VALUE;
                i2 += 2;
            }
            if ((c & 0x20) != 0) {
                type |= 0x40000000;
            }
            int n3 = arrayIndex;
            types[n3] = types[n3] | FunctionFactoryDescriptor.toUnsignedLong(type) << 32 - arrayValueOffset;
            ++typeIndex;
        }
        this.argTypes = types;
        this.sigArgCount = typeCount;
    }

    public static short getArgTypeTag(char c) {
        short sigArgType;
        switch (c | 0x20) {
            case 97: {
                sigArgType = 4;
                break;
            }
            case 98: {
                sigArgType = 2;
                break;
            }
            case 99: {
                sigArgType = 20;
                break;
            }
            case 100: {
                sigArgType = 10;
                break;
            }
            case 101: {
                sigArgType = 3;
                break;
            }
            case 102: {
                sigArgType = 9;
                break;
            }
            case 103: {
                sigArgType = 23;
                break;
            }
            case 104: {
                sigArgType = 13;
                break;
            }
            case 105: {
                sigArgType = 5;
                break;
            }
            case 106: {
                sigArgType = 24;
                break;
            }
            case 107: {
                sigArgType = 12;
                break;
            }
            case 108: {
                sigArgType = 6;
                break;
            }
            case 109: {
                sigArgType = 7;
                break;
            }
            case 110: {
                sigArgType = 8;
                break;
            }
            case 111: {
                sigArgType = 33;
                break;
            }
            case 112: {
                sigArgType = 28;
                break;
            }
            case 113: {
                sigArgType = 29;
                break;
            }
            case 114: {
                sigArgType = 22;
                break;
            }
            case 115: {
                sigArgType = 11;
                break;
            }
            case 116: {
                sigArgType = 1;
                break;
            }
            case 117: {
                sigArgType = 18;
                break;
            }
            case 118: {
                sigArgType = 21;
                break;
            }
            case 119: {
                sigArgType = 30;
                break;
            }
            case 120: {
                sigArgType = 25;
                break;
            }
            case 122: {
                sigArgType = 19;
                break;
            }
            case 248: {
                sigArgType = 26;
                break;
            }
            case 948: {
                sigArgType = 32;
                break;
            }
            default: {
                sigArgType = -1;
            }
        }
        return sigArgType;
    }

    public static boolean isArray(int mask) {
        return (mask & Integer.MIN_VALUE) != 0;
    }

    public static boolean isConstant(int mask) {
        return (mask & 0x40000000) != 0;
    }

    public static String replaceSignatureName(String name, String signature) throws SqlException {
        int openParenIndex = FunctionFactoryDescriptor.validateSignatureAndGetNameSeparator(signature);
        StringSink signatureBuilder = Misc.getThreadLocalSink();
        signatureBuilder.put(name);
        signatureBuilder.put(signature, openParenIndex, signature.length());
        return signatureBuilder.toString();
    }

    public static String replaceSignatureNameAndSwapArgs(String name, String signature) throws SqlException {
        int openParenIndex = FunctionFactoryDescriptor.validateSignatureAndGetNameSeparator(signature);
        StringSink signatureBuilder = Misc.getThreadLocalSink();
        signatureBuilder.put(name);
        signatureBuilder.put('(');
        boolean bracket = false;
        for (int i = signature.length() - 2; i > openParenIndex; --i) {
            char curr = signature.charAt(i);
            if (curr == '[') {
                bracket = true;
                continue;
            }
            if (curr == ']') continue;
            signatureBuilder.put(curr);
            if (!bracket) continue;
            signatureBuilder.put("[]");
            bracket = false;
        }
        if (bracket) {
            signatureBuilder.put("[]");
        }
        signatureBuilder.put(')');
        return signatureBuilder.toString();
    }

    public static short toTypeTag(int typeWithFlags) {
        return (short)(typeWithFlags & 0x3FFFFFFF);
    }

    public static StringSink translateSignature(CharSequence funcName, String signature, StringSink sink) {
        try {
            int openParenIndex = FunctionFactoryDescriptor.validateSignatureAndGetNameSeparator(signature);
        }
        catch (SqlException err) {
            throw new IllegalArgumentException("offending: '" + signature + "', reason: " + err.getMessage());
        }
        sink.put(funcName).put('(');
        int n = signature.length() - 1;
        for (int i = openParenIndex + 1; i < n; ++i) {
            char c = signature.charAt(i);
            String type = typeNameMap.get(c | 0x20);
            if (type == null) {
                throw new IllegalArgumentException("offending: '" + c + "'");
            }
            if (c != '[') {
                if (Character.isLowerCase(c)) {
                    sink.put("const ");
                }
            } else {
                if (i < 3 || i + 2 > n || signature.charAt(i + 1) != ']') {
                    throw new IllegalArgumentException("offending array: '" + c + "'");
                }
                sink.clear(sink.length() - 2);
                ++i;
            }
            sink.put(type);
            if (i + 1 >= n) continue;
            sink.put(", ");
        }
        sink.put(')');
        return sink;
    }

    public static int validateSignatureAndGetNameSeparator(String sig) throws SqlException {
        if (sig == null) {
            throw SqlException.$(0, "NULL signature");
        }
        int openParenIndex = sig.indexOf(40);
        if (openParenIndex == -1) {
            throw SqlException.$(0, "open brace expected");
        }
        if (openParenIndex == 0) {
            throw SqlException.$(0, "empty function name");
        }
        if (sig.charAt(sig.length() - 1) != ')') {
            throw SqlException.$(0, "close brace expected");
        }
        char c = sig.charAt(0);
        if (c >= '0' && c <= '9') {
            throw SqlException.$(0, "name must not start with digit");
        }
        for (int i = 0; i < openParenIndex; ++i) {
            char cc = sig.charAt(i);
            if (!FunctionFactoryCache.invalidFunctionNameChars.contains(cc)) continue;
            throw SqlException.position(0).put("invalid character: ").put(cc);
        }
        if (FunctionFactoryCache.invalidFunctionNames.keyIndex(sig, 0, openParenIndex) < 0) {
            throw SqlException.position(0).put("invalid function name character: ").put(sig);
        }
        return openParenIndex;
    }

    public int getArgTypeWithFlags(int index) {
        int arrayIndex = index / 2;
        long mask = this.argTypes[arrayIndex];
        return (int)(mask >>> 32 - index % 2 * 32);
    }

    public FunctionFactory getFactory() {
        return this.factory;
    }

    public String getName() {
        return this.factory.getSignature().substring(0, this.openParenIndex);
    }

    public int getSigArgCount() {
        return this.sigArgCount;
    }

    private static long toUnsignedLong(int type) {
        return (long)type & 0xFFFFFFFFL;
    }

    static {
        typeNameMap.put(97, "char");
        typeNameMap.put(98, "byte");
        typeNameMap.put(99, "cursor");
        typeNameMap.put(100, "double");
        typeNameMap.put(101, "short");
        typeNameMap.put(102, "float");
        typeNameMap.put(103, "geohash");
        typeNameMap.put(104, "long256");
        typeNameMap.put(105, "int");
        typeNameMap.put(106, "long128");
        typeNameMap.put(107, "symbol");
        typeNameMap.put(108, "long");
        typeNameMap.put(109, "date");
        typeNameMap.put(110, "timestamp");
        typeNameMap.put(111, "null");
        typeNameMap.put(112, "reg_class");
        typeNameMap.put(113, "reg_procedure");
        typeNameMap.put(114, "record");
        typeNameMap.put(115, "string");
        typeNameMap.put(116, "boolean");
        typeNameMap.put(117, "binary");
        typeNameMap.put(118, "var_arg");
        typeNameMap.put(119, "array_string");
        typeNameMap.put(120, "ipv4");
        typeNameMap.put(122, "uuid");
        typeNameMap.put(248, "varchar");
        typeNameMap.put(948, "interval");
        typeNameMap.put(123, "[]");
    }
}

