/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.griffin.SqlKeywords;
import io.questdb.std.str.DirectUtf8Sequence;

public final class CharAdapter
extends AbstractTypeAdapter {
    public static final CharAdapter INSTANCE = new CharAdapter();

    private CharAdapter() {
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public boolean probe(DirectUtf8Sequence text) {
        if (text != null && text.size() == 1) {
            return Character.isLetter(text.byteAt(0));
        }
        return false;
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectUtf8Sequence value) {
        row.putChar(column, SqlKeywords.isNullKeyword(value) ? (char)'\u0000' : (char)value.byteAt(0));
    }
}

