/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.cairo.ColumnType;
import io.questdb.std.IntList;
import io.questdb.std.IntShortHashMap;
import io.questdb.std.Numbers;

public class PGOids {
    public static final int BINARY_TYPE_ARRAY = -2147483621;
    public static final int BINARY_TYPE_ARRAY_STRING = -2147483618;
    public static final int BINARY_TYPE_BINARY = -2147483630;
    public static final int BINARY_TYPE_BOOLEAN = -2147483647;
    public static final int BINARY_TYPE_BYTE = -2147483646;
    public static final int BINARY_TYPE_CHAR = -2147483644;
    public static final int BINARY_TYPE_DATE = -2147483641;
    public static final int BINARY_TYPE_DOUBLE = -2147483638;
    public static final int BINARY_TYPE_FLOAT = -2147483639;
    public static final int BINARY_TYPE_INT = -2147483643;
    public static final int BINARY_TYPE_INTERVAL = -2147483616;
    public static final int BINARY_TYPE_LONG = -2147483642;
    public static final int BINARY_TYPE_LONG256 = -2147483635;
    public static final int BINARY_TYPE_SHORT = -2147483645;
    public static final int BINARY_TYPE_STRING = -2147483637;
    public static final int BINARY_TYPE_SYMBOL = -2147483636;
    public static final int BINARY_TYPE_TIMESTAMP = -2147483640;
    public static final int BINARY_TYPE_UUID = -2147483629;
    public static final int BINARY_TYPE_VARCHAR = -2147483622;
    public static final int PG_ARR_FLOAT8 = 1022;
    public static final int PG_ARR_INT8 = 1016;
    public static final int PG_BOOL = 16;
    public static final int PG_BYTEA = 17;
    public static final int PG_CATALOG_OID = 11;
    public static final int PG_CHAR = 1042;
    public static final int PG_CLASS_OID = 1259;
    public static final int PG_DATE = 1082;
    public static final int PG_FLOAT4 = 700;
    public static final int PG_FLOAT8 = 701;
    public static final int PG_INT2 = 21;
    public static final int PG_INT4 = 23;
    public static final int PG_INT8 = 20;
    public static final int PG_INTERNAL = 2281;
    public static final int PG_NAMESPACE_OID = 2615;
    public static final int PG_OID = 26;
    public static final int PG_PUBLIC_OID = 2200;
    public static final int PG_TIMESTAMP = 1114;
    public static final int PG_TIMESTAMP_TZ = 1184;
    public static final IntList PG_TYPE_OIDS = new IntList();
    public static final IntList PG_TYPE_PROC_OIDS = new IntList();
    public static final char[] PG_TYPE_TO_CATEGORY = new char[15];
    public static final CharSequence[] PG_TYPE_TO_DEFAULT = new CharSequence[15];
    public static final short[] PG_TYPE_TO_LENGTH = new short[15];
    public static final CharSequence[] PG_TYPE_TO_NAME = new CharSequence[15];
    public static final CharSequence[] PG_TYPE_TO_PROC_NAME = new CharSequence[15];
    public static final CharSequence[] PG_TYPE_TO_PROC_SRC = new CharSequence[15];
    public static final IntShortHashMap PG_TYPE_TO_SIZE_MAP = new IntShortHashMap();
    public static final int PG_UNSPECIFIED = 0;
    public static final int PG_UUID = 2950;
    public static final int PG_VARCHAR = 1043;
    public static final int PG_VOID = 2278;
    public static final int X_PG_ARR_FLOAT8 = -33357824;
    public static final int X_B_PG_ARR_FLOAT8 = -33357823;
    public static final int X_PG_ARR_INT8 = -134021120;
    public static final int X_X_PG_ARR_INT8 = -134021119;
    public static final int X_PG_BOOL = 0x10000000;
    public static final int X_B_PG_BOOL = 0x10000001;
    public static final int X_PG_BYTEA = 0x11000000;
    public static final int X_B_PG_BYTEA = 0x11000001;
    public static final int X_PG_CHAR = 302252032;
    public static final int X_B_PG_CHAR = 302252033;
    public static final int X_PG_DATE = 973340672;
    public static final int X_B_PG_DATE = 973340673;
    public static final int X_PG_FLOAT4 = -1140719616;
    public static final int X_B_PG_FLOAT4 = -1140719615;
    public static final int X_PG_FLOAT8 = -1123942400;
    public static final int X_B_PG_FLOAT8 = -1123942399;
    public static final int X_PG_INT2 = 0x15000000;
    public static final int X_B_PG_INT2 = 0x15000001;
    public static final int X_PG_INT4 = 0x17000000;
    public static final int X_B_PG_INT4 = 0x17000001;
    public static final int X_PG_INT8 = 0x14000000;
    public static final int X_B_PG_INT8 = 0x14000001;
    public static final int X_PG_TIMESTAMP = 1510211584;
    public static final int X_B_PG_TIMESTAMP = 1510211585;
    public static final int X_PG_TIMESTAMP_TZ = -1610350592;
    public static final IntShortHashMap X_PG_TYPE_TO_SIZE_MAP = new IntShortHashMap();
    public static final int X_PG_UUID = -2046099456;
    public static final int X_B_PG_UUID = -2046099455;
    public static final int X_PG_VOID = -435683328;
    private static final int CHAR_ATT_TYP_MOD = 5;
    private static final IntList TYPE_ARR_OIDS = new IntList();
    private static final IntList TYPE_OIDS = new IntList();
    private static final int X_CHAR_ATT_TYP_MOD = Numbers.bswap(5);

    public static int getAttTypMod(int pgOidType) {
        if (pgOidType == 1042) {
            return 5;
        }
        return -1;
    }

    public static short getColumnBinaryFlag(int type) {
        return (short)(type >>> 31 & 0xFF);
    }

    public static int getTypeOid(int type) {
        if (!ColumnType.isArray(type)) {
            return TYPE_OIDS.getQuick(ColumnType.tagOf(type));
        }
        short elType = ColumnType.decodeArrayElementType(type);
        return TYPE_ARR_OIDS.getQuick(elType);
    }

    public static int getXAttTypMod(int pgOidType) {
        if (pgOidType == 1042) {
            return X_CHAR_ATT_TYP_MOD;
        }
        return -1;
    }

    public static int pgArrayToElementType(int pgOid) {
        switch (pgOid) {
            case 1022: {
                return 701;
            }
            case 1016: {
                return 20;
            }
        }
        return 0;
    }

    public static int pgToArrayOid(int pgOid) {
        switch (pgOid) {
            case 701: {
                return 1022;
            }
        }
        return 0;
    }

    public static int toColumnBinaryType(short code, int type) {
        return code << 31 | type;
    }

    public static int toColumnType(int type) {
        return type & Integer.MAX_VALUE;
    }

    public static int toParamBinaryType(short code, int type) {
        return code | type;
    }

    public static int toParamType(int type) {
        return type & 0xFFFFFFFE;
    }

    static {
        TYPE_OIDS.extendAndSet(11, 1043);
        TYPE_OIDS.extendAndSet(8, 1114);
        TYPE_OIDS.extendAndSet(10, 701);
        TYPE_OIDS.extendAndSet(9, 700);
        TYPE_OIDS.extendAndSet(5, 23);
        TYPE_OIDS.extendAndSet(3, 21);
        TYPE_OIDS.extendAndSet(4, 1042);
        TYPE_OIDS.extendAndSet(12, 1043);
        TYPE_OIDS.extendAndSet(6, 20);
        TYPE_OIDS.extendAndSet(2, 21);
        TYPE_OIDS.extendAndSet(1, 16);
        TYPE_OIDS.extendAndSet(7, 1114);
        TYPE_OIDS.extendAndSet(18, 17);
        TYPE_OIDS.extendAndSet(13, 1043);
        TYPE_OIDS.extendAndSet(14, 1043);
        TYPE_OIDS.extendAndSet(15, 1043);
        TYPE_OIDS.extendAndSet(16, 1043);
        TYPE_OIDS.extendAndSet(17, 1043);
        TYPE_OIDS.extendAndSet(19, 2950);
        TYPE_OIDS.extendAndSet(25, 1043);
        TYPE_OIDS.extendAndSet(26, 1043);
        TYPE_OIDS.extendAndSet(32, 1043);
        TYPE_OIDS.extendAndSet(30, 1043);
        TYPE_ARR_OIDS.extendAndSet(10, 1022);
        TYPE_ARR_OIDS.extendAndSet(6, 1016);
        PG_TYPE_OIDS.add(1043);
        PG_TYPE_OIDS.add(1114);
        PG_TYPE_OIDS.add(701);
        PG_TYPE_OIDS.add(700);
        PG_TYPE_OIDS.add(23);
        PG_TYPE_OIDS.add(21);
        PG_TYPE_OIDS.add(1042);
        PG_TYPE_OIDS.add(20);
        PG_TYPE_OIDS.add(16);
        PG_TYPE_OIDS.add(17);
        PG_TYPE_OIDS.add(1082);
        PG_TYPE_OIDS.add(2950);
        PG_TYPE_OIDS.add(2281);
        PG_TYPE_OIDS.add(26);
        PG_TYPE_OIDS.add(1022);
        PG_TYPE_PROC_OIDS.add(2432);
        PG_TYPE_PROC_OIDS.add(2474);
        PG_TYPE_PROC_OIDS.add(2426);
        PG_TYPE_PROC_OIDS.add(2424);
        PG_TYPE_PROC_OIDS.add(2406);
        PG_TYPE_PROC_OIDS.add(2404);
        PG_TYPE_PROC_OIDS.add(2434);
        PG_TYPE_PROC_OIDS.add(2408);
        PG_TYPE_PROC_OIDS.add(2436);
        PG_TYPE_PROC_OIDS.add(2412);
        PG_TYPE_PROC_OIDS.add(2568);
        PG_TYPE_PROC_OIDS.add(2961);
        PG_TYPE_PROC_OIDS.add(0);
        PG_TYPE_PROC_OIDS.add(2418);
        PG_TYPE_PROC_OIDS.add(2400);
        PG_TYPE_TO_SIZE_MAP.put(701, (short)8);
        PG_TYPE_TO_SIZE_MAP.put(700, (short)4);
        PG_TYPE_TO_SIZE_MAP.put(23, (short)4);
        PG_TYPE_TO_SIZE_MAP.put(21, (short)2);
        PG_TYPE_TO_SIZE_MAP.put(20, (short)8);
        PG_TYPE_TO_SIZE_MAP.put(16, (short)1);
        PG_TYPE_TO_SIZE_MAP.put(1114, (short)8);
        PG_TYPE_TO_SIZE_MAP.put(2950, (short)16);
        PG_TYPE_TO_SIZE_MAP.put(1114, (short)8);
        PG_TYPE_TO_SIZE_MAP.put(1184, (short)8);
        PG_TYPE_TO_SIZE_MAP.put(1082, (short)8);
        X_PG_TYPE_TO_SIZE_MAP.put(701, Numbers.bswap((short)8));
        X_PG_TYPE_TO_SIZE_MAP.put(700, Numbers.bswap((short)4));
        X_PG_TYPE_TO_SIZE_MAP.put(23, Numbers.bswap((short)4));
        X_PG_TYPE_TO_SIZE_MAP.put(21, Numbers.bswap((short)2));
        X_PG_TYPE_TO_SIZE_MAP.put(20, Numbers.bswap((short)8));
        X_PG_TYPE_TO_SIZE_MAP.put(16, Numbers.bswap((short)1));
        X_PG_TYPE_TO_SIZE_MAP.put(2950, Numbers.bswap((short)16));
        X_PG_TYPE_TO_SIZE_MAP.put(1114, Numbers.bswap((short)8));
        X_PG_TYPE_TO_SIZE_MAP.put(1184, Numbers.bswap((short)8));
        X_PG_TYPE_TO_SIZE_MAP.put(1082, Numbers.bswap((short)8));
        PGOids.PG_TYPE_TO_NAME[0] = "varchar";
        PGOids.PG_TYPE_TO_NAME[1] = "timestamp";
        PGOids.PG_TYPE_TO_NAME[2] = "float8";
        PGOids.PG_TYPE_TO_NAME[3] = "float4";
        PGOids.PG_TYPE_TO_NAME[4] = "int4";
        PGOids.PG_TYPE_TO_NAME[5] = "int2";
        PGOids.PG_TYPE_TO_NAME[6] = "bpchar";
        PGOids.PG_TYPE_TO_NAME[7] = "int8";
        PGOids.PG_TYPE_TO_NAME[8] = "bool";
        PGOids.PG_TYPE_TO_NAME[9] = "binary";
        PGOids.PG_TYPE_TO_NAME[10] = "date";
        PGOids.PG_TYPE_TO_NAME[11] = "uuid";
        PGOids.PG_TYPE_TO_NAME[12] = "internal";
        PGOids.PG_TYPE_TO_NAME[13] = "oid";
        PGOids.PG_TYPE_TO_NAME[14] = "_float8";
        int n = PG_TYPE_TO_NAME.length;
        for (int i = 0; i < n; ++i) {
            boolean isArr;
            int pgOid = PG_TYPE_OIDS.getQuick(i);
            boolean bl = isArr = PGOids.pgArrayToElementType(pgOid) != 0;
            if (!isArr) {
                PGOids.PG_TYPE_TO_PROC_NAME[i] = String.valueOf(PG_TYPE_TO_NAME[i]) + "_recv";
                PGOids.PG_TYPE_TO_PROC_SRC[i] = String.valueOf(PG_TYPE_TO_NAME[i]) + "recv";
                continue;
            }
            PGOids.PG_TYPE_TO_PROC_NAME[i] = "array_recv";
            PGOids.PG_TYPE_TO_PROC_SRC[i] = "array_recv";
        }
        PGOids.PG_TYPE_TO_CATEGORY[0] = 83;
        PGOids.PG_TYPE_TO_CATEGORY[1] = 68;
        PGOids.PG_TYPE_TO_CATEGORY[2] = 78;
        PGOids.PG_TYPE_TO_CATEGORY[3] = 78;
        PGOids.PG_TYPE_TO_CATEGORY[4] = 78;
        PGOids.PG_TYPE_TO_CATEGORY[5] = 78;
        PGOids.PG_TYPE_TO_CATEGORY[6] = 90;
        PGOids.PG_TYPE_TO_CATEGORY[7] = 78;
        PGOids.PG_TYPE_TO_CATEGORY[8] = 66;
        PGOids.PG_TYPE_TO_CATEGORY[9] = 85;
        PGOids.PG_TYPE_TO_CATEGORY[10] = 68;
        PGOids.PG_TYPE_TO_CATEGORY[11] = 85;
        PGOids.PG_TYPE_TO_CATEGORY[12] = 80;
        PGOids.PG_TYPE_TO_CATEGORY[13] = 78;
        PGOids.PG_TYPE_TO_CATEGORY[14] = 65;
        PGOids.PG_TYPE_TO_LENGTH[0] = -1;
        PGOids.PG_TYPE_TO_LENGTH[1] = 8;
        PGOids.PG_TYPE_TO_LENGTH[2] = 8;
        PGOids.PG_TYPE_TO_LENGTH[3] = 4;
        PGOids.PG_TYPE_TO_LENGTH[4] = 4;
        PGOids.PG_TYPE_TO_LENGTH[5] = 2;
        PGOids.PG_TYPE_TO_LENGTH[6] = 2;
        PGOids.PG_TYPE_TO_LENGTH[7] = 8;
        PGOids.PG_TYPE_TO_LENGTH[8] = 1;
        PGOids.PG_TYPE_TO_LENGTH[9] = -1;
        PGOids.PG_TYPE_TO_LENGTH[10] = 8;
        PGOids.PG_TYPE_TO_LENGTH[11] = 16;
        PGOids.PG_TYPE_TO_LENGTH[12] = 8;
        PGOids.PG_TYPE_TO_LENGTH[13] = 4;
        PGOids.PG_TYPE_TO_LENGTH[14] = -1;
        PGOids.PG_TYPE_TO_DEFAULT[0] = null;
        PGOids.PG_TYPE_TO_DEFAULT[1] = null;
        PGOids.PG_TYPE_TO_DEFAULT[2] = null;
        PGOids.PG_TYPE_TO_DEFAULT[3] = null;
        PGOids.PG_TYPE_TO_DEFAULT[4] = null;
        PGOids.PG_TYPE_TO_DEFAULT[5] = "0";
        PGOids.PG_TYPE_TO_DEFAULT[6] = "0";
        PGOids.PG_TYPE_TO_DEFAULT[7] = null;
        PGOids.PG_TYPE_TO_DEFAULT[8] = "false";
        PGOids.PG_TYPE_TO_DEFAULT[9] = null;
        PGOids.PG_TYPE_TO_DEFAULT[10] = null;
        PGOids.PG_TYPE_TO_DEFAULT[11] = null;
        PGOids.PG_TYPE_TO_DEFAULT[12] = null;
        PGOids.PG_TYPE_TO_DEFAULT[13] = null;
        PGOids.PG_TYPE_TO_DEFAULT[14] = null;
    }
}

