/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.NetworkSqlExecutionCircuitBreaker;
import io.questdb.cutlass.pgwire.PGCircuitBreakerRegistry;
import io.questdb.cutlass.pgwire.PGConfiguration;
import io.questdb.mp.SimpleSpinLock;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public final class DefaultPGCircuitBreakerRegistry
implements PGCircuitBreakerRegistry {
    private final ObjList<NetworkSqlExecutionCircuitBreaker> circuitBreakers;
    private final IntList freeIdx;
    private final SimpleSpinLock lock = new SimpleSpinLock();
    private final Rnd random;
    private volatile boolean closed = false;

    public DefaultPGCircuitBreakerRegistry(PGConfiguration configuration, CairoConfiguration cairoConfig) {
        int limit = configuration.getLimit();
        this.circuitBreakers = new ObjList(limit);
        this.freeIdx = new IntList(limit);
        this.random = configuration.getRandom() != null ? new Rnd(configuration.getRandom().getSeed0(), configuration.getRandom().getSeed1()) : new Rnd(cairoConfig.getNanosecondClock().getTicks(), cairoConfig.getMicrosecondClock().getTicks());
        for (int i = 0; i < limit; ++i) {
            this.circuitBreakers.add(null);
            this.freeIdx.add(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(NetworkSqlExecutionCircuitBreaker cb) {
        int idx;
        if (this.closed) {
            return -1;
        }
        this.lock.lock();
        try {
            int size = this.freeIdx.size();
            if (size > 0) {
                idx = this.freeIdx.getQuick(size - 1);
                this.freeIdx.setPos(size - 1);
                this.circuitBreakers.setQuick(idx, cb);
            } else {
                idx = this.circuitBreakers.size();
                this.circuitBreakers.add(cb);
            }
        }
        finally {
            this.lock.unlock();
        }
        return idx;
    }

    @Override
    public void cancel(int circuitBreakerIdx, int secret) {
        if (this.circuitBreakers.size() < circuitBreakerIdx || circuitBreakerIdx < 0) {
            throw CairoException.nonCritical().put("wrong circuit breaker idx [idx=").put(circuitBreakerIdx).put("]");
        }
        NetworkSqlExecutionCircuitBreaker cb = this.circuitBreakers.getQuick(circuitBreakerIdx);
        if (cb == null) {
            throw CairoException.nonCritical().put("empty circuit breaker slot [idx=").put(circuitBreakerIdx).put("]");
        }
        if (cb.getSecret() != secret) {
            throw CairoException.nonCritical().put("wrong circuit breaker secret [idx=").put(circuitBreakerIdx).put("]");
        }
        cb.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.lock.lock();
        this.closed = true;
        try {
            int n = this.circuitBreakers.size();
            for (int i = 0; i < n; ++i) {
                NetworkSqlExecutionCircuitBreaker cb = this.circuitBreakers.getQuick(i);
                if (cb == null) continue;
                cb.cancel();
                this.circuitBreakers.setQuick(i, null);
            }
            this.freeIdx.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getNewSecret() {
        return this.random.nextInt();
    }

    @Override
    public void remove(int contextId) {
        this.lock.lock();
        try {
            if (!this.closed) {
                this.circuitBreakers.setQuick(contextId, null);
                this.freeIdx.add(contextId);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

