/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.line.tcp.LineTcpConnectionContext;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementScheduler;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.mp.WorkerPool;
import io.questdb.network.IOContextFactoryImpl;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatchers;
import io.questdb.std.Misc;
import io.questdb.std.ObjectFactory;
import java.io.Closeable;

public class LineTcpReceiver
implements Closeable {
    private final IODispatcher<LineTcpConnectionContext> dispatcher;
    private LineTcpMeasurementScheduler scheduler;

    public LineTcpReceiver(LineTcpReceiverConfiguration configuration, CairoEngine engine, WorkerPool networkSharedPool, WorkerPool writerWorkerPool) {
        try {
            this.scheduler = null;
            ObjectFactory<LineTcpConnectionContext> factory = () -> new LineTcpConnectionContext(configuration, this.scheduler);
            IOContextFactoryImpl<LineTcpConnectionContext> contextFactory = new IOContextFactoryImpl<LineTcpConnectionContext>(factory, configuration.getConnectionPoolInitialCapacity());
            this.dispatcher = IODispatchers.create(configuration, contextFactory);
            networkSharedPool.assign(this.dispatcher);
            this.scheduler = new LineTcpMeasurementScheduler(configuration, engine, networkSharedPool, this.dispatcher, writerWorkerPool);
            int n = networkSharedPool.getWorkerCount();
            for (int i = 0; i < n; ++i) {
                networkSharedPool.assignThreadLocalCleaner(i, contextFactory::freeThreadLocal);
            }
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    @Override
    public void close() {
        Misc.free(this.scheduler);
        Misc.free(this.dispatcher);
    }
}

