/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class AdaptiveRecvBuffer
implements QuietCloseable {
    private static final Log LOG = LogFactory.getLog(AdaptiveRecvBuffer.class);
    private static final byte RECV_BUFFER_GROW_FACTOR = 4;
    private static final byte RECV_BUFFER_SHRINK_FACTOR = 2;
    private final int memoryTag;
    private final LineTcpParser parser;
    private long bufEnd;
    private long bufPos;
    private long bufStart;
    private long bufStartOfMeasurement;
    private long currentBufSize;
    private boolean decrease = false;
    private long initialBufSize;
    private long maxBufSize;
    private long maxRecordMeasureSize;

    public AdaptiveRecvBuffer(LineTcpParser parser, int tag) {
        this.parser = parser;
        this.memoryTag = tag;
    }

    public void clear() {
        this.parser.of(this.bufStart);
        this.bufPos = this.bufStart;
        this.bufStartOfMeasurement = this.bufStart;
    }

    @Override
    public void close() {
        this.decrease = false;
        Unsafe.free(this.bufStart, this.currentBufSize, this.memoryTag);
        this.bufStart = 0L;
        this.bufPos = 0L;
        this.bufEnd = 0L;
        this.bufStartOfMeasurement = 0L;
        this.parser.of(this.bufStart);
    }

    public long copyToLocalBuffer(long lo, long hi) {
        long copyLen = Math.min(hi - lo, this.bufEnd - this.bufPos);
        assert (copyLen > 0L);
        Vect.memcpy(this.bufPos, lo, copyLen);
        this.bufPos += copyLen;
        return lo + copyLen;
    }

    public long getBufEnd() {
        return this.bufEnd;
    }

    public long getBufPos() {
        return this.bufPos;
    }

    public long getBufStart() {
        return this.bufStart;
    }

    public long getBufStartOfMeasurement() {
        return this.bufStartOfMeasurement;
    }

    public long getMaxBufSize() {
        return this.maxBufSize;
    }

    public AdaptiveRecvBuffer of(long initialBufSize, long maxBufferSize) {
        assert (this.bufStart == 0L);
        this.initialBufSize = initialBufSize;
        this.maxBufSize = maxBufferSize;
        this.bufPos = this.bufStart = Unsafe.malloc(initialBufSize, this.memoryTag);
        this.bufStartOfMeasurement = this.bufStart;
        this.bufEnd = this.bufPos + initialBufSize;
        this.currentBufSize = initialBufSize;
        this.parser.of(this.bufStart);
        return this;
    }

    public void recordMaxMeasureSize(long maxBufferSize) {
        if (this.maxRecordMeasureSize < maxBufferSize || maxBufferSize == 0L) {
            this.maxRecordMeasureSize = maxBufferSize;
        }
    }

    public void setBufPos(long bufPos) {
        this.bufPos = bufPos;
    }

    public void setBufStartOfMeasurement(long bufStartOfMeasurement) {
        this.bufStartOfMeasurement = bufStartOfMeasurement;
    }

    public void startNewMeasurement() {
        this.recordMaxMeasureSize(this.parser.getBufferAddress() - this.bufStartOfMeasurement);
        this.parser.startNextMeasurement();
        this.bufStartOfMeasurement = this.parser.getBufferAddress();
        if (this.bufStartOfMeasurement == this.bufPos) {
            this.tryToShrinkRecvBuffer(false);
            this.bufPos = this.bufStart;
            this.parser.of(this.bufStart);
            this.bufStartOfMeasurement = this.bufStart;
        }
    }

    public boolean tryCompactOrGrowBuffer() {
        if (this.bufPos != this.bufEnd) {
            return true;
        }
        if (this.bufStartOfMeasurement > this.bufStart) {
            long size = this.bufPos - this.bufStartOfMeasurement;
            long shl = this.bufStartOfMeasurement - this.bufStart;
            Vect.memmove(this.bufStart, this.bufStart + shl, size);
            this.parser.shl(shl);
            this.bufPos -= shl;
            this.bufStartOfMeasurement -= shl;
            this.recordMaxMeasureSize(size);
            this.tryToShrinkRecvBuffer(true);
            return true;
        }
        if (this.currentBufSize == this.maxBufSize) {
            return false;
        }
        this.adjustBuffer(Math.min(this.currentBufSize * 4L, this.maxBufSize), true);
        this.decrease = false;
        return true;
    }

    public void tryToShrinkRecvBuffer(boolean shiftParser) {
        if (this.maxRecordMeasureSize == 0L) {
            return;
        }
        if (this.currentBufSize != this.initialBufSize && this.maxRecordMeasureSize < this.currentBufSize / 2L) {
            if (this.decrease) {
                this.adjustBuffer(Math.max(this.initialBufSize, this.currentBufSize / 2L), shiftParser);
                this.decrease = false;
            } else {
                this.decrease = true;
            }
        } else {
            this.decrease = false;
        }
        this.recordMaxMeasureSize(0L);
    }

    private void adjustBuffer(long newBufSize, boolean needShift) {
        LOG.info().$("adjust ILP receive buffer size [currentSize=").$(this.currentBufSize).$(", newBufferSize=").$(newBufSize).I$();
        long newBufLo = Unsafe.realloc(this.bufStart, this.currentBufSize, newBufSize, this.memoryTag);
        long offset = this.bufStart - newBufLo;
        if (needShift) {
            this.parser.shl(offset);
        }
        this.bufStart = newBufLo;
        this.bufPos -= offset;
        this.bufStartOfMeasurement = this.bufStart;
        this.bufEnd = this.bufStart + newBufSize;
        this.currentBufSize = newBufSize;
    }
}

