/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.http;

import io.questdb.BuildInformationHolder;
import io.questdb.ClientTlsConfiguration;
import io.questdb.HttpClientConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.client.Sender;
import io.questdb.cutlass.http.HttpConstants;
import io.questdb.cutlass.http.HttpKeywords;
import io.questdb.cutlass.http.client.Fragment;
import io.questdb.cutlass.http.client.HttpClient;
import io.questdb.cutlass.http.client.HttpClientException;
import io.questdb.cutlass.http.client.HttpClientFactory;
import io.questdb.cutlass.http.client.Response;
import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.json.JsonLexer;
import io.questdb.cutlass.json.JsonParser;
import io.questdb.cutlass.line.LineSenderException;
import io.questdb.cutlass.line.http.LineHttpSenderV1;
import io.questdb.cutlass.line.http.LineHttpSenderV2;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.NanosecondClockImpl;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Os;
import io.questdb.std.Rnd;
import io.questdb.std.bytes.DirectByteSlice;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public abstract class AbstractLineHttpSender
implements Sender {
    private static final String PATH = "/write?precision=n";
    private static final int RETRY_BACKOFF_MULTIPLIER = 2;
    private static final int RETRY_INITIAL_BACKOFF_MS = 10;
    private static final int RETRY_MAX_BACKOFF_MS = 1000;
    private static final int RETRY_MAX_JITTER_MS = 10;
    private final String authToken;
    private final int autoFlushRows;
    private final int baseTimeoutMillis;
    private final DirectByteSlice bufferView = new DirectByteSlice();
    private final long flushIntervalNanos;
    private final String host;
    private final int maxNameLength;
    private final long maxRetriesNanos;
    private final long minRequestThroughput;
    private final String password;
    private final String path;
    private final int port;
    private final CharSequence questDBVersion;
    private final Rnd rnd = new Rnd(NanosecondClockImpl.INSTANCE.getTicks(), MicrosecondClockImpl.INSTANCE.getTicks());
    private final StringSink sink = new StringSink();
    private final String url;
    private final String username;
    protected HttpClient.Request request;
    private HttpClient client;
    private boolean closed;
    private long flushAfterNanos = Long.MAX_VALUE;
    private JsonErrorParser jsonErrorParser;
    private long pendingRows;
    private int rowBookmark;
    private RequestState state = RequestState.EMPTY;

    protected AbstractLineHttpSender(String host, int port, HttpClientConfiguration clientConfiguration, ClientTlsConfiguration tlsConfig, int autoFlushRows, String authToken, String username, String password, int maxNameLength, long maxRetriesNanos, long minRequestThroughput, long flushIntervalNanos) {
        this(host, port, PATH, clientConfiguration, tlsConfig, null, autoFlushRows, authToken, username, password, maxNameLength, maxRetriesNanos, minRequestThroughput, flushIntervalNanos);
    }

    protected AbstractLineHttpSender(String host, int port, String path, HttpClientConfiguration clientConfiguration, ClientTlsConfiguration tlsConfig, HttpClient client, int autoFlushRows, String authToken, String username, String password, int maxNameLength, long maxRetriesNanos, long minRequestThroughput, long flushIntervalNanos) {
        assert (authToken == null || username == null && password == null);
        this.maxRetriesNanos = maxRetriesNanos;
        this.host = host;
        this.port = port;
        this.path = path != null ? path : PATH;
        this.autoFlushRows = autoFlushRows;
        this.authToken = authToken;
        this.username = username;
        this.password = password;
        this.minRequestThroughput = minRequestThroughput;
        this.flushIntervalNanos = flushIntervalNanos;
        this.baseTimeoutMillis = clientConfiguration.getTimeout();
        if (tlsConfig != null) {
            this.client = client == null ? HttpClientFactory.newTlsInstance(clientConfiguration, tlsConfig) : client;
            this.url = "https://" + host + ":" + port + this.path;
        } else {
            this.client = client == null ? HttpClientFactory.newPlainTextInstance(clientConfiguration) : client;
            this.url = "http://" + host + ":" + port + this.path;
        }
        this.questDBVersion = new BuildInformationHolder().getSwVersion();
        this.request = this.newRequest();
        this.maxNameLength = maxNameLength;
    }

    public static AbstractLineHttpSender createLineSender(String host, int port, String path, HttpClientConfiguration clientConfiguration, ClientTlsConfiguration tlsConfig, int autoFlushRows, String authToken, String username, String password, int maxNameLength, long maxRetriesNanos, long minRequestThroughput, long flushIntervalNanos, int protocolVersion) {
        HttpClient cli;
        block13: {
            cli = null;
            if (protocolVersion == -1) {
                cli = tlsConfig != null ? HttpClientFactory.newTlsInstance(clientConfiguration, tlsConfig) : HttpClientFactory.newPlainTextInstance(clientConfiguration);
                try {
                    HttpClient.Request req = cli.newRequest(host, port).GET();
                    HttpClient.ResponseHeaders response = req.url(clientConfiguration.getSettingsPath()).send();
                    response.await();
                    DirectUtf8Sequence statusCode = response.getStatusCode();
                    if (Utf8s.equalsNcAscii("200", statusCode)) {
                        try (JsonSettingsParser parser = new JsonSettingsParser();){
                            parser.parse(response.getResponse());
                            protocolVersion = parser.getDefaultProtocolVersion();
                            if (parser.getMaxNameLen() != 0) {
                                maxNameLength = parser.getMaxNameLen();
                            }
                            break block13;
                        }
                    }
                    if (Utf8s.equalsNcAscii("404", statusCode)) {
                        protocolVersion = 1;
                        break block13;
                    }
                    StringSink sink = new StringSink();
                    AbstractLineHttpSender.chunkedResponseToSink(response, sink);
                    throw new LineSenderException((CharSequence)"Failed to detect server line protocol version [http-status=").put(statusCode).put(", http-message=").put(sink).put(']');
                }
                catch (LineSenderException e) {
                    Misc.free(cli);
                    throw e;
                }
                catch (Throwable e) {
                    Misc.free(cli);
                    throw new LineSenderException("Failed to detect server line protocol version", e);
                }
            }
        }
        if (protocolVersion == 1) {
            return new LineHttpSenderV1(host, port, path, clientConfiguration, tlsConfig, cli, autoFlushRows, authToken, username, password, maxNameLength, maxRetriesNanos, minRequestThroughput, flushIntervalNanos);
        }
        return new LineHttpSenderV2(host, port, path, clientConfiguration, tlsConfig, cli, autoFlushRows, authToken, username, password, maxNameLength, maxRetriesNanos, minRequestThroughput, flushIntervalNanos);
    }

    @Override
    public void at(long timestamp, ChronoUnit unit) {
        ((Utf8Sink)this.request.putAscii(' ').put(Timestamps.toMicros(timestamp, unit))).put('t');
        this.atNow();
    }

    @Override
    public void at(Instant timestamp) {
        long micros = timestamp.getEpochSecond() * 1000000L + (long)(timestamp.getNano() / 1000);
        ((Utf8Sink)this.request.putAscii(' ').put(micros)).put('t');
        this.atNow();
    }

    @Override
    public void atNow() {
        switch (this.state) {
            case EMPTY: {
                throw new LineSenderException((CharSequence)"no table name was provided");
            }
            case TABLE_NAME_SET: {
                throw new LineSenderException((CharSequence)"no symbols or columns were provided");
            }
            case ADDING_SYMBOLS: 
            case ADDING_COLUMNS: {
                this.request.put('\n');
                this.state = RequestState.EMPTY;
            }
        }
        if (this.rowAdded()) {
            this.flush();
        }
    }

    @Override
    public Sender boolColumn(CharSequence name, boolean value) {
        this.writeFieldName(name);
        this.request.put(value ? (char)'t' : 'f');
        return this;
    }

    @Override
    public DirectByteSlice bufferView() {
        return this.bufferView.of(this.request.getContentStart(), this.request.getContentLength());
    }

    @Override
    public void cancelRow() {
        this.validateNotClosed();
        this.request.trimContentToLen(this.rowBookmark);
        this.state = RequestState.EMPTY;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            if (this.autoFlushRows != 0 || this.flushIntervalNanos != Long.MAX_VALUE) {
                this.flush0(true);
            }
        }
        finally {
            Misc.free(this.jsonErrorParser);
            this.closed = true;
            this.client = Misc.free(this.client);
        }
    }

    @Override
    public void flush() {
        this.flush0(false);
    }

    @Override
    public Sender longColumn(CharSequence name, long value) {
        this.writeFieldName(name);
        this.request.put(value);
        this.request.put('i');
        return this;
    }

    public void putRawMessage(CharSequence msg) {
        this.request.put(msg);
        this.state = RequestState.EMPTY;
        if (this.rowAdded()) {
            this.flush();
        }
    }

    @Override
    public Sender stringColumn(CharSequence name, CharSequence value) {
        this.writeFieldName(name);
        this.request.put('\"');
        this.escapeString(value);
        this.request.put('\"');
        return this;
    }

    @Override
    public Sender symbol(CharSequence name, CharSequence value) {
        switch (this.state) {
            case EMPTY: {
                throw new LineSenderException((CharSequence)"table name must be set first");
            }
            case ADDING_COLUMNS: {
                throw new LineSenderException((CharSequence)"symbols must be written before any other column types");
            }
            case TABLE_NAME_SET: {
                this.state = RequestState.ADDING_SYMBOLS;
            }
            case ADDING_SYMBOLS: {
                this.validateColumnName(name);
                this.request.putAscii(',');
                this.escapeQuotedString(name);
                this.request.putAscii('=');
                this.escapeQuotedString(value);
                this.state = RequestState.ADDING_SYMBOLS;
                break;
            }
            default: {
                throw new LineSenderException((CharSequence)"unexpected state: ").put(this.state.name());
            }
        }
        return this;
    }

    @Override
    public Sender table(CharSequence table) {
        assert (this.request != null);
        this.validateNotClosed();
        this.validateTableName(table);
        if (this.state != RequestState.EMPTY) {
            throw new LineSenderException((CharSequence)"duplicated table. call sender.at() or sender.atNow() to finish the current row first");
        }
        if (table.length() == 0) {
            throw new LineSenderException((CharSequence)"table name cannot be empty");
        }
        this.rowBookmark = this.request.getContentLength();
        this.state = RequestState.TABLE_NAME_SET;
        this.escapeQuotedString(table);
        return this;
    }

    @Override
    public Sender timestampColumn(CharSequence name, long value, ChronoUnit unit) {
        ((Utf8Sink)this.writeFieldName(name).put(Timestamps.toMicros(value, unit))).put('t');
        return this;
    }

    @Override
    public Sender timestampColumn(CharSequence name, Instant value) {
        ((Utf8Sink)this.writeFieldName(name).put(value.getEpochSecond() * 1000000L + (long)value.getNano() / 1000L)).put('t');
        return this;
    }

    private static void chunkedResponseToSink(HttpClient.ResponseHeaders response, StringSink sink) {
        Fragment fragment;
        if (!response.isChunked()) {
            return;
        }
        Response chunkedRsp = response.getResponse();
        while ((fragment = chunkedRsp.recv()) != null) {
            sink.putNonAscii(fragment.lo(), fragment.hi());
        }
    }

    private static boolean isSuccessResponse(DirectUtf8Sequence statusCode) {
        return statusCode != null && statusCode.size() == 3 && statusCode.byteAt(0) == 50;
    }

    private static boolean keepAliveDisabled(HttpClient.ResponseHeaders response) {
        DirectUtf8Sequence connectionHeader = response.getHeader(HttpConstants.HEADER_CONNECTION);
        return HttpKeywords.isClose(connectionHeader);
    }

    private int backoff(int retryBackoff) {
        int jitter = this.rnd.nextInt(10);
        int backoff = retryBackoff + jitter;
        Os.sleep(backoff);
        return Math.min(1000, backoff * 2);
    }

    private void consumeChunkedResponse(HttpClient.ResponseHeaders response) {
        if (!response.isChunked()) {
            return;
        }
        Response chunkedRsp = response.getResponse();
        while (chunkedRsp.recv() != null) {
        }
    }

    private void escapeString(CharSequence value) {
        int n = value.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': 
                case '\"': 
                case '\\': {
                    this.request.put((byte)92).put((byte)c);
                    continue block3;
                }
                default: {
                    this.request.put(c);
                }
            }
        }
    }

    private void flush0(boolean closing) {
        if (this.state != RequestState.EMPTY && !closing) {
            throw new LineSenderException((CharSequence)"Cannot flush buffer while row is in progress. Use sender.at() or sender.atNow() to finish the current row first.");
        }
        if (this.pendingRows == 0L) {
            return;
        }
        long retryingDeadlineNanos = Long.MIN_VALUE;
        int retryBackoff = 10;
        int contentLen = this.request.getContentLength();
        int actualTimeoutMillis = this.baseTimeoutMillis;
        if (this.minRequestThroughput > 0L) {
            long throughputTimeoutBonusMillis = (long)contentLen * 1000L / this.minRequestThroughput;
            actualTimeoutMillis = throughputTimeoutBonusMillis + (long)actualTimeoutMillis > Integer.MAX_VALUE ? Integer.MAX_VALUE : (actualTimeoutMillis += (int)throughputTimeoutBonusMillis);
        }
        block2: while (true) {
            try {
                while (true) {
                    long beforeRequest = System.nanoTime();
                    HttpClient.ResponseHeaders response = this.request.send(actualTimeoutMillis);
                    long elapsedNanos = System.nanoTime() - beforeRequest;
                    int remainingMillis = actualTimeoutMillis - (int)(elapsedNanos / 1000000L);
                    if (remainingMillis <= 0) {
                        throw new HttpClientException("Request timed out");
                    }
                    response.await(remainingMillis);
                    DirectUtf8Sequence statusCode = response.getStatusCode();
                    if (AbstractLineHttpSender.isSuccessResponse(statusCode)) {
                        this.consumeChunkedResponse(response);
                        if (!AbstractLineHttpSender.keepAliveDisabled(response)) break block2;
                        this.client.disconnect();
                        break block2;
                    }
                    assert (response.isChunked());
                    if (this.isRetryableHttpStatus(statusCode)) {
                        long nowNanos = System.nanoTime();
                        long l = retryingDeadlineNanos = retryingDeadlineNanos == Long.MIN_VALUE && !closing ? nowNanos + this.maxRetriesNanos : retryingDeadlineNanos;
                        if (nowNanos >= retryingDeadlineNanos) {
                            this.throwOnHttpErrorResponse(statusCode, response);
                        }
                        this.client.disconnect();
                        retryBackoff = this.backoff(retryBackoff);
                        continue;
                    }
                    this.throwOnHttpErrorResponse(statusCode, response);
                }
            }
            catch (HttpClientException e) {
                this.client.disconnect();
                long nowNanos = System.nanoTime();
                long l = retryingDeadlineNanos = retryingDeadlineNanos == Long.MIN_VALUE && !closing ? nowNanos + this.maxRetriesNanos : retryingDeadlineNanos;
                if (nowNanos >= retryingDeadlineNanos) {
                    this.pendingRows = 0L;
                    this.flushAfterNanos = Long.MAX_VALUE;
                    this.request = this.newRequest();
                    throw new LineSenderException((CharSequence)"Could not flush buffer: ").put(this.url).put(" Connection Failed").put(": ").put(e.getMessage());
                }
                retryBackoff = this.backoff(retryBackoff);
                continue;
            }
            break;
        }
        this.pendingRows = 0L;
        this.flushAfterNanos = System.nanoTime() + this.flushIntervalNanos;
        this.request = this.newRequest();
    }

    private boolean isRetryableHttpStatus(DirectUtf8Sequence statusCode) {
        if (statusCode == null || statusCode.size() != 3 || statusCode.byteAt(0) != 53) {
            return false;
        }
        byte middle = statusCode.byteAt(1);
        byte last = statusCode.byteAt(2);
        return middle == 48 && (last == 48 || last == 51 || last == 52 || last == 55 || last == 57) || middle == 50 && (last == 51 || last == 52 || last == 57) || middle == 57 && last == 57;
    }

    private HttpClient.Request newRequest() {
        HttpClient.Request r = this.client.newRequest(this.host, this.port).POST().url(this.path).header("User-Agent", "QuestDB/java/" + String.valueOf(this.questDBVersion));
        if (this.username != null) {
            r.authBasic(this.username, this.password);
        } else if (this.authToken != null) {
            r.authToken(null, this.authToken);
        }
        r.withContent();
        this.rowBookmark = r.getContentLength();
        return r;
    }

    private boolean rowAdded() {
        ++this.pendingRows;
        long nowNanos = System.nanoTime();
        if (this.flushAfterNanos == Long.MAX_VALUE) {
            this.flushAfterNanos = nowNanos + this.flushIntervalNanos;
        } else if (this.flushAfterNanos - nowNanos < 0L) {
            return true;
        }
        return this.pendingRows == (long)this.autoFlushRows;
    }

    private void throwOnHttpErrorResponse(DirectUtf8Sequence statusCode, HttpClient.ResponseHeaders response) {
        this.flushAfterNanos = Long.MAX_VALUE;
        this.pendingRows = 0L;
        this.request = this.newRequest();
        CharSequence statusAscii = statusCode.asAsciiCharSequence();
        if (Chars.equals((CharSequence)"405", statusAscii)) {
            this.consumeChunkedResponse(response);
            this.client.disconnect();
            throw new LineSenderException((CharSequence)"Could not flush buffer: HTTP endpoint does not support ILP. [http-status=405]");
        }
        if (Chars.equals((CharSequence)"401", statusAscii) || Chars.equals((CharSequence)"403", statusAscii)) {
            this.sink.clear();
            AbstractLineHttpSender.chunkedResponseToSink(response, this.sink);
            LineSenderException ex = new LineSenderException((CharSequence)"Could not flush buffer: HTTP endpoint authentication error");
            if (this.sink.length() > 0) {
                ex = ex.put(": ").put(this.sink);
            }
            ex.put(" [http-status=").put(statusAscii).put(']');
            this.client.disconnect();
            throw ex;
        }
        DirectUtf8Sequence contentType = response.getContentType();
        if (contentType != null && Utf8s.equalsAscii("application/json", contentType)) {
            if (this.jsonErrorParser == null) {
                this.jsonErrorParser = new JsonErrorParser();
            }
            this.jsonErrorParser.reset();
            LineSenderException ex = this.jsonErrorParser.toException(response.getResponse(), statusCode);
            this.client.disconnect();
            throw ex;
        }
        this.sink.clear();
        this.sink.put("Could not flush buffer: ");
        AbstractLineHttpSender.chunkedResponseToSink(response, this.sink);
        this.sink.put(" [http-status=").put(statusCode).put(']');
        this.client.disconnect();
        throw new LineSenderException(this.sink);
    }

    private void validateNotClosed() {
        if (this.closed) {
            throw new LineSenderException((CharSequence)"sender already closed");
        }
    }

    private void validateTableName(CharSequence name) {
        if (!TableUtils.isValidTableName(name, this.maxNameLength)) {
            if (name.length() > this.maxNameLength) {
                throw new LineSenderException((CharSequence)"table name is too long: [name = ").putAsPrintable(name).put(", maxNameLength=").put(this.maxNameLength).put(']');
            }
            throw new LineSenderException((CharSequence)"table name contains an illegal char: '\\n', '\\r', '?', ',', ''', '\"', '\\', '/', ':', ')', '(', '+', '*' '%%', '~', or a non-printable char: ").putAsPrintable(name);
        }
    }

    protected void escapeQuotedString(CharSequence name) {
        int n = name.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case '=': 
                case '\\': {
                    this.request.put((byte)92).put((byte)c);
                    continue block3;
                }
                default: {
                    this.request.put(c);
                }
            }
        }
    }

    protected void validateColumnName(CharSequence name) {
        if (!TableUtils.isValidColumnName(name, this.maxNameLength)) {
            if (name.length() > this.maxNameLength) {
                throw new LineSenderException((CharSequence)"column name is too long: [name = ").putAsPrintable(name).put(", maxNameLength=").put(this.maxNameLength).put(']');
            }
            throw new LineSenderException((CharSequence)"column name contains an illegal char: '\\n', '\\r', '?', '.', ',', ''', '\"', '\\', '/', ':', ')', '(', '+', '-', '*' '%%', '~', or a non-printable char: ").putAsPrintable(name);
        }
    }

    protected HttpClient.Request writeFieldName(CharSequence name) {
        this.validateColumnName(name);
        switch (this.state) {
            case EMPTY: {
                throw new LineSenderException((CharSequence)"table name must be set first");
            }
            case TABLE_NAME_SET: 
            case ADDING_SYMBOLS: {
                this.request.putAscii(' ');
                this.state = RequestState.ADDING_COLUMNS;
                break;
            }
            case ADDING_COLUMNS: {
                this.request.putAscii(',');
            }
        }
        this.escapeQuotedString(name);
        this.request.put('=');
        return this.request;
    }

    static enum RequestState {
        EMPTY,
        TABLE_NAME_SET,
        ADDING_SYMBOLS,
        ADDING_COLUMNS;

    }

    public static class JsonSettingsParser
    implements JsonParser,
    Closeable {
        private static final byte LINE_PROTO_SUPPORT_VERSIONS = 1;
        private static final byte MAX_NAME_LEN = 2;
        private final JsonLexer lexer = new JsonLexer(1024, 1024);
        private final IntList supportVersions = new IntList(8);
        private int maxNameLen = 0;
        private byte nextJsonValueFlag = 0;

        @Override
        public void close() {
            Misc.free(this.lexer);
        }

        public int getDefaultProtocolVersion() {
            if (this.supportVersions.size() == 0) {
                return 1;
            }
            if (this.supportVersions.contains(2)) {
                return 2;
            }
            if (this.supportVersions.contains(1)) {
                return 1;
            }
            throw new LineSenderException((CharSequence)"Server does not support current client");
        }

        public int getMaxNameLen() {
            return this.maxNameLen;
        }

        @Override
        public void onEvent(int code, CharSequence tag, int position) {
            switch (code) {
                case 5: {
                    if (tag.equals("line.proto.support.versions")) {
                        this.nextJsonValueFlag = 1;
                        break;
                    }
                    if (tag.equals("cairo.max.file.name.length")) {
                        this.nextJsonValueFlag = (byte)2;
                        break;
                    }
                    this.nextJsonValueFlag = 0;
                    break;
                }
                case 6: {
                    if (this.nextJsonValueFlag != 2) break;
                    try {
                        this.maxNameLen = Numbers.parseInt(tag);
                    }
                    catch (NumericException numericException) {}
                    break;
                }
                case 7: {
                    if (this.nextJsonValueFlag != 1) break;
                    try {
                        this.supportVersions.add(Numbers.parseInt(tag));
                    }
                    catch (NumericException numericException) {}
                    break;
                }
                case 4: {
                    if (this.nextJsonValueFlag != 1) break;
                    this.nextJsonValueFlag = 0;
                }
            }
        }

        public void parse(Response chunkedRsp) throws JsonException {
            Fragment fragment;
            while ((fragment = chunkedRsp.recv()) != null) {
                this.lexer.parse(fragment.lo(), fragment.hi(), this);
            }
        }
    }

    private static class JsonErrorParser
    implements JsonParser,
    Closeable {
        private final StringSink codeSink = new StringSink();
        private final StringSink errorIdSink = new StringSink();
        private final StringSink jsonSink = new StringSink();
        private final JsonLexer lexer = new JsonLexer(1024, 1024);
        private final StringSink lineSink = new StringSink();
        private final StringSink messageSink = new StringSink();
        private State state = State.INIT;

        private JsonErrorParser() {
        }

        @Override
        public void close() {
            Misc.free(this.lexer);
        }

        @Override
        public void onEvent(int code, CharSequence tag, int position) throws JsonException {
            switch (this.state) {
                case INIT: {
                    if (code == 1) {
                        this.state = State.NEXT_KEY_NAME;
                        break;
                    }
                    throw JsonException.$(position, "expected '{'");
                }
                case NEXT_KEY_NAME: {
                    if (code == 2) {
                        this.state = State.INIT;
                        break;
                    }
                    if (code == 5) {
                        if (Chars.equals((CharSequence)"code", tag)) {
                            this.state = State.NEXT_CODE_VALUE;
                            break;
                        }
                        if (Chars.equals((CharSequence)"message", tag)) {
                            this.state = State.NEXT_MESSAGE_VALUE;
                            break;
                        }
                        if (Chars.equals((CharSequence)"line", tag)) {
                            this.state = State.NEXT_LINE_NUMBER_VALUE;
                            break;
                        }
                        if (Chars.equals((CharSequence)"errorId", tag)) {
                            this.state = State.NEXT_ERROR_ID_VALUE;
                            break;
                        }
                        throw JsonException.$(position, "expected 'code', 'message', 'line' or 'error'");
                    }
                    throw JsonException.$(position, "expected 'error' or 'message'");
                }
                case NEXT_CODE_VALUE: {
                    if (code == 6) {
                        this.codeSink.put(tag);
                        this.state = State.NEXT_KEY_NAME;
                        break;
                    }
                    throw JsonException.$(position, "expected number");
                }
                case NEXT_MESSAGE_VALUE: {
                    if (code == 6) {
                        this.messageSink.put(tag);
                        this.state = State.NEXT_KEY_NAME;
                        break;
                    }
                    throw JsonException.$(position, "expected string");
                }
                case NEXT_LINE_NUMBER_VALUE: {
                    if (code == 6) {
                        this.lineSink.put(tag);
                        this.state = State.NEXT_KEY_NAME;
                        break;
                    }
                    throw JsonException.$(position, "expected number");
                }
                case NEXT_ERROR_ID_VALUE: {
                    if (code == 6) {
                        this.errorIdSink.put(tag);
                        this.state = State.NEXT_KEY_NAME;
                        break;
                    }
                    throw JsonException.$(position, "expected string");
                }
            }
        }

        private void drainAndReset(LineSenderException sink, DirectUtf8Sequence httpStatus) {
            assert (this.state == State.INIT);
            sink.put(this.messageSink).put(" [http-status=").put(httpStatus.asAsciiCharSequence());
            if (this.codeSink.length() > 0 || this.errorIdSink.length() > 0 || this.lineSink.length() > 0) {
                if (this.errorIdSink.length() > 0) {
                    sink.put(", id: ").put(this.errorIdSink);
                }
                if (this.codeSink.length() > 0) {
                    sink.put(", code: ").put(this.codeSink);
                }
                if (this.lineSink.length() > 0) {
                    sink.put(", line: ").put(this.lineSink);
                }
            }
            sink.put(']');
            this.reset();
        }

        private void reset() {
            this.state = State.INIT;
            this.codeSink.clear();
            this.errorIdSink.clear();
            this.lineSink.clear();
            this.messageSink.clear();
            this.lexer.clear();
            this.jsonSink.clear();
        }

        LineSenderException toException(Response chunkedRsp, DirectUtf8Sequence httpStatus) {
            Fragment fragment;
            LineSenderException exception = new LineSenderException((CharSequence)"Could not flush buffer: ");
            while ((fragment = chunkedRsp.recv()) != null) {
                try {
                    this.jsonSink.putNonAscii(fragment.lo(), fragment.hi());
                    this.lexer.parse(fragment.lo(), fragment.hi(), this);
                }
                catch (JsonException e) {
                    while ((fragment = chunkedRsp.recv()) != null) {
                        this.jsonSink.putNonAscii(fragment.lo(), fragment.hi());
                    }
                    exception.put(this.jsonSink).put(" [http-status=").put(httpStatus.asAsciiCharSequence()).put(']');
                    this.reset();
                    return exception;
                }
            }
            this.drainAndReset(exception, httpStatus);
            return exception;
        }

        static enum State {
            INIT,
            NEXT_KEY_NAME,
            NEXT_CODE_VALUE,
            NEXT_MESSAGE_VALUE,
            NEXT_LINE_NUMBER_VALUE,
            NEXT_ERROR_ID_VALUE,
            DONE;

        }
    }
}

