/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.metrics.AtomicLongGauge;
import io.questdb.metrics.Counter;
import io.questdb.metrics.LongGauge;
import io.questdb.metrics.MetricsRegistry;
import io.questdb.std.Mutable;

public class JsonQueryMetrics
implements Mutable {
    private final Counter cacheHitCounter;
    private final Counter cacheMissCounter;
    private final LongGauge cachedQueriesGauge;
    private final Counter completedQueriesCounter;
    private final AtomicLongGauge connectionCountGauge;
    private final Counter startedQueriesCounter;

    public JsonQueryMetrics(MetricsRegistry metricsRegistry) {
        this.connectionCountGauge = metricsRegistry.newAtomicLongGauge("json_queries_connections");
        this.startedQueriesCounter = metricsRegistry.newCounter("json_queries");
        this.completedQueriesCounter = metricsRegistry.newCounter("json_queries_completed");
        this.cachedQueriesGauge = metricsRegistry.newLongGauge("json_queries_cached");
        this.cacheHitCounter = metricsRegistry.newCounter("json_queries_cache_hits");
        this.cacheMissCounter = metricsRegistry.newCounter("json_queries_cache_misses");
    }

    public Counter cacheHitCounter() {
        return this.cacheHitCounter;
    }

    public Counter cacheMissCounter() {
        return this.cacheMissCounter;
    }

    public LongGauge cachedQueriesGauge() {
        return this.cachedQueriesGauge;
    }

    @Override
    public void clear() {
        this.connectionCountGauge.setValue(0L);
        this.cacheHitCounter.reset();
        this.cacheMissCounter.reset();
        this.cachedQueriesGauge.setValue(0L);
        this.completedQueriesCounter.reset();
        this.startedQueriesCounter.reset();
    }

    public long completedQueriesCount() {
        return this.completedQueriesCounter.getValue();
    }

    public AtomicLongGauge connectionCountGauge() {
        return this.connectionCountGauge;
    }

    public void markComplete() {
        this.completedQueriesCounter.inc();
    }

    public void markStart() {
        this.startedQueriesCounter.inc();
    }

    public long startedQueriesCount() {
        return this.startedQueriesCounter.getValue();
    }
}

