/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.client;

import io.questdb.cutlass.http.client.Fragment;
import io.questdb.cutlass.http.client.Response;

public abstract class AbstractResponse
implements Response,
Fragment {
    private final long bufHi;
    private final long bufLo;
    private final int defaultTimeout;
    private long bytesReceived;
    private long contentLength;
    private long dataHi;
    private long dataLo;
    private boolean receive = true;

    public AbstractResponse(long bufLo, long bufHi, int defaultTimeout) {
        this.bufLo = bufLo;
        this.bufHi = bufHi;
        this.defaultTimeout = defaultTimeout;
    }

    public void begin(long lo, long hi, long contentLength) {
        this.dataLo = lo;
        this.dataHi = hi;
        this.contentLength = contentLength;
        this.bytesReceived = 0L;
        this.receive = lo == hi;
    }

    @Override
    public long hi() {
        return this.dataHi;
    }

    @Override
    public long lo() {
        return this.dataLo;
    }

    @Override
    public Fragment recv(int timeout) {
        if (this.bytesReceived >= this.contentLength) {
            return null;
        }
        if (this.receive) {
            this.dataLo = this.bufLo;
            this.dataHi = this.bufLo;
            int len = 0;
            while (len == 0) {
                len = this.recvOrDie(this.dataHi, this.bufHi, timeout);
            }
            this.dataHi += (long)len;
        }
        this.bytesReceived += this.dataHi - this.dataLo;
        this.receive = true;
        return this;
    }

    @Override
    public Fragment recv() {
        return this.recv(this.defaultTimeout);
    }

    protected abstract int recvOrDie(long var1, long var3, int var5);
}

