/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.client;

import io.questdb.cutlass.http.client.Fragment;
import io.questdb.cutlass.http.client.HttpClientException;
import io.questdb.cutlass.http.client.Response;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.DirectUtf8String;

public abstract class AbstractChunkedResponse
implements Response,
Fragment {
    private static final int CRLF_LEN = 2;
    private static final int STATE_CHUNK_DATA = 1;
    private static final int STATE_CHUNK_DATA_END = 2;
    private static final int STATE_CHUNK_SIZE = 0;
    private final long bufHi;
    private final long bufLo;
    private final DirectUtf8String chunkSize = new DirectUtf8String();
    private final int defaultTimeout;
    long available;
    long consumed = 0L;
    long dataAddr;
    boolean endOfChunk;
    long size;
    private long dataHi;
    private long dataLo;
    private boolean receive = true;
    private int state = 0;

    public AbstractChunkedResponse(long bufLo, long bufHi, int defaultTimeout) {
        this.bufLo = bufLo;
        this.bufHi = bufHi;
        this.defaultTimeout = defaultTimeout;
    }

    public void begin(long lo, long hi) {
        this.dataLo = lo;
        this.dataHi = hi;
        this.state = 0;
        this.receive = hi == lo;
        this.endOfChunk = false;
        this.size = 0L;
        this.available = 0L;
        this.consumed = 0L;
    }

    @Override
    public long hi() {
        return this.dataAddr + this.available;
    }

    @Override
    public long lo() {
        return this.dataAddr;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Fragment recv(int timeout) {
        block7: while (true) {
            if (this.receive || this.dataLo == this.dataHi) {
                this.compactBuffer();
                this.dataHi += (long)this.recvOrDie(this.dataHi, this.bufHi, timeout);
            }
            switch (this.state) {
                case 0: {
                    res = -1L;
                    for (p = this.dataLo; p < this.dataHi; ++p) {
                        if (this.getByte(p) != 13) continue;
                        if (++p >= this.dataHi) break;
                        if (this.getByte(p) == 10) {
                            res = p - 2L;
                            break;
                        }
                        throw new HttpClientException("malformed chunk size");
                    }
                    if (res == -1L) ** GOTO lbl26
                    this.chunkSize.of(this.dataLo, res + 1L);
                    try {
                        this.size = Numbers.parseHexLong(this.chunkSize.asAsciiCharSequence());
                        this.consumed = 0L;
                        this.state = 1;
                        this.dataLo = res + 2L + 1L;
                        ** GOTO lbl28
                    }
                    catch (NumericException e) {
                        throw new HttpClientException("malformed chunk size");
                    }
lbl26:
                    // 1 sources

                    this.receive = true;
                    continue block7;
                }
lbl28:
                // 2 sources

                case 1: {
                    if (this.dataLo < this.dataHi) {
                        chunkBytesRemaining = this.size - this.consumed;
                        bufBytesRemaining = this.dataHi - this.dataLo;
                        this.dataAddr = this.dataLo;
                        if (chunkBytesRemaining <= bufBytesRemaining) {
                            this.available = chunkBytesRemaining;
                            this.consumed += chunkBytesRemaining;
                            this.endOfChunk = true;
                            this.dataLo += chunkBytesRemaining;
                            this.state = 2;
                            this.receive = false;
                        } else {
                            this.available = bufBytesRemaining;
                            this.consumed += bufBytesRemaining;
                            this.endOfChunk = false;
                            this.dataLo = this.dataHi;
                            this.receive = true;
                        }
                        return this.size > 0L ? this : null;
                    }
                    if (this.size != 0L) continue block7;
                    this.receive = false;
                    return null;
                }
                case 2: {
                    if (this.dataLo < this.dataHi && this.dataHi - this.dataLo >= 2L) {
                        if (this.getByte(this.dataLo) == 13 && this.getByte(this.dataLo + 1L) == 10) {
                            this.state = 0;
                            this.dataLo += 2L;
                            this.receive = false;
                            continue block7;
                        }
                        throw new HttpClientException("malformed chunk");
                    }
                    this.receive = true;
                    continue block7;
                }
            }
            break;
        }
        throw new HttpClientException("internal error [state=" + this.state + "]");
    }

    @Override
    public Fragment recv() {
        return this.recv(this.defaultTimeout);
    }

    private void compactBuffer() {
        if (this.dataLo > this.bufLo) {
            long len = this.dataHi - this.dataLo;
            assert (len > -1L);
            if (len > 0L) {
                Vect.memmove(this.bufLo, this.dataLo, len);
            }
            this.dataLo = this.bufLo;
            this.dataHi = this.bufLo + len;
        }
    }

    private byte getByte(long addr) {
        assert (addr != 0L);
        assert (addr >= this.bufLo);
        assert (addr < this.bufHi);
        return Unsafe.getUnsafe().getByte(addr);
    }

    protected abstract int recvOrDie(long var1, long var3, int var5);
}

