/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.BorrowedArray;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.wal.SymbolMapDiff;
import io.questdb.cairo.wal.SymbolMapDiffCursor;
import io.questdb.cairo.wal.SymbolMapDiffImpl;
import io.questdb.cairo.wal.WalTxnType;
import io.questdb.griffin.SqlException;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.DirectByteSequenceView;
import io.questdb.std.LongList;
import io.questdb.std.ObjectPool;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;

public class WalEventCursor {
    public static final long END_OF_EVENTS = -1L;
    private static final int DEDUP_MODE_OFFSET = 1;
    private static final int REPLACE_RANGE_HI_OFFSET = 9;
    private static final int REPLACE_RANGE_LO_OFFSET = 17;
    private static final int REPLACE_RANGE_EXTRA_OFFSET = 25;
    private static final int DEDUP_FOOTER_SIZE = 25;
    private final DataInfo dataInfo = new DataInfo();
    private final MemoryCMR eventMem;
    private final MatViewDataInfo mvDataInfo = new MatViewDataInfo();
    private final MatViewInvalidationInfo mvInvalidationInfo = new MatViewInvalidationInfo();
    private final SqlInfo sqlInfo = new SqlInfo();
    private long memSize;
    private long nextOffset = 4L;
    private long offset = 4L;
    private long txn = -1L;
    private byte type = (byte)-1;

    public WalEventCursor(MemoryCMR eventMem) {
        this.eventMem = eventMem;
    }

    public void drain() {
        long o;
        block2: {
            o = this.offset;
            while (this.memSize >= o + 4L) {
                int value = this.eventMem.getInt(o);
                o += 4L;
                if (value != -1) {
                    int strLength = this.eventMem.getStrLen(o);
                    long storageLength = Vm.getStorageLength(strLength);
                    o += storageLength;
                    continue;
                }
                break block2;
            }
            throw CairoException.critical(0).put("WAL event file is too small, size=").put(this.memSize).put(", required=").put(o + 4L);
        }
        this.offset = o;
    }

    public DataInfo getDataInfo() {
        if (!WalTxnType.isDataType(this.type)) {
            throw CairoException.critical(-101).put("WAL event type is not DATA, type=").put(this.type);
        }
        return this.type == 0 ? this.dataInfo : this.mvDataInfo;
    }

    public MatViewDataInfo getMatViewDataInfo() {
        if (this.type != 3) {
            throw CairoException.critical(-101).put("WAL event type is not MAT_VIEW_DATA, type=").put(this.type);
        }
        return this.mvDataInfo;
    }

    public MatViewInvalidationInfo getMatViewInvalidationInfo() {
        if (this.type != 4) {
            throw CairoException.critical(-101).put("WAL event type is not MAT_VIEW_INVALIDATION, type=").put(this.type);
        }
        return this.mvInvalidationInfo;
    }

    public SqlInfo getSqlInfo() {
        if (this.type != 1) {
            throw CairoException.critical(-101).put("WAL event type is not SQL, type=").put(this.type);
        }
        return this.sqlInfo;
    }

    public long getTxn() {
        return this.txn;
    }

    public byte getType() {
        return this.type;
    }

    public boolean hasNext() {
        this.offset = this.nextOffset;
        int length = this.readInt();
        if (length < 1) {
            return false;
        }
        this.nextOffset = (long)length + this.nextOffset;
        if (this.memSize < this.nextOffset + 4L) {
            this.eventMem.extend(this.nextOffset + 4L);
            this.memSize = this.eventMem.size();
        }
        this.txn = this.readLong();
        if (this.txn == -1L) {
            return false;
        }
        this.readRecord();
        return true;
    }

    public void reset() {
        this.memSize = this.eventMem.size();
        this.nextOffset = 8L;
        this.txn = -1L;
        this.type = (byte)-1;
    }

    private void checkMemSize(long requiredBytes) {
        if (this.memSize < this.offset + requiredBytes) {
            throw CairoException.critical(0).put("WAL event file is too small, size=").put(this.memSize).put(", required=").put(this.offset + requiredBytes);
        }
    }

    private ArrayView readArray(BorrowedArray array) {
        this.checkMemSize(8L);
        long totalSize = this.eventMem.getLong(this.offset);
        if (totalSize < 0L) {
            totalSize = 0L;
        }
        this.checkMemSize(totalSize + 8L);
        this.eventMem.getArray(this.offset, array);
        this.offset += 8L + totalSize;
        return array;
    }

    private BinarySequence readBin(DirectByteSequenceView view) {
        this.checkMemSize(8L);
        long binLength = this.eventMem.getBinLen(this.offset);
        this.checkMemSize(binLength);
        view.of((DirectByteSequenceView)this.eventMem.getBin(this.offset));
        this.offset += binLength + 8L;
        return view;
    }

    private boolean readBool() {
        this.checkMemSize(1L);
        boolean value = this.eventMem.getBool(this.offset);
        ++this.offset;
        return value;
    }

    private byte readByte() {
        this.checkMemSize(1L);
        byte value = this.eventMem.getByte(this.offset);
        ++this.offset;
        return value;
    }

    private char readChar() {
        this.checkMemSize(2L);
        char value = this.eventMem.getChar(this.offset);
        this.offset += 2L;
        return value;
    }

    private double readDouble() {
        this.checkMemSize(8L);
        double value = this.eventMem.getDouble(this.offset);
        this.offset += 8L;
        return value;
    }

    private float readFloat() {
        this.checkMemSize(4L);
        float value = this.eventMem.getFloat(this.offset);
        this.offset += 4L;
        return value;
    }

    private int readInt() {
        this.checkMemSize(4L);
        int value = this.eventMem.getInt(this.offset);
        this.offset += 4L;
        return value;
    }

    private long readLong() {
        this.checkMemSize(8L);
        long value = this.eventMem.getLong(this.offset);
        this.offset += 8L;
        return value;
    }

    private void readRecord() {
        this.type = this.readByte();
        switch (this.type) {
            case 0: {
                this.dataInfo.read();
                break;
            }
            case 3: {
                this.mvDataInfo.read();
                break;
            }
            case 1: {
                this.sqlInfo.read();
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.mvInvalidationInfo.read();
                break;
            }
            default: {
                throw CairoException.critical(-100).put("Unsupported WAL event type: ").put(this.type);
            }
        }
    }

    private short readShort() {
        this.checkMemSize(2L);
        short value = this.eventMem.getShort(this.offset);
        this.offset += 2L;
        return value;
    }

    private CharSequence readStr() {
        this.checkMemSize(4L);
        int strLength = this.eventMem.getStrLen(this.offset);
        long storageLength = strLength > 0 ? Vm.getStorageLength(strLength) : 4L;
        this.checkMemSize(storageLength);
        CharSequence value = strLength >= 0 ? this.eventMem.getStrA(this.offset) : null;
        this.offset += storageLength;
        return value;
    }

    private long readStrOffset() {
        this.checkMemSize(4L);
        int strLength = this.eventMem.getStrLen(this.offset);
        long storageLength = strLength > 0 ? Vm.getStorageLength(strLength) : 4L;
        this.checkMemSize(storageLength);
        this.offset += storageLength;
        return this.offset - storageLength;
    }

    private Utf8Sequence readVarchar() {
        Utf8Sequence seq = VarcharTypeDriver.getPlainValue(this.eventMem, this.offset);
        if (seq == null) {
            this.offset += 4L;
            return null;
        }
        this.offset += (long)(seq.size() + 4);
        return seq;
    }

    void openOffset(long offset) {
        this.reset();
        if (offset > 0L) {
            this.offset = offset;
            int size = this.readInt();
            this.nextOffset = offset + (long)size;
            this.txn = this.readLong();
            this.memSize = this.eventMem.size();
            this.readRecord();
        }
    }

    SymbolMapDiff readNextSymbolMapDiff(SymbolMapDiffImpl symbolMapDiff) {
        int columnIndex = this.readInt();
        if (columnIndex == -1) {
            return null;
        }
        boolean nullFlag = this.readBool();
        int cleanTableSymbolCount = this.readInt();
        int size = this.readInt();
        symbolMapDiff.of(columnIndex, cleanTableSymbolCount, size, nullFlag);
        return symbolMapDiff;
    }

    SymbolMapDiffImpl.Entry readNextSymbolMapDiffEntry(SymbolMapDiffImpl.Entry entry) {
        int key = this.readInt();
        if (key == -1) {
            entry.clear();
            return null;
        }
        long symbolOffset = this.readStrOffset();
        entry.of(key, symbolOffset, this.eventMem);
        return entry;
    }

    public class DataInfo
    implements SymbolMapDiffCursor {
        private final SymbolMapDiffImpl symbolMapDiff;
        protected long replaceRangeExtra;
        private byte dedupMode;
        private long endRowID;
        private long maxTimestamp;
        private long minTimestamp;
        private boolean outOfOrder;
        private long replaceRangeTsHi;
        private long replaceRangeTsLow;
        private long startRowID;

        public DataInfo() {
            this.symbolMapDiff = new SymbolMapDiffImpl(WalEventCursor.this);
        }

        public byte getDedupMode() {
            return this.dedupMode;
        }

        public long getEndRowID() {
            return this.endRowID;
        }

        public long getMaxTimestamp() {
            return this.maxTimestamp;
        }

        public long getMinTimestamp() {
            return this.minTimestamp;
        }

        public long getReplaceRangeTsHi() {
            return this.replaceRangeTsHi;
        }

        public long getReplaceRangeTsLow() {
            return this.replaceRangeTsLow;
        }

        public long getStartRowID() {
            return this.startRowID;
        }

        public boolean isOutOfOrder() {
            return this.outOfOrder;
        }

        @Override
        public SymbolMapDiff nextSymbolMapDiff() {
            return WalEventCursor.this.readNextSymbolMapDiff(this.symbolMapDiff);
        }

        protected void read() {
            int symbolColIndex;
            this.startRowID = WalEventCursor.this.readLong();
            this.endRowID = WalEventCursor.this.readLong();
            this.minTimestamp = WalEventCursor.this.readLong();
            this.maxTimestamp = WalEventCursor.this.readLong();
            this.outOfOrder = WalEventCursor.this.readBool();
            this.dedupMode = 0;
            this.replaceRangeTsLow = 0L;
            this.replaceRangeTsHi = 0L;
            if (WalEventCursor.this.nextOffset - WalEventCursor.this.offset >= 29L && (symbolColIndex = WalEventCursor.this.eventMem.getInt(WalEventCursor.this.nextOffset - 29L)) == -1) {
                this.dedupMode = WalEventCursor.this.eventMem.getByte(WalEventCursor.this.nextOffset - 1L);
                if (this.dedupMode >= 0 && this.dedupMode <= 3) {
                    this.replaceRangeExtra = WalEventCursor.this.eventMem.getLong(WalEventCursor.this.nextOffset - 25L);
                    this.replaceRangeTsLow = WalEventCursor.this.eventMem.getLong(WalEventCursor.this.nextOffset - 17L);
                    this.replaceRangeTsHi = WalEventCursor.this.eventMem.getLong(WalEventCursor.this.nextOffset - 9L);
                } else {
                    this.dedupMode = 0;
                }
            }
        }
    }

    public class MatViewDataInfo
    extends DataInfo {
        private long lastRefreshBaseTableTxn;
        private long lastRefreshTimestamp;

        public long getLastPeriodHi() {
            return this.replaceRangeExtra;
        }

        public long getLastRefreshBaseTableTxn() {
            return this.lastRefreshBaseTableTxn;
        }

        public long getLastRefreshTimestamp() {
            return this.lastRefreshTimestamp;
        }

        @Override
        protected void read() {
            super.read();
            this.lastRefreshBaseTableTxn = WalEventCursor.this.readLong();
            this.lastRefreshTimestamp = WalEventCursor.this.readLong();
        }
    }

    public class MatViewInvalidationInfo {
        private final StringSink error = new StringSink();
        private final LongList refreshIntervals = new LongList();
        private boolean invalid;
        private long lastPeriodHi;
        private long lastRefreshBaseTableTxn;
        private long lastRefreshTimestamp;
        private long refreshIntervalsBaseTxn;

        public CharSequence getInvalidationReason() {
            return this.error;
        }

        public long getLastPeriodHi() {
            return this.lastPeriodHi;
        }

        public long getLastRefreshBaseTableTxn() {
            return this.lastRefreshBaseTableTxn;
        }

        public long getLastRefreshTimestamp() {
            return this.lastRefreshTimestamp;
        }

        public LongList getRefreshIntervals() {
            return this.refreshIntervals;
        }

        public long getRefreshIntervalsBaseTxn() {
            return this.refreshIntervalsBaseTxn;
        }

        public boolean isInvalid() {
            return this.invalid;
        }

        private void read() {
            this.lastRefreshBaseTableTxn = WalEventCursor.this.readLong();
            this.lastRefreshTimestamp = WalEventCursor.this.readLong();
            this.invalid = WalEventCursor.this.readBool();
            this.error.clear();
            this.error.put(WalEventCursor.this.readStr());
            this.lastPeriodHi = WalEventCursor.this.nextOffset - WalEventCursor.this.offset >= 8L ? WalEventCursor.this.readLong() : Long.MIN_VALUE;
            this.refreshIntervals.clear();
            if (WalEventCursor.this.nextOffset - WalEventCursor.this.offset >= 12L) {
                this.refreshIntervalsBaseTxn = WalEventCursor.this.readLong();
                int intervalsLen = WalEventCursor.this.readInt();
                for (int i = 0; i < intervalsLen; ++i) {
                    this.refreshIntervals.add(WalEventCursor.this.readLong());
                }
            } else {
                this.refreshIntervalsBaseTxn = -1L;
            }
        }
    }

    public class SqlInfo {
        private final ObjectPool<BorrowedArray> arrayViewPool = new ObjectPool<BorrowedArray>(BorrowedArray::new, 1);
        private final ObjectPool<DirectByteSequenceView> byteViewPool = new ObjectPool<DirectByteSequenceView>(DirectByteSequenceView::new, 1);
        private final StringSink sql = new StringSink();
        private int cmdType;
        private long rndSeed0;
        private long rndSeed1;

        public int getCmdType() {
            return this.cmdType;
        }

        public long getRndSeed0() {
            return this.rndSeed0;
        }

        public long getRndSeed1() {
            return this.rndSeed1;
        }

        public CharSequence getSql() {
            return this.sql;
        }

        public void populateBindVariableService(BindVariableService bindVariableService) {
            bindVariableService.clear();
            try {
                this.populateIndexedVariables(bindVariableService);
                this.populateNamedVariables(bindVariableService);
            }
            catch (SqlException e) {
                throw CairoException.critical(0).put(e.getMessage());
            }
        }

        private void populateIndexedVariables(BindVariableService bindVariableService) throws SqlException {
            int count = WalEventCursor.this.readInt();
            block19: for (int i = 0; i < count; ++i) {
                int type = WalEventCursor.this.readInt();
                switch (ColumnType.tagOf(type)) {
                    case 1: {
                        bindVariableService.setBoolean(i, WalEventCursor.this.readBool());
                        continue block19;
                    }
                    case 2: {
                        bindVariableService.setByte(i, WalEventCursor.this.readByte());
                        continue block19;
                    }
                    case 3: {
                        bindVariableService.setShort(i, WalEventCursor.this.readShort());
                        continue block19;
                    }
                    case 4: {
                        bindVariableService.setChar(i, WalEventCursor.this.readChar());
                        continue block19;
                    }
                    case 5: 
                    case 25: {
                        bindVariableService.setInt(i, WalEventCursor.this.readInt());
                        continue block19;
                    }
                    case 9: {
                        bindVariableService.setFloat(i, WalEventCursor.this.readFloat());
                        continue block19;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        bindVariableService.setLong(i, WalEventCursor.this.readLong());
                        continue block19;
                    }
                    case 10: {
                        bindVariableService.setDouble(i, WalEventCursor.this.readDouble());
                        continue block19;
                    }
                    case 11: {
                        bindVariableService.setStr(i, WalEventCursor.this.readStr());
                        continue block19;
                    }
                    case 26: {
                        bindVariableService.setVarchar(i, WalEventCursor.this.readVarchar());
                        continue block19;
                    }
                    case 18: {
                        bindVariableService.setBin(i, WalEventCursor.this.readBin(this.byteViewPool.next()));
                        continue block19;
                    }
                    case 14: {
                        bindVariableService.setGeoHash(i, (long)WalEventCursor.this.readByte(), type);
                        continue block19;
                    }
                    case 15: {
                        bindVariableService.setGeoHash(i, (long)WalEventCursor.this.readShort(), type);
                        continue block19;
                    }
                    case 16: {
                        bindVariableService.setGeoHash(i, (long)WalEventCursor.this.readInt(), type);
                        continue block19;
                    }
                    case 17: {
                        bindVariableService.setGeoHash(i, WalEventCursor.this.readLong(), type);
                        continue block19;
                    }
                    case 19: {
                        long lo = WalEventCursor.this.readLong();
                        long hi = WalEventCursor.this.readLong();
                        bindVariableService.setUuid(i, lo, hi);
                        continue block19;
                    }
                    case 27: {
                        bindVariableService.setArray(i, WalEventCursor.this.readArray(this.arrayViewPool.next()));
                        continue block19;
                    }
                    default: {
                        throw new UnsupportedOperationException("unsupported column type: " + ColumnType.nameOf(type));
                    }
                }
            }
        }

        private void populateNamedVariables(BindVariableService bindVariableService) throws SqlException {
            int count = WalEventCursor.this.readInt();
            block19: for (int i = 0; i < count; ++i) {
                String name = Chars.toString(WalEventCursor.this.readStr());
                int type = WalEventCursor.this.readInt();
                switch (ColumnType.tagOf(type)) {
                    case 1: {
                        bindVariableService.setBoolean(name, WalEventCursor.this.readBool());
                        continue block19;
                    }
                    case 2: {
                        bindVariableService.setByte(name, WalEventCursor.this.readByte());
                        continue block19;
                    }
                    case 3: {
                        bindVariableService.setShort(name, WalEventCursor.this.readShort());
                        continue block19;
                    }
                    case 4: {
                        bindVariableService.setChar(name, WalEventCursor.this.readChar());
                        continue block19;
                    }
                    case 5: 
                    case 25: {
                        bindVariableService.setInt(name, WalEventCursor.this.readInt());
                        continue block19;
                    }
                    case 9: {
                        bindVariableService.setFloat(name, WalEventCursor.this.readFloat());
                        continue block19;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        bindVariableService.setLong(name, WalEventCursor.this.readLong());
                        continue block19;
                    }
                    case 10: {
                        bindVariableService.setDouble(name, WalEventCursor.this.readDouble());
                        continue block19;
                    }
                    case 11: {
                        bindVariableService.setStr(name, WalEventCursor.this.readStr());
                        continue block19;
                    }
                    case 26: {
                        bindVariableService.setVarchar(name, WalEventCursor.this.readVarchar());
                        continue block19;
                    }
                    case 18: {
                        bindVariableService.setBin(name, WalEventCursor.this.readBin(this.byteViewPool.next()));
                        continue block19;
                    }
                    case 14: {
                        bindVariableService.setGeoHash(name, (long)WalEventCursor.this.readByte(), type);
                        continue block19;
                    }
                    case 15: {
                        bindVariableService.setGeoHash(name, (long)WalEventCursor.this.readShort(), type);
                        continue block19;
                    }
                    case 16: {
                        bindVariableService.setGeoHash(name, (long)WalEventCursor.this.readInt(), type);
                        continue block19;
                    }
                    case 17: {
                        bindVariableService.setGeoHash(name, WalEventCursor.this.readLong(), type);
                        continue block19;
                    }
                    case 19: {
                        bindVariableService.setUuid(name, WalEventCursor.this.readLong(), WalEventCursor.this.readLong());
                        continue block19;
                    }
                    case 27: {
                        bindVariableService.setArray(i, WalEventCursor.this.readArray(this.arrayViewPool.next()));
                        continue block19;
                    }
                    default: {
                        throw new UnsupportedOperationException("unsupported column type: " + ColumnType.nameOf(type));
                    }
                }
            }
        }

        private void read() {
            this.cmdType = WalEventCursor.this.readInt();
            this.sql.clear();
            this.sql.put(WalEventCursor.this.readStr());
            this.rndSeed0 = WalEventCursor.this.readLong();
            this.rndSeed1 = WalEventCursor.this.readLong();
            this.arrayViewPool.clear();
            this.byteViewPool.clear();
        }
    }
}

