/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.MemoryPARWImpl;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.LPSZ;
import org.jetbrains.annotations.Nullable;

public class MemoryPMARImpl
extends MemoryPARWImpl
implements MemoryMAR {
    private static final Log LOG = LogFactory.getLog(MemoryPMARImpl.class);
    private final CairoConfiguration configuration;
    private long fd = -1L;
    private FilesFacade ff;
    private int madviseOpts = -1;
    private int mappedPage;
    private long pageAddress = 0L;

    public MemoryPMARImpl(FilesFacade ff, LPSZ name, long pageSize, int memoryTag, int opts) {
        this(null);
        this.of(ff, name, pageSize, 0L, memoryTag, opts, -1);
    }

    public MemoryPMARImpl(@Nullable CairoConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close(boolean truncate, byte truncateMode) {
        long sz = truncate ? this.getAppendOffset() : -1L;
        this.releaseCurrentPage();
        super.close();
        if (this.fd != -1L) {
            try {
                Vm.bestEffortClose(this.ff, LOG, this.fd, sz, truncateMode);
            }
            finally {
                this.fd = -1L;
            }
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public long detachFdClose() {
        long fd = this.fd;
        this.fd = -1L;
        this.close(false);
        return fd;
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public FilesFacade getFilesFacade() {
        return this.ff;
    }

    @Override
    public long getPageAddress(int page) {
        if (page == this.mappedPage) {
            return this.pageAddress;
        }
        return 0L;
    }

    public long mapPage(int page) {
        long address = TableUtils.mapRW(this.ff, this.fd, this.getExtendSegmentSize(), this.pageOffset(page), this.memoryTag);
        this.mappedPage = page;
        this.ff.madvise(address, this.getExtendSegmentSize(), this.madviseOpts);
        return address;
    }

    @Override
    public final void of(FilesFacade ff, LPSZ name, long extendSegmentSize, int memoryTag, int opts) {
        this.of(ff, name, extendSegmentSize, 0L, memoryTag, opts, -1);
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long extendSegmentSize, long size, int memoryTag, int opts) {
        this.of(ff, name, extendSegmentSize, memoryTag, opts);
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long extendSegmentSize, long size, int memoryTag, int opts, int madviseOpts) {
        this.close();
        this.memoryTag = memoryTag;
        this.madviseOpts = madviseOpts;
        this.ff = ff;
        this.mappedPage = -1;
        this.setExtendSegmentSize(extendSegmentSize);
        this.fd = TableUtils.openFileRWOrFail(ff, name, opts);
        LOG.debug().$("open ").$(name).$(" [fd=").$(this.fd).$(", extendSegmentSize=").$(extendSegmentSize).$(']').$();
    }

    @Override
    public void switchTo(FilesFacade ff, long fd, long extendSegmentSize, long offset, boolean truncate, byte truncateMode) {
        this.ff = ff;
        this.setExtendSegmentSize(extendSegmentSize);
        this.close(truncate, truncateMode);
        this.fd = fd;
        this.jumpTo(offset);
    }

    @Override
    public void sync(boolean async) {
        if (this.pageAddress != 0L) {
            this.ff.msync(this.pageAddress, this.getPageSize(), async);
        }
    }

    @Override
    public void truncate() {
        if (this.fd == -1L) {
            return;
        }
        this.releaseCurrentPage();
        if (!this.ff.truncate(Math.abs(this.fd), this.getExtendSegmentSize())) {
            throw CairoException.critical(this.ff.errno()).put("Cannot truncate fd=").put(this.fd).put(" to ").put(this.getExtendSegmentSize()).put(" bytes");
        }
        this.pageAddress = this.mapPage(0);
        this.updateLimits(0, this.pageAddress);
        LOG.debug().$("truncated [fd=").$(this.fd).$(']').$();
    }

    @Override
    public void wholeFile(FilesFacade ff, LPSZ name, int memoryTag) {
        this.of(ff, name, ff.getMapPageSize(), 0L, memoryTag, 0, -1);
    }

    @Override
    protected long mapWritePage(int page, long offset) {
        this.releaseCurrentPage();
        this.pageAddress = this.mapPage(page);
        return this.pageAddress;
    }

    @Override
    protected void release(long address) {
        int commitMode;
        int n = commitMode = this.configuration != null ? this.configuration.getCommitMode() : 2;
        if (commitMode != 2) {
            this.ff.msync(address, this.getPageSize(), commitMode == 0);
        }
        this.ff.munmap(address, this.getPageSize(), this.memoryTag);
    }

    void releaseCurrentPage() {
        if (this.pageAddress != 0L) {
            this.release(this.pageAddress);
            this.pageAddress = 0L;
        }
    }
}

