/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.pool;

import io.questdb.Metrics;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.DdlListener;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.pool.AbstractMultiTenantPool;
import io.questdb.cairo.pool.PoolTenant;
import io.questdb.cairo.pool.ResourcePoolSupervisor;
import io.questdb.cairo.wal.WalDirectoryPolicy;
import io.questdb.cairo.wal.WalWriter;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import org.jetbrains.annotations.Nullable;

public class WalWriterPool
extends AbstractMultiTenantPool<WalWriterTenant> {
    private final CairoEngine engine;

    public WalWriterPool(CairoConfiguration configuration, CairoEngine engine) {
        super(configuration, configuration.getWalWriterPoolMaxSegments(), configuration.getInactiveWalWriterTTL());
        this.engine = engine;
    }

    @Override
    protected byte getListenerSrc() {
        return 4;
    }

    @Override
    protected WalWriterTenant newTenant(TableToken tableToken, AbstractMultiTenantPool.Entry<WalWriterTenant> entry, int index, @Nullable ResourcePoolSupervisor<WalWriterTenant> supervisor) {
        return new WalWriterTenant(this, entry, index, tableToken, this.engine.getTableSequencerAPI(), this.engine.getDdlListener(tableToken), this.engine.getWalDirectoryPolicy(), this.engine.getMetrics());
    }

    public static class WalWriterTenant
    extends WalWriter
    implements PoolTenant<WalWriterTenant> {
        private final int index;
        private AbstractMultiTenantPool.Entry<WalWriterTenant> entry;
        private AbstractMultiTenantPool<WalWriterTenant> pool;

        public WalWriterTenant(AbstractMultiTenantPool<WalWriterTenant> pool, AbstractMultiTenantPool.Entry<WalWriterTenant> entry, int index, TableToken tableToken, TableSequencerAPI tableSequencerAPI, DdlListener ddlListener, WalDirectoryPolicy walDirectoryPolicy, Metrics metrics) {
            super(pool.getConfiguration(), tableToken, tableSequencerAPI, ddlListener, walDirectoryPolicy);
            this.pool = pool;
            this.entry = entry;
            this.index = index;
        }

        @Override
        public void close() {
            if (this.isOpen()) {
                this.rollback();
                AbstractMultiTenantPool<WalWriterTenant> pool = this.pool;
                if (pool != null && this.entry != null) {
                    if (!this.isDistressed()) {
                        if (pool.returnToPool(this)) {
                            return;
                        }
                    } else {
                        try {
                            super.close();
                        }
                        finally {
                            pool.expelFromPool(this);
                        }
                        return;
                    }
                }
                super.close();
            }
        }

        @Override
        public AbstractMultiTenantPool.Entry<WalWriterTenant> getEntry() {
            return this.entry;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void goodbye() {
            this.entry = null;
            this.pool = null;
        }

        @Override
        public void refresh(@Nullable ResourcePoolSupervisor<WalWriterTenant> supervisor) {
            try {
                this.goActive();
            }
            catch (Throwable ex) {
                this.close();
                throw ex;
            }
        }
    }
}

