/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mv;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.wal.WalEventCursor;
import io.questdb.cairo.wal.WalEventReader;
import io.questdb.cairo.wal.WalTxnDetails;
import io.questdb.cairo.wal.WalTxnType;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.DirectLongList;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.QuietCloseable;
import io.questdb.std.str.Path;
import org.jetbrains.annotations.NotNull;

public class WalTxnRangeLoader
implements QuietCloseable {
    private final WalEventReader walEventReader;
    private long maxTimestamp;
    private long minTimestamp;
    private DirectLongList txnDetails = new DirectLongList(40L, 55);

    public WalTxnRangeLoader(FilesFacade ff) {
        this.walEventReader = new WalEventReader(ff);
    }

    @Override
    public void close() {
        this.txnDetails = Misc.free(this.txnDetails);
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public void load(@NotNull CairoEngine engine, @NotNull Path tempPath, @NotNull TableToken tableToken, @NotNull LongList intervals, long txnLo, long txnHi) {
        try (TransactionLogCursor transactionLogCursor = engine.getTableSequencerAPI().getCursor(tableToken, txnLo);){
            tempPath.of(engine.getConfiguration().getDbRoot()).concat(tableToken);
            int rootLen = tempPath.size();
            this.loadTransactionDetailsFromWalE(tempPath, rootLen, transactionLogCursor, intervals, txnLo, txnHi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTransactionDetailsFromWalE(Path tempPath, int rootLen, TransactionLogCursor transactionLogCursor, LongList intervals, long txnLo, long txnHi) {
        this.txnDetails.clear();
        this.minTimestamp = Long.MAX_VALUE;
        this.maxTimestamp = Long.MIN_VALUE;
        try (WalEventReader eventReader = this.walEventReader;){
            int maxLoadTxnCount = (int)(txnHi - txnLo);
            int txnsToLoad = (int)Math.min((long)maxLoadTxnCount, transactionLogCursor.getMaxTxn() - txnLo + 1L);
            if (txnsToLoad > 0) {
                txnsToLoad = WalTxnDetails.loadTxns(transactionLogCursor, txnsToLoad, this.txnDetails);
                int lastWalId = -1;
                int lastSegmentId = -1;
                int lastSegmentTxn = -2;
                WalEventCursor walEventCursor = null;
                for (int i = 0; i < txnsToLoad; ++i) {
                    long long1 = this.txnDetails.get(2L * (long)i);
                    long long2 = this.txnDetails.get(2L * (long)i + 1L);
                    long seqTxn = (long)Numbers.decodeHighInt(long2) + txnLo;
                    int walId = Numbers.decodeHighInt(long1) + -2;
                    int segmentId = Numbers.decodeLowInt(long1);
                    int segmentTxn = Numbers.decodeLowInt(long2);
                    if (walId <= 0) continue;
                    if (lastWalId == walId && segmentId == lastSegmentId) {
                        assert (segmentTxn > lastSegmentTxn);
                        while (lastSegmentTxn < segmentTxn && walEventCursor.hasNext()) {
                            ++lastSegmentTxn;
                        }
                        if (lastSegmentTxn != segmentTxn) {
                            walEventCursor = WalTxnDetails.openWalEFile(tempPath, eventReader, segmentTxn, seqTxn);
                            lastSegmentTxn = segmentTxn;
                        }
                    } else {
                        tempPath.trimTo(rootLen).concat("wal").put(walId).slash().put(segmentId);
                        walEventCursor = WalTxnDetails.openWalEFile(tempPath, eventReader, segmentTxn, seqTxn);
                        lastWalId = walId;
                        lastSegmentId = segmentId;
                        lastSegmentTxn = segmentTxn;
                    }
                    if (!WalTxnType.isDataType(walEventCursor.getType())) continue;
                    WalEventCursor.DataInfo dataInfo = walEventCursor.getDataInfo();
                    long minTimestamp1 = dataInfo.getMinTimestamp();
                    long maxTimestamp1 = dataInfo.getMaxTimestamp();
                    if (dataInfo.getDedupMode() == 3) {
                        minTimestamp1 = dataInfo.getReplaceRangeTsLow();
                        maxTimestamp1 = dataInfo.getReplaceRangeTsHi() - 1L;
                    }
                    intervals.add(minTimestamp1, maxTimestamp1);
                    IntervalUtils.unionInPlace(intervals, intervals.size() - 2);
                }
                if (intervals.size() > 0) {
                    this.minTimestamp = intervals.getQuick(0);
                    this.maxTimestamp = intervals.getQuick(intervals.size() - 1);
                }
            }
        }
        finally {
            this.txnDetails.resetCapacity();
        }
    }
}

