/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.std.BinarySequence;
import io.questdb.std.DirectLongLongSortedList;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Utf8Sequence;

public class ShardedMapCursor
implements MapRecordCursor {
    private final ShardedMapRecord recordA = new ShardedMapRecord(true);
    private final ShardedMapRecord recordB = new ShardedMapRecord(false);
    private final ObjList<MapRecordCursor> shardCursors = new ObjList();
    private MapRecordCursor currentCursor;
    private int currentIndex;

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        int n = this.shardCursors.size();
        for (int i = this.currentIndex; i < n; ++i) {
            this.shardCursors.getQuick(i).calculateSize(circuitBreaker, counter);
        }
    }

    @Override
    public void close() {
        Misc.freeObjList(this.shardCursors);
    }

    @Override
    public MapRecord getRecord() {
        return this.recordA;
    }

    @Override
    public MapRecord getRecordB() {
        return this.recordB;
    }

    @Override
    public boolean hasNext() throws DataUnavailableException {
        if (this.currentCursor.hasNext()) {
            this.recordA.of(this.currentCursor.getRecord(), this.currentIndex);
            return true;
        }
        int n = this.shardCursors.size();
        while (++this.currentIndex < n) {
            this.currentCursor = this.shardCursors.getQuick(this.currentIndex);
            if (!this.currentCursor.hasNext()) continue;
            this.recordA.of(this.currentCursor.getRecord(), this.currentIndex);
            return true;
        }
        return false;
    }

    @Override
    public void longTopK(DirectLongLongSortedList list, Function recordFunction) {
        int n = this.shardCursors.size();
        for (int i = 0; i < n; ++i) {
            this.shardCursors.getQuick(i).longTopK(list, recordFunction);
        }
    }

    public void of(ObjList<Map> shards) {
        this.shardCursors.clear();
        int n = shards.size();
        for (int i = 0; i < n; ++i) {
            this.shardCursors.add(shards.getQuick(i).getCursor());
        }
        this.toTop();
    }

    @Override
    public long preComputedStateSize() {
        return 0L;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        int shardIndex = ShardedMapCursor.toShardIndex(atRowId);
        long rowId = ShardedMapCursor.toShardRowId(atRowId);
        ((ShardedMapRecord)record).at(shardIndex, rowId);
    }

    @Override
    public long size() throws DataUnavailableException {
        long size = 0L;
        int n = this.shardCursors.size();
        for (int i = 0; i < n; ++i) {
            size += this.shardCursors.getQuick(i).size();
        }
        return size;
    }

    @Override
    public void toTop() {
        int n = this.shardCursors.size();
        for (int i = 0; i < n; ++i) {
            this.shardCursors.getQuick(i).toTop();
        }
        this.currentCursor = this.shardCursors.getQuick(0);
        this.currentIndex = 0;
    }

    private static long toRowId(int shardIndex, long shardRowId) {
        return ((long)shardIndex << 48) + shardRowId;
    }

    private static int toShardIndex(long rowId) {
        return (int)(rowId >>> 48);
    }

    private static long toShardRowId(long rowId) {
        return rowId & 0xFFFFFFFFFFFFL;
    }

    private class ShardedMapRecord
    implements MapRecord {
        private final boolean isPrimary;
        private MapRecord baseRecord;
        private int shardIndex;

        private ShardedMapRecord(boolean isPrimary) {
            this.isPrimary = isPrimary;
        }

        @Override
        public void copyToKey(MapKey destKey) {
            this.baseRecord.copyToKey(destKey);
        }

        @Override
        public void copyValue(MapValue destValue) {
            this.baseRecord.copyValue(destValue);
        }

        @Override
        public ArrayView getArray(int col, int columnType) {
            return this.baseRecord.getArray(col, columnType);
        }

        @Override
        public BinarySequence getBin(int columnIndex) {
            return this.baseRecord.getBin(columnIndex);
        }

        @Override
        public long getBinLen(int columnIndex) {
            return this.baseRecord.getBinLen(columnIndex);
        }

        @Override
        public boolean getBool(int columnIndex) {
            return this.baseRecord.getBool(columnIndex);
        }

        @Override
        public byte getByte(int columnIndex) {
            return this.baseRecord.getByte(columnIndex);
        }

        @Override
        public char getChar(int columnIndex) {
            return this.baseRecord.getChar(columnIndex);
        }

        @Override
        public double getDouble(int columnIndex) {
            return this.baseRecord.getDouble(columnIndex);
        }

        @Override
        public float getFloat(int columnIndex) {
            return this.baseRecord.getFloat(columnIndex);
        }

        @Override
        public byte getGeoByte(int columnIndex) {
            return this.baseRecord.getGeoByte(columnIndex);
        }

        @Override
        public int getGeoInt(int columnIndex) {
            return this.baseRecord.getGeoInt(columnIndex);
        }

        @Override
        public long getGeoLong(int columnIndex) {
            return this.baseRecord.getGeoLong(columnIndex);
        }

        @Override
        public short getGeoShort(int columnIndex) {
            return this.baseRecord.getGeoShort(columnIndex);
        }

        @Override
        public int getIPv4(int columnIndex) {
            return this.baseRecord.getIPv4(columnIndex);
        }

        @Override
        public int getInt(int columnIndex) {
            return this.baseRecord.getInt(columnIndex);
        }

        @Override
        public long getLong(int columnIndex) {
            return this.baseRecord.getLong(columnIndex);
        }

        @Override
        public long getLong128Hi(int columnIndex) {
            return this.baseRecord.getLong128Hi(columnIndex);
        }

        @Override
        public long getLong128Lo(int columnIndex) {
            return this.baseRecord.getLong128Lo(columnIndex);
        }

        @Override
        public void getLong256(int columnIndex, CharSink<?> sink) {
            this.baseRecord.getLong256(columnIndex, sink);
        }

        @Override
        public Long256 getLong256A(int columnIndex) {
            return this.baseRecord.getLong256A(columnIndex);
        }

        @Override
        public Long256 getLong256B(int columnIndex) {
            return this.baseRecord.getLong256B(columnIndex);
        }

        @Override
        public long getRowId() {
            return ShardedMapCursor.toRowId(this.shardIndex, this.baseRecord.getRowId());
        }

        @Override
        public short getShort(int columnIndex) {
            return this.baseRecord.getShort(columnIndex);
        }

        @Override
        public CharSequence getStrA(int columnIndex) {
            return this.baseRecord.getStrA(columnIndex);
        }

        @Override
        public CharSequence getStrB(int columnIndex) {
            return this.baseRecord.getStrB(columnIndex);
        }

        @Override
        public int getStrLen(int columnIndex) {
            return this.baseRecord.getStrLen(columnIndex);
        }

        @Override
        public CharSequence getSymA(int columnIndex) {
            return this.baseRecord.getSymA(columnIndex);
        }

        @Override
        public CharSequence getSymB(int columnIndex) {
            return this.baseRecord.getSymB(columnIndex);
        }

        @Override
        public MapValue getValue() {
            return this.baseRecord.getValue();
        }

        @Override
        public Utf8Sequence getVarcharA(int col) {
            return this.baseRecord.getVarcharA(col);
        }

        @Override
        public Utf8Sequence getVarcharB(int col) {
            return this.baseRecord.getVarcharB(col);
        }

        @Override
        public int getVarcharSize(int columnIndex) {
            return this.baseRecord.getVarcharSize(columnIndex);
        }

        @Override
        public long keyHashCode() {
            return this.baseRecord.keyHashCode();
        }

        @Override
        public void setSymbolTableResolver(RecordCursor resolver, IntList symbolTableIndex) {
            int n = ShardedMapCursor.this.shardCursors.size();
            for (int i = 0; i < n; ++i) {
                if (this.isPrimary) {
                    ShardedMapCursor.this.shardCursors.getQuick(i).getRecord().setSymbolTableResolver(resolver, symbolTableIndex);
                    continue;
                }
                ShardedMapCursor.this.shardCursors.getQuick(i).getRecordB().setSymbolTableResolver(resolver, symbolTableIndex);
            }
        }

        void at(int shardIndex, long rowId) {
            MapRecordCursor baseCursor = ShardedMapCursor.this.shardCursors.getQuick(shardIndex);
            this.baseRecord = this.isPrimary ? baseCursor.getRecord() : baseCursor.getRecordB();
            this.shardIndex = shardIndex;
            baseCursor.recordAt(this.baseRecord, rowId);
        }

        void of(MapRecord baseRecord, int shardIndex) {
            this.baseRecord = baseRecord;
            this.shardIndex = shardIndex;
        }
    }
}

