/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.frm.file;

import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.frm.FrameColumn;
import io.questdb.cairo.frm.file.ContiguousFileFixFrameColumn;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;

public class ContiguousFileIndexedFrameColumn
extends ContiguousFileFixFrameColumn {
    private final BitmapIndexWriter indexWriter;

    public ContiguousFileIndexedFrameColumn(CairoConfiguration configuration) {
        super(configuration);
        this.indexWriter = new BitmapIndexWriter(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(long appendOffsetRowCount, FrameColumn sourceColumn, long sourceLo, long sourceHi, int commitMode) {
        super.append(appendOffsetRowCount, sourceColumn, sourceLo, sourceHi, commitMode);
        long fd = super.getPrimaryFd();
        int shl = ColumnType.pow2SizeOf(this.getColumnType());
        long size = sourceHi - sourceLo;
        assert (size >= 0L);
        if (size > 0L) {
            long mappedAddress = TableUtils.mapAppendColumnBuffer(this.ff, fd, appendOffsetRowCount - this.getColumnTop() << shl, size << shl, false, 12);
            try {
                this.indexWriter.rollbackConditionally(appendOffsetRowCount);
                for (long i = 0L; i < size; ++i) {
                    this.indexWriter.add(TableUtils.toIndexKey(Unsafe.getUnsafe().getInt(mappedAddress + (i << shl))), appendOffsetRowCount + i);
                }
                this.indexWriter.setMaxValue(appendOffsetRowCount + size - 1L);
                this.indexWriter.commit();
            }
            finally {
                TableUtils.mapAppendColumnBufferRelease(this.ff, mappedAddress, appendOffsetRowCount - this.getColumnTop() << shl, size << shl, 12);
            }
        }
    }

    @Override
    public void appendNulls(long rowCount, long sourceColumnTop, int commitMode) {
        super.appendNulls(rowCount, sourceColumnTop, commitMode);
        this.indexWriter.rollbackConditionally(rowCount);
        for (long i = 0L; i < sourceColumnTop; ++i) {
            this.indexWriter.add(0, rowCount + i);
        }
        this.indexWriter.setMaxValue(rowCount + sourceColumnTop - 1L);
        this.indexWriter.commit();
    }

    @Override
    public void close() {
        this.indexWriter.close();
        super.close();
    }

    public void ofRW(Path partitionPath, CharSequence columnName, long columnTxn, int columnType, int indexBlockCapacity, long columnTop, int columnIndex, boolean isEmpty) {
        super.ofRW(partitionPath, columnName, columnTxn, columnType, columnTop, columnIndex);
        try {
            this.indexWriter.of(partitionPath, columnName, columnTxn, isEmpty ? indexBlockCapacity : 0);
        }
        catch (Throwable e) {
            super.close();
        }
    }

    @Override
    public void ofRW(Path partitionPath, CharSequence columnName, long columnTxn, int columnType, long columnTop, int columnIndex) {
        this.closed = false;
        super.close();
        throw new UnsupportedOperationException();
    }

    private int keyCount(int key, long size, long mappedAddress) {
        int count = 0;
        for (long i = 0L; i < size; ++i) {
            if (TableUtils.toIndexKey(Unsafe.getUnsafe().getInt(mappedAddress + (i << 2))) != key) continue;
            ++count;
        }
        return count;
    }
}

