/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.arr;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.FlatArrayView;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.std.Numbers;

public final class SingleElementDoubleArray
extends ArrayView {
    private double value;

    public SingleElementDoubleArray(int dimCount) {
        this.flatView = new SingleElementFlatArrayView();
        this.type = ColumnType.encodeArrayType((short)10, dimCount);
        for (int i = 0; i < dimCount; ++i) {
            this.shape.add(1);
            this.strides.add(1);
        }
        this.flatViewLength = 1;
    }

    public void of(double value) {
        this.value = value;
    }

    private class SingleElementFlatArrayView
    implements FlatArrayView {
        private SingleElementFlatArrayView() {
        }

        @Override
        public void appendToMemFlat(MemoryA mem, int offset, int length) {
            if (length == 1) {
                mem.putDouble(SingleElementDoubleArray.this.value);
            }
        }

        @Override
        public double avgDouble(int offset, int length) {
            return length == 0 ? Double.NaN : SingleElementDoubleArray.this.value;
        }

        @Override
        public int countDouble(int offset, int length) {
            return length == 0 || Numbers.isNull(SingleElementDoubleArray.this.value) ? 0 : 1;
        }

        @Override
        public double getDoubleAtAbsIndex(int elemIndex) {
            return SingleElementDoubleArray.this.value;
        }

        @Override
        public long getLongAtAbsIndex(int elemIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int length() {
            return 1;
        }

        @Override
        public double sumDouble(int offset, int length) {
            return length == 0 ? 0.0 : SingleElementDoubleArray.this.value;
        }
    }
}

