/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.arr;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;

public class MutableArray
extends ArrayView {
    public final void copyShapeFrom(ArrayView source) {
        int nDims = this.getDimCount();
        if (source.getDimCount() != nDims) {
            throw CairoException.nonCritical().put("source array doesn't have the same dimensionality [nDimsThis=").put(nDims).put(", nDimsSource=").put(source.getDimCount()).put(']');
        }
        for (int i = 0; i < nDims; ++i) {
            this.shape.set(i, source.shape.getQuick(i));
        }
    }

    public final void setDimLen(int dimension, int length) {
        if (length < 0) {
            throw CairoException.nonCritical().put("dimension length must not be negative [dim=").put(dimension).put(", dimLen=").put(length).put(']');
        }
        if (length > 0xFFFFFFF) {
            throw CairoException.nonCritical().put("dimension length out of range [dim=").put(dimension).put(", dimLen=").put(length).put(", maxLen=").put(0xFFFFFFFL);
        }
        this.shape.set(dimension, length);
    }

    public final void setType(int encodedType) {
        assert (ColumnType.isArray(encodedType));
        this.type = encodedType;
        this.shape.clear();
        this.strides.clear();
        this.flatViewLength = 0;
        int nDims = ColumnType.decodeArrayDimensionality(encodedType);
        this.shape.checkCapacity(nDims);
        this.strides.checkCapacity(nDims);
        for (int i = 0; i < nDims; ++i) {
            this.shape.add(0);
        }
    }

    private int maxPossibleElemCount() {
        short elemType = ColumnType.decodeArrayElementType(this.type);
        return Integer.MAX_VALUE >> (elemType != 0 ? ColumnType.pow2SizeOf(elemType) : 0);
    }

    protected final void resetToDefaultStrides() {
        this.resetToDefaultStrides(0xFFFFFFF, -1);
    }

    protected final void resetToDefaultStrides(int maxArrayElemCount, int errorPos) {
        assert (maxArrayElemCount <= this.maxPossibleElemCount()) : "maxArrayElemCount > " + this.maxPossibleElemCount();
        int nDims = this.shape.size();
        this.strides.clear();
        for (int i = 0; i < nDims; ++i) {
            this.strides.add(0);
        }
        if (this.isEmpty()) {
            this.flatViewLength = 0;
            return;
        }
        int stride = 1;
        for (int i = nDims - 1; i >= 0; --i) {
            int dimLen = this.shape.get(i);
            this.strides.set(i, stride);
            try {
                stride = Math.multiplyExact(stride, dimLen);
                if (stride <= maxArrayElemCount) continue;
                throw new ArithmeticException();
            }
            catch (ArithmeticException e) {
                throw CairoException.nonCritical().position(errorPos).put("array element count exceeds max [max=").put(maxArrayElemCount).put(", shape=").put(this.shape).put(']');
            }
        }
        this.flatViewLength = stride;
    }
}

