/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Numbers;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;

public class TxnScoreboardV1
implements TxnScoreboard {
    private static final Log LOG = LogFactory.getLog(TxnScoreboard.class);
    private final FilesFacade ff;
    private final int pow2EntryCount;
    private final long size;
    private long fd = -1L;
    private long mem;
    private TableToken tableToken;

    public TxnScoreboardV1(FilesFacade ff, int entryCount, TableToken tableToken) {
        this.ff = ff;
        this.pow2EntryCount = Numbers.ceilPow2(entryCount);
        this.size = TxnScoreboardV1.getScoreboardSize(this.pow2EntryCount);
        this.tableToken = tableToken;
    }

    public static native long getScoreboardSize(int var0);

    @Override
    public boolean acquireTxn(int id, long txn) {
        assert (txn > -1L);
        long internalTxn = TxnScoreboardV1.toInternalTxn(txn);
        long response = TxnScoreboardV1.acquireTxn(this.mem, internalTxn);
        if (response == 0L) {
            return true;
        }
        if (response == -1L) {
            return false;
        }
        long min = TxnScoreboardV1.fromInternalTxn(-response - 2L);
        throw CairoException.critical(0).put("max txn-inflight limit reached [txn=").put(txn).put(", min=").put(min).put(", size=").put(this.pow2EntryCount).put(']');
    }

    @Override
    public void close() {
        if (this.mem != 0L) {
            this.ff.munmap(this.mem, this.size, 0);
            this.mem = 0L;
        }
        if (this.ff.close(this.fd)) {
            LOG.debug().$("closed [fd=").$(this.fd).I$();
            this.fd = -1L;
        }
    }

    public long getActiveReaderCount(long txn) {
        return TxnScoreboardV1.getCount(this.mem, TxnScoreboardV1.toInternalTxn(txn));
    }

    @Override
    public int getEntryCount() {
        return this.pow2EntryCount;
    }

    public long getMin() {
        long min = TxnScoreboardV1.getMin(this.mem);
        if (min == 0L) {
            return 0L;
        }
        return TxnScoreboardV1.fromInternalTxn(min);
    }

    @Override
    public TableToken getTableToken() {
        return this.tableToken;
    }

    @Override
    public boolean hasEarlierTxnLocks(long maxTxn) {
        try {
            if (this.acquireTxn(0, maxTxn)) {
                this.releaseTxn(0, maxTxn);
            }
            return this.getMin() < maxTxn;
        }
        catch (CairoException ex) {
            LOG.critical().$("cannot lock last txn in scoreboard, partition purge will be scheduled [table=").$(this.tableToken).$(", error=").$safe(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
            return this.getMin() < maxTxn;
        }
    }

    @Override
    public boolean incrementTxn(int id, long txn) {
        assert (txn > -1L);
        long internalTxn = TxnScoreboardV1.toInternalTxn(txn);
        return TxnScoreboardV1.incrementTxnScoreboardMem(this.mem, internalTxn);
    }

    @Override
    public boolean isOutdated(long txn) {
        return true;
    }

    @Override
    public boolean isRangeAvailable(long fromTxn, long toTxn) {
        return TxnScoreboardV1.isRangeAvailable0(this.mem, TxnScoreboardV1.toInternalTxn(fromTxn), TxnScoreboardV1.toInternalTxn(toTxn));
    }

    @Override
    public boolean isTxnAvailable(long txn) {
        return TxnScoreboardV1.getCount(this.mem, TxnScoreboardV1.toInternalTxn(txn)) <= 0L;
    }

    public TxnScoreboard ofRW(TableToken tableToken, Path root) {
        this.tableToken = tableToken;
        int rootLen = root.size();
        root.concat("_txn_scoreboard");
        this.fd = TxnScoreboardV1.openCleanRW(this.ff, root.$(), this.size);
        try {
            if (this.ff.length(this.fd) != this.size) {
                this.ff.truncate(this.fd, this.size);
            }
            try {
                this.mem = TableUtils.mapRW(this.ff, this.fd, this.size, 0);
                TxnScoreboardV1.init(this.mem, this.pow2EntryCount);
            }
            catch (Throwable e) {
                this.ff.close(this.fd);
                root.trimTo(rootLen);
                this.fd = -1L;
                throw e;
            }
            return this;
        }
        catch (Throwable th) {
            this.ff.close(this.fd);
            throw th;
        }
    }

    @Override
    public long releaseTxn(int id, long txn) {
        long released = TxnScoreboardV1.releaseTxn(this.mem, txn);
        assert (released > -1L) : "released count " + txn + " must be positive: " + (released + 1L);
        return released;
    }

    private static long acquireTxn(long pTxnScoreboard, long txn) {
        assert (pTxnScoreboard > 0L);
        LOG.debug().$("acquire [p=").$(pTxnScoreboard).$(", txn=").$(TxnScoreboardV1.fromInternalTxn(txn)).I$();
        return TxnScoreboardV1.acquireTxn0(pTxnScoreboard, txn);
    }

    private static native long acquireTxn0(long var0, long var2);

    private static long fromInternalTxn(long txn) {
        return txn - 1L;
    }

    private static native long getCount(long var0, long var2);

    private static native long getMin(long var0);

    private static native boolean incrementTxn0(long var0, long var2);

    private static boolean incrementTxnScoreboardMem(long pTxnScoreboard, long txn) {
        assert (pTxnScoreboard > 0L);
        LOG.debug().$("increment [p=").$(pTxnScoreboard).$(", txn=").$(TxnScoreboardV1.fromInternalTxn(txn)).I$();
        return TxnScoreboardV1.incrementTxn0(pTxnScoreboard, txn);
    }

    private static native void init(long var0, int var2);

    private static native boolean isRangeAvailable0(long var0, long var2, long var4);

    private static long openCleanRW(FilesFacade ff, LPSZ path, long size) {
        long fd = ff.openCleanRW(path, size);
        if (fd > -1L) {
            LOG.debug().$("open clean [file=").$(path).$(", fd=").$(fd).I$();
            return fd;
        }
        throw CairoException.critical(ff.errno()).put("could not open read-write with clean allocation [file=").put(path).put(']');
    }

    private static long releaseTxn(long pTxnScoreboard, long txn) {
        assert (pTxnScoreboard > 0L);
        LOG.debug().$("release  [p=").$(pTxnScoreboard).$(", txn=").$(txn).I$();
        long internalTxn = TxnScoreboardV1.toInternalTxn(txn);
        return TxnScoreboardV1.releaseTxn0(pTxnScoreboard, internalTxn);
    }

    private static native long releaseTxn0(long var0, long var2);

    private static long toInternalTxn(long txn) {
        return txn + 1L;
    }
}

