/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ConcurrentBitmapIndexFwdReader;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Hash;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectString;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

public class SymbolMapReaderImpl
implements Closeable,
SymbolMapReader {
    private static final Log LOG = LogFactory.getLog(SymbolMapReaderImpl.class);
    private final ObjList<String> cache = new ObjList();
    private final MemoryCMR charMem = Vm.getCMRInstance();
    private final StringSink columnNameSink = new StringSink();
    private final ConcurrentBitmapIndexFwdReader indexReader = new ConcurrentBitmapIndexFwdReader();
    private final MemoryCMR offsetMem = Vm.getCMRInstance();
    private final Path path = new Path();
    private boolean cached;
    private long columnNameTxn;
    private CairoConfiguration configuration;
    private int maxHash;
    private long maxOffset;
    private boolean nullValue;
    private int symbolCapacity;
    private int symbolCount;

    public SymbolMapReaderImpl() {
    }

    public SymbolMapReaderImpl(CairoConfiguration configuration, Path path, CharSequence name, long columnNameTxn, int symbolCount) {
        this.of(configuration, path, name, columnNameTxn, symbolCount);
    }

    @Override
    public void close() {
        Misc.free(this.indexReader);
        Misc.free(this.charMem);
        this.cache.clear();
        long fd = this.offsetMem.getFd();
        Misc.free(this.offsetMem);
        Misc.free(this.path);
        LOG.debug().$("closed [fd=").$(fd).$(']').$();
    }

    @Override
    public boolean containsNullValue() {
        return this.nullValue;
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    @Override
    public int getSymbolCapacity() {
        return this.symbolCapacity;
    }

    @Override
    public int getSymbolCount() {
        return this.symbolCount;
    }

    @Override
    public MemoryR getSymbolOffsetsColumn() {
        return this.offsetMem;
    }

    @Override
    public MemoryR getSymbolValuesColumn() {
        return this.charMem;
    }

    @Override
    public boolean isCached() {
        return this.cached;
    }

    @Override
    public boolean isDeleted() {
        return this.offsetMem.isDeleted();
    }

    @Override
    public int keyOf(CharSequence value) {
        if (value != null) {
            int hash = Hash.boundedHash(value, this.maxHash);
            RowCursor cursor = this.indexReader.getCursor(true, hash, 0L, this.maxOffset - 8L);
            while (cursor.hasNext()) {
                long offsetOffset = cursor.next();
                if (!Chars.equals(value, this.charMem.getStrA(this.offsetMem.getLong(offsetOffset)))) continue;
                return SymbolMapWriter.offsetToKey(offsetOffset);
            }
            return -2;
        }
        return Integer.MIN_VALUE;
    }

    public boolean needsReopen(long columnNameTxn) {
        return this.columnNameTxn != columnNameTxn;
    }

    @Override
    public StaticSymbolTable newSymbolTableView() {
        return new SymbolTableView();
    }

    public void of(CairoConfiguration configuration, Path path, CharSequence columnName, long columnNameTxn, int symbolCount) {
        FilesFacade ff = configuration.getFilesFacade();
        this.configuration = configuration;
        this.path.of(path);
        this.columnNameSink.clear();
        this.columnNameSink.put(columnName);
        this.columnNameTxn = columnNameTxn;
        this.symbolCount = symbolCount;
        this.maxOffset = SymbolMapWriter.keyToOffset(symbolCount);
        int plen = path.size();
        try {
            if (!ff.exists(TableUtils.offsetFileName(path.trimTo(plen), columnName, columnNameTxn))) {
                LOG.error().$(path).$(" is not found").$();
                throw CairoException.fileNotFound().put("SymbolMap does not exist: ").put(path);
            }
            long len = ff.length(path.$());
            if (len < 64L) {
                LOG.error().$(path).$(" is too short [len=").$(len).$(']').$();
                throw CairoException.critical(0).put("SymbolMap is too short: ").put(path);
            }
            long offsetMemSize = SymbolMapWriter.keyToOffset(symbolCount) + 8L;
            LOG.debug().$("offsetMem.of [columnName=").$(path).$(",offsetMemSize=").$(offsetMemSize).I$();
            this.offsetMem.of(ff, path.$(), offsetMemSize, offsetMemSize, 3);
            this.symbolCapacity = this.offsetMem.getInt(0L);
            assert (this.symbolCapacity > 0);
            this.cached = this.offsetMem.getBool(4L);
            this.nullValue = this.offsetMem.getBool(8L);
            this.indexReader.of(configuration, path.trimTo(plen), columnName, columnNameTxn, -1L, 0L);
            this.charMem.wholeFile(ff, TableUtils.charFileName(path.trimTo(plen), columnName, columnNameTxn), 3);
            this.charMem.extend(this.offsetMem.getLong(this.maxOffset));
            this.maxHash = Math.max(Numbers.ceilPow2(this.symbolCapacity / 2) - 1, 1);
            if (this.cached) {
                this.cache.setPos(this.symbolCapacity);
            }
            this.cache.clear();
            LOG.debug().$("open [columnName=").$(path.trimTo(plen).concat(columnName).$()).$(", fd=").$(this.offsetMem.getFd()).$(", capacity=").$(this.symbolCapacity).I$();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        finally {
            path.trimTo(plen);
        }
    }

    @Override
    public void updateSymbolCount(int symbolCount) {
        if (symbolCount > this.symbolCount) {
            this.symbolCount = symbolCount;
            this.maxOffset = SymbolMapWriter.keyToOffset(symbolCount);
            this.offsetMem.extend(this.maxOffset + 8L);
            this.charMem.extend(this.offsetMem.getLong(this.maxOffset));
        } else if (symbolCount < this.symbolCount) {
            this.cache.remove(symbolCount + 1, this.symbolCount);
            this.symbolCount = symbolCount;
        }
        this.nullValue = this.offsetMem.getBool(8L);
        this.indexReader.of(this.configuration, this.path, this.columnNameSink, this.columnNameTxn, -1L, 0L);
    }

    @Override
    public CharSequence valueBOf(int key) {
        if (key > -1 && key < this.symbolCount) {
            if (this.cached) {
                return this.cachedValue(key);
            }
            return this.uncachedValue2(key);
        }
        return null;
    }

    @Override
    public CharSequence valueOf(int key) {
        if (key > -1 && key < this.symbolCount) {
            if (this.cached) {
                return this.cachedValue(key);
            }
            return this.uncachedValue(key);
        }
        return null;
    }

    private CharSequence cachedValue(int key) {
        String symbol = this.cache.getQuiet(key);
        return symbol != null ? symbol : this.fetchAndCache(key);
    }

    private CharSequence fetchAndCache(int key) {
        CharSequence cs = this.uncachedValue(key);
        assert (cs != null);
        String symbol = Chars.toString(cs);
        this.cache.extendAndSet(key, symbol);
        return symbol;
    }

    private CharSequence uncachedValue(int key) {
        return this.charMem.getStrA(this.offsetMem.getLong(SymbolMapWriter.keyToOffset(key)));
    }

    private CharSequence uncachedValue2(int key) {
        return this.charMem.getStrB(this.offsetMem.getLong(SymbolMapWriter.keyToOffset(key)));
    }

    private class SymbolTableView
    implements StaticSymbolTable {
        private final DirectString csviewA = new DirectString();
        private final DirectString csviewB = new DirectString();
        private final DirectString csviewInternal = new DirectString();
        private RowCursor rowCursor;

        private SymbolTableView() {
        }

        @Override
        public boolean containsNullValue() {
            return SymbolMapReaderImpl.this.nullValue;
        }

        @Override
        public int getSymbolCount() {
            return SymbolMapReaderImpl.this.symbolCount;
        }

        @Override
        public int keyOf(CharSequence value) {
            if (value != null) {
                int hash = Hash.boundedHash(value, SymbolMapReaderImpl.this.maxHash);
                this.rowCursor = SymbolMapReaderImpl.this.indexReader.initCursor(this.rowCursor, hash, 0L, SymbolMapReaderImpl.this.maxOffset - 8L);
                while (this.rowCursor.hasNext()) {
                    long offsetOffset = this.rowCursor.next();
                    if (!Chars.equals(value, SymbolMapReaderImpl.this.charMem.getStr(SymbolMapReaderImpl.this.offsetMem.getLong(offsetOffset), this.csviewInternal))) continue;
                    return SymbolMapWriter.offsetToKey(offsetOffset);
                }
                return -2;
            }
            return Integer.MIN_VALUE;
        }

        @Override
        public CharSequence valueBOf(int key) {
            if (key > -1 && key < SymbolMapReaderImpl.this.symbolCount) {
                return this.uncachedValue2(key);
            }
            return null;
        }

        @Override
        public CharSequence valueOf(int key) {
            if (key > -1 && key < SymbolMapReaderImpl.this.symbolCount) {
                return this.uncachedValue(key);
            }
            return null;
        }

        private CharSequence uncachedValue(int key) {
            return SymbolMapReaderImpl.this.charMem.getStr(SymbolMapReaderImpl.this.offsetMem.getLong(SymbolMapWriter.keyToOffset(key)), this.csviewA);
        }

        private CharSequence uncachedValue2(int key) {
            return SymbolMapReaderImpl.this.charMem.getStr(SymbolMapReaderImpl.this.offsetMem.getLong(SymbolMapWriter.keyToOffset(key)), this.csviewB);
        }
    }
}

