/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkSPI;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.BorrowedArray;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.std.BinarySequence;
import io.questdb.std.DirectByteSequenceView;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectString;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.Utf8Sequence;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class RecordChain
implements Closeable,
RecordCursor,
RecordSinkSPI,
WindowSPI,
Reopenable {
    protected final int columnCount;
    protected final long fixOffset;
    protected final MemoryCARW mem;
    protected final RecordChainRecord recordA;
    protected final RecordChainRecord recordB;
    protected final RecordSink recordSink;
    protected final long varOffset;
    private final long[] columnOffsets;
    protected long recordOffset;
    protected long varAppendOffset = 0L;
    private long nextRecordOffset = -1L;
    private RecordChainRecord recordC;
    private SymbolTableSource symbolTableResolver;

    public RecordChain(@NotNull ColumnTypes columnTypes, @NotNull RecordSink recordSink, long pageSize, int maxPages) {
        try {
            this.mem = Vm.getCARWInstance(pageSize, maxPages, 50);
            this.recordSink = recordSink;
            this.columnCount = columnTypes.getColumnCount();
            this.recordA = this.newChainRecord();
            this.recordB = this.newChainRecord();
            long varOffset = 0L;
            long fixOffset = 0L;
            this.columnOffsets = new long[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                int type = columnTypes.getColumnType(i);
                if (ColumnType.isVarSize(type)) {
                    this.columnOffsets[i] = varOffset;
                    varOffset += 8L;
                    continue;
                }
                this.columnOffsets[i] = fixOffset;
                fixOffset += (long)ColumnType.sizeOf(type);
            }
            this.varOffset = varOffset;
            this.fixOffset = fixOffset;
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public long addressOf(long offset) {
        return this.mem.addressOf(offset);
    }

    public long beginRecord(long prevOffset) {
        this.mem.putLong(this.varAppendOffset, -1L);
        this.recordOffset = this.varAppendOffset;
        if (prevOffset != -1L) {
            this.mem.putLong(prevOffset, this.recordOffset);
        }
        this.mem.jumpTo(this.rowToDataOffset(this.recordOffset + this.varOffset));
        this.varAppendOffset = this.rowToDataOffset(this.recordOffset + this.varOffset + this.fixOffset);
        return this.recordOffset;
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        long result = 0L;
        while (this.nextRecordOffset != -1L) {
            ++result;
            this.nextRecordOffset = this.mem.getLong(this.nextRecordOffset);
        }
        counter.add(result);
    }

    public void clear() {
        this.mem.close();
        this.nextRecordOffset = -1L;
        this.varAppendOffset = 0L;
    }

    @Override
    public void close() {
        this.clear();
        this.symbolTableResolver = null;
    }

    @Override
    public long getAddress(long recordOffset, int columnIndex) {
        return this.addressOf(this.getOffsetOfColumn(recordOffset, columnIndex));
    }

    public long getOffsetOfColumn(long recordOffset, int columnIndex) {
        return this.rowToDataOffset(recordOffset) + this.varOffset + this.columnOffsets[columnIndex];
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public Record getRecordAt(long recordOffset) {
        if (this.recordC == null) {
            this.recordC = this.newChainRecord();
        }
        this.recordC.of(this.rowToDataOffset(recordOffset));
        return this.recordC;
    }

    @Override
    public Record getRecordB() {
        return this.recordB;
    }

    @Override
    public boolean hasNext() {
        if (this.nextRecordOffset != -1L) {
            long offset = this.nextRecordOffset;
            this.nextRecordOffset = this.mem.getLong(this.nextRecordOffset);
            this.recordA.of(this.rowToDataOffset(offset));
            return true;
        }
        return false;
    }

    public void of(long nextRecordOffset) {
        assert (nextRecordOffset == -1L || nextRecordOffset > -1L && nextRecordOffset + 8L <= this.mem.size());
        this.nextRecordOffset = nextRecordOffset;
    }

    public long put(Record record, long prevRecordOffset) {
        long offset = this.beginRecord(prevRecordOffset);
        this.recordSink.copy(record, this);
        return offset;
    }

    @Override
    public void putArray(@NotNull ArrayView value) {
        this.mem.putLong(this.rowToDataOffset(this.recordOffset), this.varAppendOffset);
        this.recordOffset += 8L;
        long byteCount = ArrayTypeDriver.getPlainValueSize(value);
        long appendAddress = this.mem.appendAddressFor(this.varAppendOffset, byteCount);
        ArrayTypeDriver.appendPlainValue(appendAddress, value);
        this.varAppendOffset += byteCount;
    }

    @Override
    public void putBin(BinarySequence value) {
        if (value == null) {
            this.putNull();
        } else {
            long offset = this.mem.getAppendOffset();
            this.mem.putLong(this.rowToDataOffset(this.recordOffset), this.varAppendOffset);
            this.recordOffset += 8L;
            this.mem.jumpTo(this.varAppendOffset);
            this.mem.putBin(value);
            this.varAppendOffset = this.mem.getAppendOffset();
            this.mem.jumpTo(offset);
        }
    }

    @Override
    public void putBool(boolean value) {
        this.mem.putBool(value);
    }

    @Override
    public void putByte(byte value) {
        this.mem.putByte(value);
    }

    @Override
    public void putChar(char value) {
        this.mem.putChar(value);
    }

    @Override
    public void putDate(long date) {
        this.putLong(date);
    }

    @Override
    public void putDouble(double value) {
        this.mem.putDouble(value);
    }

    @Override
    public void putFloat(float value) {
        this.mem.putFloat(value);
    }

    @Override
    public void putIPv4(int value) {
        this.putInt(value);
    }

    @Override
    public void putInt(int value) {
        this.mem.putInt(value);
    }

    @Override
    public void putInterval(Interval interval) {
        this.mem.putLong128(interval.getLo(), interval.getHi());
    }

    @Override
    public void putLong(long value) {
        this.mem.putLong(value);
    }

    @Override
    public void putLong128(long lo, long hi) {
        this.mem.putLong128(lo, hi);
    }

    @Override
    public void putLong256(Long256 value) {
        this.mem.putLong256(value);
    }

    @Override
    public void putLong256(long l0, long l1, long l2, long l3) {
        this.mem.putLong256(l0, l1, l2, l3);
    }

    @Override
    public void putRecord(Record value) {
    }

    @Override
    public void putShort(short value) {
        this.mem.putShort(value);
    }

    @Override
    public void putStr(CharSequence value) {
        if (value != null) {
            this.mem.putLong(this.rowToDataOffset(this.recordOffset), this.varAppendOffset);
            this.recordOffset += 8L;
            this.mem.putStr(this.varAppendOffset, value);
            this.varAppendOffset += Vm.getStorageLength(value.length());
        } else {
            this.putNull();
        }
    }

    @Override
    public void putStr(CharSequence value, int lo, int hi) {
        int len = hi - lo;
        this.mem.putLong(this.rowToDataOffset(this.recordOffset), this.varAppendOffset);
        this.recordOffset += 8L;
        this.mem.putStr(this.varAppendOffset, value, lo, len);
        this.varAppendOffset += Vm.getStorageLength(len);
    }

    @Override
    public void putTimestamp(long value) {
        this.putLong(value);
    }

    @Override
    public void putVarchar(Utf8Sequence value) {
        if (value != null) {
            this.mem.putLong(this.rowToDataOffset(this.recordOffset), this.varAppendOffset);
            this.recordOffset += 8L;
            int byteCount = VarcharTypeDriver.getSingleMemValueByteCount(value);
            long appendAddress = this.mem.appendAddressFor(this.varAppendOffset, byteCount);
            VarcharTypeDriver.appendPlainValue(appendAddress, value, false);
            this.varAppendOffset += (long)byteCount;
        } else {
            this.putNull();
        }
    }

    @Override
    public void recordAt(Record record, long row) {
        ((RecordChainRecord)record).of(this.rowToDataOffset(row));
    }

    @Override
    public void reopen() {
    }

    public void setSymbolTableResolver(SymbolTableSource resolver) {
        this.symbolTableResolver = resolver;
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void skip(int bytes) {
        this.mem.skip(bytes);
    }

    @Override
    public long preComputedStateSize() {
        return 0L;
    }

    @Override
    public void toTop() {
        this.nextRecordOffset = this.mem.getAppendOffset() == 0L ? -1L : 0L;
    }

    private void putNull() {
        this.mem.putLong(this.rowToDataOffset(this.recordOffset), -1L);
        this.recordOffset += 8L;
    }

    protected RecordChainRecord newChainRecord() {
        return new RecordChainRecord(this.columnCount);
    }

    protected long rowToDataOffset(long row) {
        return row + 8L;
    }

    protected class RecordChainRecord
    implements Record {
        private final ObjList<BorrowedArray> arrays;
        private final ObjList<DirectByteSequenceView> bsViews;
        private final ObjList<DirectString> csViewsA;
        private final ObjList<DirectString> csViewsB;
        private final ObjList<Interval> intervals;
        private final ObjList<Long256Impl> longs256A;
        private final ObjList<Long256Impl> longs256B;
        private final ObjList<DirectUtf8String> utf8ViewsA;
        private final ObjList<DirectUtf8String> utf8ViewsB;
        protected long baseOffset;
        private long fixedOffset;

        public RecordChainRecord(int columnCount) {
            this.bsViews = new ObjList(columnCount);
            this.csViewsA = new ObjList(columnCount);
            this.csViewsB = new ObjList(columnCount);
            this.intervals = new ObjList(columnCount);
            this.longs256A = new ObjList(columnCount);
            this.longs256B = new ObjList(columnCount);
            this.utf8ViewsA = new ObjList(columnCount);
            this.utf8ViewsB = new ObjList(columnCount);
            this.arrays = new ObjList(columnCount);
        }

        @Override
        public ArrayView getArray(int col, int columnType) {
            long offset = this.varWidthColumnOffset(col);
            long addr = RecordChain.this.mem.addressOf(offset);
            return ArrayTypeDriver.getPlainValue(addr, this.array(col));
        }

        @Override
        public BinarySequence getBin(int col) {
            long offset = this.varWidthColumnOffset(col);
            return offset == -1L ? null : RecordChain.this.mem.getBin(offset, this.bsView(col));
        }

        @Override
        public long getBinLen(int col) {
            long offset = this.varWidthColumnOffset(col);
            return offset == -1L ? -1L : RecordChain.this.mem.getLong(offset);
        }

        @Override
        public boolean getBool(int col) {
            return RecordChain.this.mem.getBool(this.fixedWithColumnOffset(col));
        }

        @Override
        public byte getByte(int col) {
            return RecordChain.this.mem.getByte(this.fixedWithColumnOffset(col));
        }

        @Override
        public char getChar(int col) {
            return RecordChain.this.mem.getChar(this.fixedWithColumnOffset(col));
        }

        @Override
        public double getDouble(int col) {
            return RecordChain.this.mem.getDouble(this.fixedWithColumnOffset(col));
        }

        @Override
        public float getFloat(int col) {
            return RecordChain.this.mem.getFloat(this.fixedWithColumnOffset(col));
        }

        @Override
        public byte getGeoByte(int col) {
            return RecordChain.this.mem.getByte(this.fixedWithColumnOffset(col));
        }

        @Override
        public int getGeoInt(int col) {
            return RecordChain.this.mem.getInt(this.fixedWithColumnOffset(col));
        }

        @Override
        public long getGeoLong(int col) {
            return RecordChain.this.mem.getLong(this.fixedWithColumnOffset(col));
        }

        @Override
        public short getGeoShort(int col) {
            return RecordChain.this.mem.getShort(this.fixedWithColumnOffset(col));
        }

        @Override
        public int getIPv4(int col) {
            return RecordChain.this.mem.getIPv4(this.fixedWithColumnOffset(col));
        }

        @Override
        public int getInt(int col) {
            return RecordChain.this.mem.getInt(this.fixedWithColumnOffset(col));
        }

        @Override
        public Interval getInterval(int col) {
            long offset = this.fixedWithColumnOffset(col);
            return this.interval(col).of(RecordChain.this.mem.getLong(offset), RecordChain.this.mem.getLong(offset + 8L));
        }

        @Override
        public long getLong(int col) {
            return RecordChain.this.mem.getLong(this.fixedWithColumnOffset(col));
        }

        @Override
        public long getLong128Hi(int col) {
            return RecordChain.this.mem.getLong(this.fixedWithColumnOffset(col) + 8L);
        }

        @Override
        public long getLong128Lo(int col) {
            return RecordChain.this.mem.getLong(this.fixedWithColumnOffset(col));
        }

        @Override
        public void getLong256(int col, CharSink<?> sink) {
            RecordChain.this.mem.getLong256(this.fixedWithColumnOffset(col), sink);
        }

        @Override
        public Long256 getLong256A(int col) {
            Long256Impl long256 = this.long256A(col);
            RecordChain.this.mem.getLong256(this.fixedWithColumnOffset(col), long256);
            return long256;
        }

        @Override
        public Long256 getLong256B(int col) {
            Long256Impl long256 = this.long256B(col);
            RecordChain.this.mem.getLong256(this.fixedWithColumnOffset(col), long256);
            return long256;
        }

        @Override
        public long getLongIPv4(int col) {
            return Numbers.ipv4ToLong(RecordChain.this.mem.getIPv4(this.fixedWithColumnOffset(col)));
        }

        @Override
        public long getRowId() {
            return this.baseOffset - 8L;
        }

        @Override
        public short getShort(int col) {
            return RecordChain.this.mem.getShort(this.fixedWithColumnOffset(col));
        }

        @Override
        public CharSequence getStrA(int col) {
            long offset = this.varWidthColumnOffset(col);
            assert (offset > -2L);
            return offset == -1L ? null : RecordChain.this.mem.getStr(offset, this.csViewA(col));
        }

        @Override
        public CharSequence getStrB(int col) {
            long offset = this.varWidthColumnOffset(col);
            assert (offset > -2L);
            return offset == -1L ? null : RecordChain.this.mem.getStr(offset, this.csViewB(col));
        }

        @Override
        public int getStrLen(int col) {
            long offset = this.varWidthColumnOffset(col);
            if (offset > -1L) {
                return RecordChain.this.mem.getInt(offset);
            }
            return -1;
        }

        @Override
        public CharSequence getSymA(int col) {
            return RecordChain.this.symbolTableResolver.getSymbolTable(col).valueOf(this.getInt(col));
        }

        @Override
        public CharSequence getSymB(int col) {
            return RecordChain.this.symbolTableResolver.getSymbolTable(col).valueBOf(this.getInt(col));
        }

        @Override
        public Utf8Sequence getVarcharA(int col) {
            long offset = this.varWidthColumnOffset(col);
            if (offset == -1L) {
                return null;
            }
            long addr = RecordChain.this.mem.addressOf(offset);
            return VarcharTypeDriver.getPlainValue(addr, this.utf8ViewA(col));
        }

        @Override
        public Utf8Sequence getVarcharB(int col) {
            long offset = this.varWidthColumnOffset(col);
            if (offset == -1L) {
                return null;
            }
            long addr = RecordChain.this.mem.addressOf(offset);
            return VarcharTypeDriver.getPlainValue(addr, this.utf8ViewB(col));
        }

        @Override
        public int getVarcharSize(int col) {
            long offset = this.varWidthColumnOffset(col);
            if (offset > -1L) {
                return VarcharTypeDriver.getPlainValueSize(RecordChain.this.mem, offset);
            }
            return -1;
        }

        private BorrowedArray array(int columnIndex) {
            if (this.arrays.getQuiet(columnIndex) == null) {
                this.arrays.extendAndSet(columnIndex, new BorrowedArray());
            }
            return this.arrays.getQuick(columnIndex);
        }

        private DirectByteSequenceView bsView(int columnIndex) {
            if (this.bsViews.getQuiet(columnIndex) == null) {
                this.bsViews.extendAndSet(columnIndex, new DirectByteSequenceView());
            }
            return this.bsViews.getQuick(columnIndex);
        }

        private DirectString csViewA(int columnIndex) {
            if (this.csViewsA.getQuiet(columnIndex) == null) {
                this.csViewsA.extendAndSet(columnIndex, new DirectString());
            }
            return this.csViewsA.getQuick(columnIndex);
        }

        private DirectString csViewB(int columnIndex) {
            if (this.csViewsB.getQuiet(columnIndex) == null) {
                this.csViewsB.extendAndSet(columnIndex, new DirectString());
            }
            return this.csViewsB.getQuick(columnIndex);
        }

        private long fixedWithColumnOffset(int index) {
            return this.fixedOffset + RecordChain.this.columnOffsets[index];
        }

        private Interval interval(int columnIndex) {
            if (this.intervals.getQuiet(columnIndex) == null) {
                this.intervals.extendAndSet(columnIndex, new Interval());
            }
            return this.intervals.getQuick(columnIndex);
        }

        private Long256Impl long256A(int columnIndex) {
            if (this.longs256A.getQuiet(columnIndex) == null) {
                this.longs256A.extendAndSet(columnIndex, new Long256Impl());
            }
            return this.longs256A.getQuick(columnIndex);
        }

        private Long256Impl long256B(int columnIndex) {
            if (this.longs256B.getQuiet(columnIndex) == null) {
                this.longs256B.extendAndSet(columnIndex, new Long256Impl());
            }
            return this.longs256B.getQuick(columnIndex);
        }

        private DirectUtf8String utf8ViewA(int columnIndex) {
            if (this.utf8ViewsA.getQuiet(columnIndex) == null) {
                this.utf8ViewsA.extendAndSet(columnIndex, new DirectUtf8String());
            }
            return this.utf8ViewsA.getQuick(columnIndex);
        }

        private DirectUtf8String utf8ViewB(int columnIndex) {
            if (this.utf8ViewsB.getQuiet(columnIndex) == null) {
                this.utf8ViewsB.extendAndSet(columnIndex, new DirectUtf8String());
            }
            return this.utf8ViewsB.getQuick(columnIndex);
        }

        private long varWidthColumnOffset(int index) {
            return RecordChain.this.mem.getLong(this.baseOffset + RecordChain.this.columnOffsets[index]);
        }

        protected void of(long offset) {
            this.baseOffset = offset;
            this.fixedOffset = offset + RecordChain.this.varOffset;
        }
    }
}

